/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.DataConverter;
import java.math.BigInteger;

public class BigEndianDataConverter
implements DataConverter {
    public static final BigEndianDataConverter INSTANCE = new BigEndianDataConverter();
    private static final long serialVersionUID = 1L;

    @Override
    public final short getShort(byte[] b) {
        return this.getShort(b, 0);
    }

    @Override
    public short getShort(byte[] b, int offset) {
        return (short)((b[offset] & 0xFF) << 8 | b[offset + 1] & 0xFF);
    }

    @Override
    public final int getInt(byte[] b) {
        return this.getInt(b, 0);
    }

    @Override
    public int getInt(byte[] b, int offset) {
        int v = b[offset];
        for (int i = 1; i < 4; ++i) {
            v = v << 8 | b[offset + i] & 0xFF;
        }
        return v;
    }

    @Override
    public final long getLong(byte[] b) {
        return this.getLong(b, 0);
    }

    @Override
    public long getLong(byte[] b, int offset) {
        long v = b[offset];
        for (int i = 1; i < 8; ++i) {
            v = v << 8 | (long)(b[offset + i] & 0xFF);
        }
        return v;
    }

    @Override
    public long getValue(byte[] b, int size) {
        return this.getValue(b, 0, size);
    }

    @Override
    public long getValue(byte[] b, int offset, int size) {
        if (size > 8) {
            throw new IndexOutOfBoundsException("size exceeds sizeof long: " + size);
        }
        long val = 0L;
        for (int i = 0; i < size; ++i) {
            val = val << 8 | (long)(b[offset + i] & 0xFF);
        }
        return val;
    }

    @Override
    public final BigInteger getBigInteger(byte[] b, int size, boolean signed) {
        return this.getBigInteger(b, 0, size, signed);
    }

    @Override
    public final BigInteger getBigInteger(byte[] b, int offset, int size, boolean signed) {
        if (size + offset > b.length) {
            throw new IndexOutOfBoundsException("insufficient bytes");
        }
        if (offset != 0 || size != b.length) {
            int index = 0;
            if (!signed && b[offset] < 0) {
                ++size;
                index = 1;
            }
            byte[] bytes = new byte[size];
            System.arraycopy(b, offset, bytes, index, size - index);
            b = bytes;
        } else if (!signed && b[0] < 0) {
            byte[] bytes = new byte[size + 1];
            System.arraycopy(b, 0, bytes, 1, size);
            b = bytes;
        }
        return new BigInteger(b);
    }

    @Override
    public final void getBytes(short value, byte[] b) {
        this.getBytes(value, b, 0);
    }

    @Override
    public void getBytes(short value, byte[] b, int offset) {
        b[offset] = (byte)(value >> 8);
        b[offset + 1] = (byte)(value & 0xFF);
    }

    @Override
    public final void getBytes(int value, byte[] b) {
        this.getBytes(value, b, 0);
    }

    @Override
    public void getBytes(int value, byte[] b, int offset) {
        b[offset + 3] = (byte)value;
        for (int i = 2; i >= 0; --i) {
            b[offset + i] = (byte)(value >>= 8);
        }
    }

    @Override
    public final void getBytes(long value, byte[] b) {
        this.getBytes(value, 8, b, 0);
    }

    @Override
    public void getBytes(long value, byte[] b, int offset) {
        this.getBytes(value, 8, b, offset);
    }

    @Override
    public void getBytes(long value, int size, byte[] b, int offset) {
        for (int i = size - 1; i >= 0; --i) {
            b[offset + i] = (byte)value;
            value >>= 8;
        }
    }

    @Override
    public final void putInt(byte[] b, int offset, int value) {
        this.getBytes(value, b, offset);
    }

    @Override
    public final void putInt(byte[] b, int value) {
        this.getBytes(value, b);
    }

    @Override
    public final void putLong(byte[] b, int offset, long value) {
        this.getBytes(value, b, offset);
    }

    @Override
    public final void putLong(byte[] b, long value) {
        this.getBytes(value, b);
    }

    @Override
    public final void putShort(byte[] b, int offset, short value) {
        this.getBytes(value, b, offset);
    }

    @Override
    public final void putShort(byte[] b, short value) {
        this.getBytes(value, b);
    }

    @Override
    public byte[] getBytes(int value) {
        byte[] bytes = new byte[4];
        this.getBytes(value, bytes);
        return bytes;
    }

    @Override
    public byte[] getBytes(long value) {
        byte[] bytes = new byte[8];
        this.getBytes(value, bytes);
        return bytes;
    }

    @Override
    public byte[] getBytes(short value) {
        byte[] bytes = new byte[2];
        this.getBytes(value, bytes);
        return bytes;
    }

    @Override
    public byte[] getBytes(BigInteger value, int size) {
        byte[] bytes = new byte[size];
        this.putBigInteger(bytes, 0, size, value);
        return bytes;
    }

    @Override
    public void getBytes(BigInteger value, int size, byte[] b, int offset) {
        this.putBigInteger(b, offset, size, value);
    }

    @Override
    public void putBigInteger(byte[] b, int offset, int size, BigInteger value) {
        int srcIndex;
        int fillIndex = offset;
        byte[] valBytes = value.toByteArray();
        int fillCnt = valBytes.length;
        if (valBytes.length >= size) {
            srcIndex = valBytes.length - size;
            fillCnt = valBytes.length - srcIndex;
        } else {
            srcIndex = 0;
            int signbits = value.signum() < 0 ? -1 : 0;
            for (int i = valBytes.length; i < size; ++i) {
                b[fillIndex++] = signbits;
            }
        }
        System.arraycopy(valBytes, srcIndex, b, fillIndex, fillCnt);
    }

    @Override
    public void putBigInteger(byte[] b, int size, BigInteger value) {
        this.putBigInteger(b, 0, size, value);
    }
}

