/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.matchtable;

import docking.widgets.table.GTableCellRenderingData;
import ghidra.docking.settings.Settings;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationMarkupStatus;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.gui.provider.matchtable.MatchTableRenderer;
import ghidra.feature.vt.gui.provider.matchtable.VTMarkupStatusIcon;
import ghidra.util.HTMLUtilities;
import ghidra.util.table.column.AbstractGColumnRenderer;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;

public class MatchMarkupStatusBatteryRenderer
extends AbstractGColumnRenderer<VTMatch> {
    private VTMarkupStatusIcon markupStatusIcon = new VTMarkupStatusIcon();

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
        Object value = data.getValue();
        JTable table = data.getTable();
        boolean isSelected = data.isSelected();
        this.setText("");
        this.setHorizontalAlignment(0);
        VTMatch match = (VTMatch)value;
        VTAssociation association = match.getAssociation();
        VTAssociationStatus associationStatus = association.getStatus();
        if (!isSelected) {
            renderer.setBackground(MatchTableRenderer.getBackgroundColor(association, table, renderer.getBackground()));
        }
        if (associationStatus == VTAssociationStatus.ACCEPTED) {
            VTAssociationMarkupStatus markupStatus = association.getMarkupStatus();
            this.markupStatusIcon.setStatus(markupStatus);
            this.setIcon(this.markupStatusIcon);
            this.setToolTipText(HTMLUtilities.toHTML((String)markupStatus.getDescription()));
        } else {
            this.setIcon(null);
        }
        return this;
    }

    public String getFilterString(VTMatch t, Settings settings) {
        VTAssociation association = t.getAssociation();
        VTAssociationStatus associationStatus = association.getStatus();
        if (associationStatus == VTAssociationStatus.ACCEPTED) {
            VTAssociationMarkupStatus markupStatus = association.getMarkupStatus();
            return HTMLUtilities.toHTML((String)markupStatus.getDescription());
        }
        return "";
    }
}

