/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler;

import ghidra.app.plugin.assembler.AssemblySemanticException;
import ghidra.app.plugin.assembler.AssemblySyntaxException;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParseResult;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolutionResults;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedConstructor;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedError;
import ghidra.app.plugin.assembler.sleigh.util.SleighUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class AssemblySelector {
    protected Set<AssemblyParseResult> syntaxErrors = new TreeSet<AssemblyParseResult>();
    protected Set<AssemblyResolvedError> semanticErrors = new TreeSet<AssemblyResolvedError>();
    protected Comparator<AssemblyResolvedConstructor> compareBySizeThenBits = (a, b) -> {
        int result = a.getInstructionLength() - b.getInstructionLength();
        if (result != 0) {
            return result;
        }
        result = SleighUtil.compareArrays(a.getInstruction().getVals(), b.getInstruction().getVals());
        if (result != 0) {
            return result;
        }
        return 0;
    };

    public Collection<AssemblyParseResult> filterParse(Collection<AssemblyParseResult> parse) throws AssemblySyntaxException {
        boolean gotOne = false;
        for (AssemblyParseResult pr : parse) {
            if (pr.isError()) {
                this.syntaxErrors.add(pr);
                continue;
            }
            gotOne = true;
        }
        if (!gotOne) {
            throw new AssemblySyntaxException(this.syntaxErrors);
        }
        return parse;
    }

    public AssemblyResolvedConstructor select(AssemblyResolutionResults rr, AssemblyPatternBlock ctx) throws AssemblySemanticException {
        ArrayList<AssemblyResolvedConstructor> sorted = new ArrayList<AssemblyResolvedConstructor>();
        Iterator iterator = rr.iterator();
        while (iterator.hasNext()) {
            AssemblyResolution ar = (AssemblyResolution)iterator.next();
            if (ar.isError()) {
                this.semanticErrors.add((AssemblyResolvedError)ar);
                continue;
            }
            AssemblyResolvedConstructor rc = (AssemblyResolvedConstructor)ar;
            sorted.add(rc);
        }
        if (sorted.isEmpty()) {
            throw new AssemblySemanticException(this.semanticErrors);
        }
        sorted.sort(this.compareBySizeThenBits);
        AssemblyResolvedConstructor res = (AssemblyResolvedConstructor)sorted.get(0);
        return AssemblyResolution.resolved(res.getInstruction().fillMask(), res.getContext(), "Selected", null);
    }
}

