/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.ByteField;
import db.DBHandle;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.Schema;
import ghidra.program.database.data.PointerDBAdapterV0;
import ghidra.program.database.data.PointerDBAdapterV1;
import ghidra.program.database.data.PointerDBAdapterV2;
import ghidra.program.database.map.AddressMap;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class PointerDBAdapter {
    static final String POINTER_TABLE_NAME = "Pointers";
    static final Schema SCHEMA = new Schema(2, "Pointer ID", new Class[]{LongField.class, LongField.class, ByteField.class}, new String[]{"Data Type ID", "Category ID", "Length"});
    static final int PTR_DT_ID_COL = 0;
    static final int PTR_CATEGORY_COL = 1;
    static final int PTR_LENGTH_COL = 2;

    PointerDBAdapter() {
    }

    static PointerDBAdapter getAdapter(DBHandle handle, int openMode, TaskMonitor monitor, AddressMap addrMap) throws VersionException, IOException {
        if (openMode == 0) {
            return new PointerDBAdapterV2(handle, true);
        }
        try {
            return new PointerDBAdapterV2(handle, false);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            PointerDBAdapter adapter = PointerDBAdapter.findReadOnlyAdapter(handle);
            if (openMode == 3) {
                adapter = PointerDBAdapter.upgrade(handle, adapter, monitor);
            }
            return adapter;
        }
    }

    static PointerDBAdapter findReadOnlyAdapter(DBHandle handle) throws VersionException {
        try {
            return new PointerDBAdapterV1(handle);
        }
        catch (VersionException e) {
            return new PointerDBAdapterV0(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PointerDBAdapter upgrade(DBHandle handle, PointerDBAdapter oldAdapter, TaskMonitor monitor) throws VersionException, IOException {
        DBHandle tmpHandle = new DBHandle();
        long id = tmpHandle.startTransaction();
        PointerDBAdapterV2 tmpAdapter = null;
        try {
            tmpAdapter = new PointerDBAdapterV2(tmpHandle, true);
            RecordIterator it = oldAdapter.getRecords();
            while (it.hasNext()) {
                Record rec = it.next();
                ((PointerDBAdapter)tmpAdapter).updateRecord(rec);
            }
            oldAdapter.deleteTable(handle);
            PointerDBAdapterV2 newAdapter = new PointerDBAdapterV2(handle, true);
            it = ((PointerDBAdapter)tmpAdapter).getRecords();
            while (it.hasNext()) {
                Record rec = it.next();
                ((PointerDBAdapter)newAdapter).updateRecord(rec);
            }
            PointerDBAdapterV2 pointerDBAdapterV2 = newAdapter;
            return pointerDBAdapterV2;
        }
        finally {
            tmpHandle.endTransaction(id, true);
            tmpHandle.close();
        }
    }

    abstract void deleteTable(DBHandle var1) throws IOException;

    abstract Record createRecord(long var1, long var3, int var5) throws IOException;

    abstract Record getRecord(long var1) throws IOException;

    abstract RecordIterator getRecords() throws IOException;

    abstract boolean removeRecord(long var1) throws IOException;

    abstract void updateRecord(Record var1) throws IOException;

    abstract long[] getRecordIdsInCategory(long var1) throws IOException;

    Record translateRecord(Record rec) {
        return rec;
    }

    class TranslatedRecordIterator
    implements RecordIterator {
        private RecordIterator it;

        TranslatedRecordIterator(RecordIterator it) {
            this.it = it;
        }

        public boolean delete() throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() throws IOException {
            return this.it.hasNext();
        }

        public boolean hasPrevious() throws IOException {
            return this.it.hasPrevious();
        }

        public Record next() throws IOException {
            Record rec = this.it.next();
            return PointerDBAdapter.this.translateRecord(rec);
        }

        public Record previous() throws IOException {
            Record rec = this.it.previous();
            return PointerDBAdapter.this.translateRecord(rec);
        }
    }
}

