/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.DynamicVariableStorage;
import ghidra.program.model.lang.InputListType;
import ghidra.program.model.lang.ParamList;
import ghidra.program.model.lang.ParamListStandard;
import ghidra.program.model.lang.ParamListStandardOut;
import ghidra.program.model.listing.AutoParameterType;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;

public class PrototypeModel {
    public static final int UNKNOWN_EXTRAPOP = 32768;
    protected String name;
    private int extrapop;
    private int stackshift;
    private ParamList inputParams;
    private ParamList outputParams;
    private InputListType inputListType = InputListType.STANDARD;
    private GenericCallingConvention genericCallingConvention;
    private boolean hasThis;
    private boolean isConstruct;

    public PrototypeModel(String name, PrototypeModel model) {
        this.name = name;
        this.extrapop = model.extrapop;
        this.stackshift = model.stackshift;
        this.inputListType = model.inputListType;
        this.inputParams = model.inputParams;
        this.outputParams = model.outputParams;
        this.hasThis = model.hasThis || name.equals("__thiscall");
        this.isConstruct = model.isConstruct;
        this.genericCallingConvention = GenericCallingConvention.getGenericCallingConvention(name);
    }

    public PrototypeModel() {
        this.name = null;
        this.extrapop = 32768;
        this.stackshift = -1;
        this.inputParams = null;
        this.outputParams = null;
        this.genericCallingConvention = GenericCallingConvention.unknown;
        this.hasThis = false;
        this.isConstruct = false;
    }

    public GenericCallingConvention getGenericCallingConvention() {
        return this.genericCallingConvention;
    }

    public boolean isMerged() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public int getExtrapop() {
        return this.extrapop;
    }

    public int getStackshift() {
        return this.stackshift;
    }

    public boolean hasThisPointer() {
        return this.hasThis;
    }

    public boolean isConstructor() {
        return this.isConstruct;
    }

    public InputListType getInputListType() {
        return this.inputListType;
    }

    @Deprecated
    public VariableStorage getReturnLocation(DataType dataType, Program program) {
        DataType clone = dataType.clone(program.getDataTypeManager());
        DataType[] arr = new DataType[]{clone};
        ArrayList<VariableStorage> res = new ArrayList<VariableStorage>();
        this.outputParams.assignMap(program, arr, false, res, false);
        if (res.size() > 0) {
            return res.get(0);
        }
        return null;
    }

    public VariableStorage getNextArgLocation(Parameter[] params, DataType dataType, Program program) {
        return this.getArgLocation(params != null ? params.length : 0, params, dataType, program);
    }

    public VariableStorage getArgLocation(int argIndex, Parameter[] params, DataType dataType, Program program) {
        if (dataType != null) {
            dataType = dataType.clone(program.getDataTypeManager());
        }
        DataType[] arr = new DataType[argIndex + 2];
        arr[0] = DataType.VOID;
        for (int i = 0; i < argIndex; ++i) {
            arr[i + 1] = params != null && i < params.length ? params[i].getDataType() : DataType.DEFAULT;
        }
        arr[argIndex + 1] = dataType;
        VariableStorage[] res = this.getStorageLocations(program, arr, false);
        return res[res.length - 1];
    }

    public VariableStorage[] getStorageLocations(Program program, DataType[] dataTypes, boolean addAutoParams) {
        boolean injectAutoThisParam = false;
        if (addAutoParams && this.hasThis) {
            injectAutoThisParam = true;
            DataType[] ammendedTypes = new DataType[dataTypes.length + 1];
            ammendedTypes[0] = dataTypes[0];
            ammendedTypes[1] = new PointerDataType(program.getDataTypeManager());
            if (dataTypes.length > 1) {
                System.arraycopy(dataTypes, 1, ammendedTypes, 2, dataTypes.length - 1);
            }
            dataTypes = ammendedTypes;
        }
        ArrayList<VariableStorage> res = new ArrayList<VariableStorage>();
        this.outputParams.assignMap(program, dataTypes, false, res, addAutoParams);
        this.inputParams.assignMap(program, dataTypes, true, res, addAutoParams);
        VariableStorage[] finalres = new VariableStorage[res.size()];
        res.toArray(finalres);
        if (injectAutoThisParam) {
            Varnode[] thisVarnodes = finalres[1].getVarnodes();
            int thisIndex = 1;
            try {
                if (finalres[1].isAutoStorage()) {
                    if (this.inputParams.isThisBeforeRetPointer()) {
                        finalres[2] = new DynamicVariableStorage(program, finalres[1].getAutoParameterType(), finalres[2].getVarnodes());
                    } else {
                        thisIndex = 2;
                        thisVarnodes = finalres[2].getVarnodes();
                    }
                }
                finalres[thisIndex] = thisVarnodes.length != 0 ? new DynamicVariableStorage(program, AutoParameterType.THIS, thisVarnodes) : DynamicVariableStorage.getUnassignedDynamicStorage(AutoParameterType.THIS);
            }
            catch (InvalidInputException e) {
                finalres[thisIndex] = DynamicVariableStorage.getUnassignedDynamicStorage(AutoParameterType.THIS);
            }
        }
        return finalres;
    }

    private void buildParamList(String strategy) throws XmlParseException {
        if (strategy == null || strategy.equals("standard")) {
            this.inputParams = new ParamListStandard();
            this.outputParams = new ParamListStandardOut();
            this.inputListType = InputListType.STANDARD;
        } else if (strategy.equals("register")) {
            this.inputParams = new ParamListStandard();
            this.outputParams = new ParamListStandard();
            this.inputListType = InputListType.REGISTER;
        } else {
            throw new XmlParseException("Unknown assign strategy: " + strategy);
        }
    }

    public void restoreXml(XmlPullParser parser, CompilerSpec cspec, boolean normalstack) throws XmlParseException {
        this.inputParams = null;
        this.outputParams = null;
        XmlElement protoElement = parser.start(new String[0]);
        this.name = protoElement.getAttribute("name");
        this.extrapop = 32768;
        String extpopStr = protoElement.getAttribute("extrapop");
        if (!extpopStr.equals("unknown")) {
            this.extrapop = SpecXmlUtils.decodeInt((String)extpopStr);
        }
        this.stackshift = SpecXmlUtils.decodeInt((String)protoElement.getAttribute("stackshift"));
        String type = protoElement.getAttribute("type");
        this.genericCallingConvention = type != null ? GenericCallingConvention.getGenericCallingConvention(type) : GenericCallingConvention.guessFromName(this.name);
        this.hasThis = false;
        this.isConstruct = false;
        String thisString = protoElement.getAttribute("hasthis");
        this.hasThis = thisString != null ? SpecXmlUtils.decodeBoolean((String)thisString) : this.name.equals("__thiscall");
        String constructString = protoElement.getAttribute("constructor");
        if (constructString != null) {
            this.isConstruct = SpecXmlUtils.decodeBoolean((String)constructString);
        }
        this.buildParamList(protoElement.getAttribute("strategy"));
        while (parser.peek().isStart()) {
            XmlElement subel = parser.peek();
            if (subel.getName().equals("input")) {
                this.inputParams.restoreXml(parser, cspec, normalstack);
                continue;
            }
            if (subel.getName().equals("output")) {
                this.outputParams.restoreXml(parser, cspec, normalstack);
                continue;
            }
            if (subel.getName().equals("pcode")) {
                XmlElement el = parser.peek();
                String source = "Compiler spec=" + cspec.getCompilerSpecID().getIdAsString();
                String nm = el.getAttribute("inject").equals("uponentry") ? this.name + "@@inject_uponentry" : this.name + "@@inject_uponreturn";
                cspec.getPcodeInjectLibrary().restoreXmlInject(source, nm, 3, parser);
                continue;
            }
            subel = parser.start(new String[0]);
            parser.discardSubTree(subel);
        }
        parser.end(protoElement);
    }

    public boolean possibleInputParamWithSlot(Address loc, int size, ParamList.WithSlotRec res) {
        return this.inputParams.possibleParamWithSlot(loc, size, res);
    }

    public boolean possibleOutputParamWithSlot(Address loc, int size, ParamList.WithSlotRec res) {
        return this.outputParams.possibleParamWithSlot(loc, size, res);
    }

    public int getStackParameterAlignment() {
        return this.inputParams.getStackParameterAlignment();
    }

    public Long getStackParameterOffset() {
        return this.inputParams.getStackParameterOffset();
    }

    public VariableStorage[] getPotentialInputRegisterStorage(Program prog) {
        return this.inputParams.getPotentialRegisterStorage(prog);
    }

    public String toString() {
        return this.getName();
    }
}

