/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.analyzers;

import ghidra.app.analyzers.FuncRecord;
import ghidra.app.analyzers.LibHashDB;
import ghidra.app.cmd.label.AddLabelCmd;
import ghidra.app.cmd.label.DemanglerCmd;
import ghidra.app.cmd.label.RenameLabelCmd;
import ghidra.app.cmd.label.SetLabelPrimaryCmd;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.Application;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import ghidra.xml.NonThreadedXmlPullParserImpl;
import ghidra.xml.XmlPullParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LibraryHashAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Library Hash Identification";
    private static final String DESCRIPTION = "Analyzes program for statically linked library functions (e.g., printf, scanf, etc.).";
    private static final String OPTION_NAME_MEM_SEARCH = "Analyze undefined bytes";
    private static final String OPTION_NAME_DISASSEMBLE = "Disassemble matches in undefined bytes";
    private static final String OPTION_DESCRIPTION_MEM_SEARCH = "Search for known library signatures in undefined bytes.";
    private static final String OPTION_DESCRIPTION_DISASSEMBLE = "Disassemble any library functions found while searching undefined bytes.";
    private static final boolean OPTION_DEFAULT_MEM_SEARCH = true;
    private static final boolean OPTION_DEFAULT_DISASSEMBLE = true;
    private boolean memSearchOption = true;
    private boolean disassembleOption = true;

    public LibraryHashAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPrototype();
        this.setPriority(AnalysisPriority.DATA_TYPE_PROPOGATION.before());
        this.setSupportsOneTimeAnalysis();
    }

    public boolean canAnalyze(Program program) {
        return false;
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        this.identifyLibraryFunctions(set, program, monitor);
        return true;
    }

    public void registerOptions(Options options, Program program) {
        options.registerOption(OPTION_NAME_MEM_SEARCH, (Object)this.memSearchOption, null, OPTION_DESCRIPTION_MEM_SEARCH);
        options.registerOption(OPTION_NAME_DISASSEMBLE, (Object)this.disassembleOption, null, OPTION_DESCRIPTION_DISASSEMBLE);
    }

    public void optionsChanged(Options options, Program program) {
        this.memSearchOption = options.getBoolean(OPTION_NAME_MEM_SEARCH, this.memSearchOption);
        this.disassembleOption = options.getBoolean(OPTION_NAME_DISASSEMBLE, this.disassembleOption);
    }

    private void identifyLibraryFunctions(AddressSetView set, Program p, TaskMonitor monitor) {
        File libraryFile;
        try {
            libraryFile = Application.getModuleDataFile((String)"lib/db.xml").getFile(true);
        }
        catch (FileNotFoundException e1) {
            Msg.error((Object)((Object)this), (Object)"Cannot find db.xml file--not hashing functions", (Throwable)e1);
            return;
        }
        LibHashDB db = new LibHashDB();
        ErrorHandler handler = new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }
        };
        try {
            FileInputStream hstream = new FileInputStream(libraryFile);
            NonThreadedXmlPullParserImpl parser = new NonThreadedXmlPullParserImpl((InputStream)hstream, "Function Database parser", handler, false);
            ((InputStream)hstream).close();
            db.restoreXml((XmlPullParser)parser);
            HashMap<FuncRecord, FuncRecord> pinning = new HashMap<FuncRecord, FuncRecord>();
            LibHashDB qdb = new LibHashDB(p);
            FunctionIterator funcIter = p.getListing().getFunctions(true);
            while (funcIter.hasNext()) {
                Function func = (Function)funcIter.next();
                ArrayList<FuncRecord> libResponse = db.query(func);
                if (libResponse.size() != 1) continue;
                FuncRecord libVal = libResponse.get(0);
                ArrayList<FuncRecord> queResponse = qdb.query(libVal.hashValue);
                if (queResponse.size() != 1) continue;
                FuncRecord queVal = queResponse.get(0);
                pinning.put(queVal, libVal);
            }
            PriorityQueue q = new PriorityQueue(pinning.keySet());
            HashSet<FuncRecord> seen = new HashSet<FuncRecord>();
            block5: while (q.size() > 0) {
                FuncRecord current = (FuncRecord)q.remove();
                seen.add(current);
                Iterator<FuncRecord> qit = current.children.iterator();
                FuncRecord partner = (FuncRecord)pinning.get(current);
                Iterator<FuncRecord> lit = partner.children.iterator();
                while (qit.hasNext()) {
                    FuncRecord qKid = qit.next();
                    if (!lit.hasNext()) continue block5;
                    FuncRecord lKid = lit.next();
                    if (qKid.hashValue != lKid.hashValue || seen.contains(qKid) || qKid.children.size() != lKid.children.size()) continue;
                    pinning.put(qKid, lKid);
                    this.addSymbol(p, qKid.func.getEntryPoint(), lKid.funcName, false);
                    q.add(qKid);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void analysisEnded(Program program) {
    }

    private void addSymbol(Program program, Address addr, String name, boolean localscope) {
        SymbolTable st = program.getSymbolTable();
        Symbol existSym = st.getPrimarySymbol(addr);
        Object cmd = null;
        if (existSym == null) {
            cmd = new AddLabelCmd(addr, name, localscope, SourceType.IMPORTED);
        } else if (!existSym.getName().equals(name)) {
            cmd = existSym.getSource() == SourceType.DEFAULT || existSym.getSource() == SourceType.ANALYSIS && existSym.getSymbolType().equals((Object)SymbolType.FUNCTION) ? new RenameLabelCmd(addr, existSym.getName(), name, existSym.getParentNamespace(), SourceType.IMPORTED) : new AddLabelCmd(addr, name, localscope, SourceType.IMPORTED);
        }
        if (cmd != null && cmd.applyTo((DomainObject)program)) {
            Msg.debug((Object)((Object)this), (Object)("Created symbol for library function " + name + " at address " + addr));
            Namespace space = st.getNamespace(addr);
            if (!localscope) {
                space = null;
            }
            cmd = new SetLabelPrimaryCmd(addr, name, space);
            cmd.applyTo((DomainObject)program);
            cmd = new DemanglerCmd(addr, name);
            if (cmd.applyTo((DomainObject)program)) {
                Msg.debug((Object)((Object)this), (Object)("Demangled library function " + name));
            }
        }
    }
}

