/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import docking.widgets.dialogs.NumberInputDialog;
import docking.widgets.label.GDLabel;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeRootNode;
import ghidra.bitpatterns.gui.ContextRegisterFilterablePanelBuilder;
import ghidra.bitpatterns.info.ContextRegisterFilter;
import ghidra.bitpatterns.info.FileBitPatternInfoReader;
import ghidra.bitpatterns.info.FunctionBitPatternsGTree;
import ghidra.bitpatterns.info.FunctionBitPatternsGTreeRootNode;
import ghidra.bitpatterns.info.InstructionSequence;
import ghidra.bitpatterns.info.PatternType;
import ghidra.bitpatterns.info.PercentageFilter;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.TreePath;

public class InstructionSequenceTreePanelBuilder
extends ContextRegisterFilterablePanelBuilder {
    private JPanel treePanel;
    private FunctionBitPatternsGTree gTree;
    private JTextField countField;
    private JPanel countPanel;
    private JButton applyPercentageFilterButton;
    private JButton clearPercentageFilterButton;
    private static final String APPLY_PERCENTAGE_FILTER_BUTTON_TEXT = "Apply Percentage Filter";
    private static final String CLEAR_PERCENTAGE_FILTER_BUTTON_TEXT = "Clear Percentage Filter";
    private static final String COUNT_FIELD_LABEL = " Number of Sequences in Tree ";
    private static final String PERCENTAGE_FILTER_TITLE = "Enter minimum percentage";
    private static final int DEFAULT_PERCENTAGE_FILTER = 5;
    private FileBitPatternInfoReader fsReader;
    private PatternType type;
    private PercentageFilter percentageFilter = new PercentageFilter(0.0);

    public InstructionSequenceTreePanelBuilder(PatternType type) {
        this.type = type;
    }

    private JPanel buildTreePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        FunctionBitPatternsGTreeRootNode root = new FunctionBitPatternsGTreeRootNode();
        GTree defaultEmptyTree = new GTree((GTreeRootNode)root);
        panel.add((Component)defaultEmptyTree, "Center");
        return panel;
    }

    public JPanel buildMainPanel() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.treePanel = this.buildTreePanel();
        this.buildCountPanel();
        this.mainPanel.add((Component)this.countPanel, "North");
        this.mainPanel.add((Component)this.treePanel, "Center");
        this.addPercentageFilterButtons();
        this.mainPanel.add((Component)this.getButtonPanel(), "South");
        return this.mainPanel;
    }

    private void addPercentageFilterButtons() {
        this.applyPercentageFilterButton = new JButton(APPLY_PERCENTAGE_FILTER_BUTTON_TEXT);
        this.applyPercentageFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberInputDialog percentageFilterCreater = new NumberInputDialog(InstructionSequenceTreePanelBuilder.PERCENTAGE_FILTER_TITLE, null, Integer.valueOf(5));
                percentageFilterCreater.show();
                double value = 0.0;
                if (!percentageFilterCreater.wasCancelled()) {
                    value = percentageFilterCreater.getValue();
                }
                InstructionSequenceTreePanelBuilder.this.percentageFilter = new PercentageFilter(value);
                InstructionSequenceTreePanelBuilder.this.applyFilterAction();
                InstructionSequenceTreePanelBuilder.this.gTree.expandAll();
            }
        });
        this.getButtonPanel().add(this.applyPercentageFilterButton);
        this.clearPercentageFilterButton = new JButton(CLEAR_PERCENTAGE_FILTER_BUTTON_TEXT);
        this.clearPercentageFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstructionSequenceTreePanelBuilder.this.percentageFilter = new PercentageFilter(0.0);
                InstructionSequenceTreePanelBuilder.this.applyFilterAction();
            }
        });
        this.getButtonPanel().add(this.clearPercentageFilterButton);
    }

    private void buildCountPanel() {
        this.countPanel = new JPanel();
        PairLayout countLayout = new PairLayout();
        this.countPanel.setLayout((LayoutManager)countLayout);
        GDLabel countLabel = new GDLabel(COUNT_FIELD_LABEL);
        this.countPanel.add((Component)countLabel);
        this.countField = new JTextField(25);
        this.countField.setEditable(false);
        this.countPanel.add(this.countField);
    }

    private void updateCountField(int numSeqs) {
        this.countField.setText(Integer.toString(numSeqs));
    }

    private void updateTreePanel() {
        this.treePanel.removeAll();
        ContextRegisterFilter regFilter = this.getContextRegisterFilter();
        List<InstructionSequence> instSeqs = InstructionSequence.getInstSeqs(this.fsReader, this.type, regFilter);
        this.gTree = FunctionBitPatternsGTree.createTree(instSeqs, this.type, this.percentageFilter);
        this.gTree.setRootVisible(false);
        this.gTree.getSelectionModel().setSelectionMode(1);
        this.treePanel.add((Component)((Object)this.gTree));
        this.treePanel.updateUI();
        this.updateCountField(instSeqs.size());
    }

    public void setFsReaderAndUpdateExtent(FileBitPatternInfoReader fsReader) {
        this.fsReader = fsReader;
        this.updateExtentAndClearFilter(fsReader.getContextRegisterExtent());
        this.updateTreePanel();
        this.percentageFilter = new PercentageFilter(0.0);
    }

    public boolean isTreeEmpty() {
        if (this.gTree == null) {
            return true;
        }
        return this.gTree.getTotalNum() == 0;
    }

    @Override
    public void applyFilterAction() {
        this.updateTreePanel();
    }

    @Override
    public void clearFilterAction() {
        this.updateExtentAndClearFilter(this.fsReader.getContextRegisterExtent());
        this.updateTreePanel();
    }

    public void enablePercentageFilterButtons(boolean enable) {
        if (this.applyPercentageFilterButton != null) {
            this.applyPercentageFilterButton.setEnabled(enable);
        }
        if (this.clearPercentageFilterButton != null) {
            this.clearPercentageFilterButton.setEnabled(enable);
        }
    }

    public TreePath getSelectionPath() {
        if (this.gTree == null) {
            return null;
        }
        TreePath[] paths = this.gTree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        return paths[0];
    }

    public FunctionBitPatternsGTree getGTree() {
        return this.gTree;
    }
}

