/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constrainteditor;

import docking.widgets.label.GDHtmlLabel;
import docking.widgets.spinner.IntegerSpinner;
import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.SingleValueColumnConstraint;
import docking.widgets.table.constrainteditor.AbstractColumnConstraintEditor;
import docking.widgets.table.constrainteditor.BoundedSpinnerNumberModel;
import docking.widgets.table.constrainteditor.LongConverter;
import docking.widgets.textfield.IntegerTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;

public class IntegerConstraintEditor<T extends Number>
extends AbstractColumnConstraintEditor<T> {
    private IntegerSpinner spinner;
    private BoundedSpinnerNumberModel spinnerModel;
    private LongConverter<T> converter;
    private JLabel statusLabel;

    public IntegerConstraintEditor(ColumnConstraint<T> constraint, LongConverter<T> converter) {
        super(constraint);
        this.converter = converter;
    }

    @Override
    protected Component buildInlineEditorComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        Number constraintValue = (Number)this.getConstraint().getConstraintValue();
        long value = constraintValue.longValue();
        long minValue = this.getMinValue();
        long maxValue = this.getMaxValue();
        Long stepSize = 1L;
        this.spinnerModel = new BoundedSpinnerNumberModel((Number)value, (Comparable<? extends Number>)minValue, (Comparable<? extends Number>)maxValue, (Number)stepSize);
        this.spinner = new IntegerSpinner(this.spinnerModel);
        this.spinner.getTextField().setShowNumberMode(true);
        IntegerTextField textField = this.spinner.getTextField();
        textField.addChangeListener(e -> this.valueChanged());
        this.spinnerModel.addChangeListener(e -> this.valueChanged());
        panel.add((Component)this.spinner.getSpinner(), "Center");
        this.statusLabel = new GDHtmlLabel();
        panel.add((Component)this.statusLabel, "South");
        this.statusLabel.setForeground(Color.RED);
        this.statusLabel.setHorizontalAlignment(0);
        return panel;
    }

    @Override
    public void reset() {
        Number newValue = (Number)this.converter.fromLong(0L);
        this.setValue(this.getConstraint().copy(newValue));
    }

    @Override
    protected ColumnConstraint<T> getValueFromComponent() {
        long value = this.spinner.getTextField().getLongValue();
        return this.getConstraint().copy((Number)this.converter.fromLong(value));
    }

    @Override
    protected void updateEditorComponent() {
        if (this.hasEditorComponents()) {
            Number constraintValue = (Number)this.getConstraint().getConstraintValue();
            this.spinner.setValue(constraintValue.longValue());
        }
    }

    @Override
    protected boolean checkEditorValueValidity() {
        return !StringUtils.isBlank((CharSequence)this.spinner.getTextField().getText());
    }

    @Override
    protected void updateInfoMessage(boolean isValid) {
        String status = IntegerConstraintEditor.formatStatus(isValid ? "&nbsp;" : "Please enter a value!", true);
        this.statusLabel.setText(status);
    }

    @Override
    public String getErrorMessage() {
        return "";
    }

    private SingleValueColumnConstraint<T> getConstraint() {
        return (SingleValueColumnConstraint)this.currentConstraint;
    }

    private long getMinValue() {
        Number value = (Number)this.getConstraint().getConstraintValue();
        Class<?> class1 = value.getClass();
        if (class1 == Byte.class) {
            return -128L;
        }
        if (class1 == Short.class) {
            return -32768L;
        }
        if (class1 == Integer.class) {
            return Integer.MIN_VALUE;
        }
        if (class1 == Long.class) {
            return Long.MIN_VALUE;
        }
        throw new IllegalArgumentException("IntegerValueConstraintEditor does not suppport values of type " + class1);
    }

    private long getMaxValue() {
        Number value = (Number)this.getConstraint().getConstraintValue();
        Class<?> class1 = value.getClass();
        if (class1 == Byte.class) {
            return 127L;
        }
        if (class1 == Short.class) {
            return 32767L;
        }
        if (class1 == Integer.class) {
            return Integer.MAX_VALUE;
        }
        if (class1 == Long.class) {
            return Long.MAX_VALUE;
        }
        throw new IllegalArgumentException("IntegerValueConstraintEditor does not suppport values of type " + class1);
    }
}

