/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.TunnelManagerFacade;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.peermanager.ProfileOrganizer;
import net.i2p.router.tunnel.pool.TunnelPeerSelector;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.router.util.MaskedIPSet;

class ClientPeerSelector
extends TunnelPeerSelector {
    public ClientPeerSelector(RouterContext context) {
        super(context);
    }

    @Override
    public List<Hash> selectPeers(TunnelPoolSettings settings) {
        ArrayList<Hash> rv;
        int length = this.getLength(settings);
        if (length < 0) {
            return null;
        }
        if (length == 0 && settings.getLength() + settings.getLengthVariance() > 0) {
            return null;
        }
        boolean isInbound = settings.isInbound();
        if (length > 0) {
            MaskedIPSet ipSet;
            boolean v6Only = this.isIPv6Only();
            boolean ntcpDisabled = this.isNTCPDisabled();
            boolean ssuDisabled = this.isSSUDisabled();
            boolean checkClosestHop = v6Only || ntcpDisabled || ssuDisabled;
            boolean hidden = this.ctx.router().isHidden() || this.ctx.router().getRouterInfo().getAddressCount() <= 0 || !this.ctx.commSystem().haveInboundCapacity(95);
            boolean hiddenInbound = hidden && isInbound;
            boolean hiddenOutbound = hidden && !isInbound;
            int ipRestriction = this.ctx.getBooleanProperty("i2np.allowLocal") || length <= 1 ? 0 : settings.getIPRestriction();
            MaskedIPSet maskedIPSet = ipSet = ipRestriction > 0 ? new MaskedIPSet(16) : null;
            if (this.shouldSelectExplicit(settings)) {
                return this.selectExplicit(settings, length);
            }
            Set<Hash> exclude = this.getExclude(isInbound, false);
            HashSet<Hash> matches = new HashSet<Hash>(length);
            if (length == 1) {
                Set<Hash> moreExclude;
                if (checkClosestHop && (moreExclude = this.getClosestHopExclude(isInbound)) != null) {
                    exclude.addAll(moreExclude);
                }
                if (hiddenInbound) {
                    HashSet<Hash> SANFPExclude = new HashSet<Hash>(exclude);
                    this.ctx.profileOrganizer().selectActiveNotFailingPeers(1, SANFPExclude, matches);
                }
                if (matches.isEmpty()) {
                    this.ctx.profileOrganizer().selectFastPeers(length, exclude, matches);
                }
                matches.remove(this.ctx.routerHash());
                rv = new ArrayList<Hash>(matches);
            } else {
                Set<Hash> lastHopExclude;
                Set<Hash> moreExclude;
                rv = new ArrayList(length + 1);
                SessionKey randomKey = settings.getRandomKey();
                if (isInbound) {
                    if (checkClosestHop) {
                        moreExclude = this.getClosestHopExclude(false);
                        if (moreExclude != null) {
                            moreExclude.addAll(exclude);
                            lastHopExclude = moreExclude;
                        } else {
                            lastHopExclude = exclude;
                        }
                    } else {
                        lastHopExclude = exclude;
                    }
                } else {
                    lastHopExclude = exclude;
                }
                if (hiddenInbound) {
                    if (this.log.shouldInfo()) {
                        this.log.info("CPS SANFP closest IB exclude " + lastHopExclude.size());
                    }
                    HashSet<Hash> SANFPExclude = new HashSet<Hash>(lastHopExclude);
                    this.ctx.profileOrganizer().selectActiveNotFailingPeers(1, SANFPExclude, matches, ipRestriction, ipSet);
                    if (matches.isEmpty()) {
                        if (this.log.shouldInfo()) {
                            this.log.info("CPS SFP closest IB exclude " + lastHopExclude.size());
                        }
                        this.ctx.profileOrganizer().selectFastPeers(1, lastHopExclude, matches, randomKey, length == 2 ? ProfileOrganizer.Slice.SLICE_0_1 : ProfileOrganizer.Slice.SLICE_0, ipRestriction, ipSet);
                    }
                } else if (hiddenOutbound) {
                    boolean pickFurthest;
                    TunnelManagerFacade tmf = this.ctx.tunnelManager();
                    TunnelPool tp = tmf.getInboundPool(settings.getDestination());
                    if (tp != null) {
                        pickFurthest = true;
                        TunnelPoolSettings tps = tp.getSettings();
                        int len = tps.getLength();
                        if (len > 0 && tps.getLengthOverride() != 0 && len + tps.getLengthVariance() > 0) {
                            List<TunnelInfo> tunnels = tp.listTunnels();
                            if (!tunnels.isEmpty()) {
                                for (TunnelInfo ti : tp.listTunnels()) {
                                    if (ti.getLength() <= 1) continue;
                                    pickFurthest = false;
                                    break;
                                }
                            } else {
                                tp = tmf.getInboundExploratoryPool();
                                tps = tp.getSettings();
                                len = tps.getLength();
                                if (len > 0 && tps.getLengthOverride() != 0 && len + tps.getLengthVariance() > 0 && !(tunnels = tp.listTunnels()).isEmpty()) {
                                    for (TunnelInfo ti : tp.listTunnels()) {
                                        if (ti.getLength() <= 1) continue;
                                        pickFurthest = false;
                                        break;
                                    }
                                }
                            }
                        }
                    } else {
                        pickFurthest = false;
                    }
                    if (pickFurthest) {
                        if (this.log.shouldInfo()) {
                            this.log.info("CPS SANFP OBEP exclude " + lastHopExclude.size());
                        }
                        HashSet<Hash> SANFPExclude = new HashSet<Hash>(lastHopExclude);
                        this.ctx.profileOrganizer().selectActiveNotFailingPeers(1, SANFPExclude, matches, ipRestriction, ipSet);
                        if (matches.isEmpty()) {
                            if (this.log.shouldInfo()) {
                                this.log.info("CPS SFP OBEP exclude " + lastHopExclude.size());
                            }
                            this.ctx.profileOrganizer().selectFastPeers(1, lastHopExclude, matches, randomKey, length == 2 ? ProfileOrganizer.Slice.SLICE_0_1 : ProfileOrganizer.Slice.SLICE_0, ipRestriction, ipSet);
                        }
                    } else {
                        this.ctx.profileOrganizer().selectFastPeers(1, lastHopExclude, matches, randomKey, length == 2 ? ProfileOrganizer.Slice.SLICE_0_1 : ProfileOrganizer.Slice.SLICE_0, ipRestriction, ipSet);
                    }
                } else {
                    this.ctx.profileOrganizer().selectFastPeers(1, lastHopExclude, matches, randomKey, length == 2 ? ProfileOrganizer.Slice.SLICE_0_1 : ProfileOrganizer.Slice.SLICE_0, ipRestriction, ipSet);
                }
                matches.remove(this.ctx.routerHash());
                exclude.addAll(matches);
                rv.addAll(matches);
                matches.clear();
                if (length > 2) {
                    this.ctx.profileOrganizer().selectFastPeers(length - 2, exclude, matches, randomKey, ProfileOrganizer.Slice.SLICE_2_3, ipRestriction, ipSet);
                    matches.remove(this.ctx.routerHash());
                    if (matches.size() > 1) {
                        ArrayList<Hash> ordered = new ArrayList<Hash>(matches);
                        this.orderPeers(ordered, randomKey);
                        rv.addAll(ordered);
                    } else {
                        rv.addAll(matches);
                    }
                    exclude.addAll(matches);
                    matches.clear();
                }
                if (!isInbound && checkClosestHop && (moreExclude = this.getClosestHopExclude(true)) != null) {
                    exclude.addAll(moreExclude);
                }
                this.ctx.profileOrganizer().selectFastPeers(1, exclude, matches, randomKey, length == 2 ? ProfileOrganizer.Slice.SLICE_2_3 : ProfileOrganizer.Slice.SLICE_1, ipRestriction, ipSet);
                matches.remove(this.ctx.routerHash());
                rv.addAll(matches);
            }
        } else {
            rv = new ArrayList<Hash>(1);
        }
        if (isInbound) {
            rv.add(0, this.ctx.routerHash());
        } else {
            rv.add(this.ctx.routerHash());
        }
        if (rv.size() > 1 && !this.checkTunnel(isInbound, rv)) {
            rv = null;
        }
        return rv;
    }
}

