/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.elgamal.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import net.i2p.crypto.SigUtil;
import net.i2p.crypto.elgamal.ElGamalPrivateKey;
import net.i2p.crypto.elgamal.impl.ElGamalPublicKeyImpl;
import net.i2p.crypto.elgamal.spec.ElGamalParameterSpec;
import net.i2p.crypto.elgamal.spec.ElGamalPrivateKeySpec;

public class ElGamalPrivateKeyImpl
implements ElGamalPrivateKey,
DHPrivateKey {
    private static final long serialVersionUID = 4819350091141529678L;
    private BigInteger x;
    private ElGamalParameterSpec elSpec;

    protected ElGamalPrivateKeyImpl() {
    }

    public ElGamalPrivateKeyImpl(ElGamalPrivateKey key) {
        this.x = key.getX();
        this.elSpec = key.getParameters();
    }

    public ElGamalPrivateKeyImpl(DHPrivateKey key) {
        this.x = key.getX();
        this.elSpec = new ElGamalParameterSpec(key.getParams().getP(), key.getParams().getG());
    }

    public ElGamalPrivateKeyImpl(ElGamalPrivateKeySpec spec) {
        this.x = spec.getX();
        this.elSpec = new ElGamalParameterSpec(spec.getParams().getP(), spec.getParams().getG());
    }

    public ElGamalPrivateKeyImpl(DHPrivateKeySpec spec) {
        this.x = spec.getX();
        this.elSpec = new ElGamalParameterSpec(spec.getP(), spec.getG());
    }

    public ElGamalPrivateKeyImpl(BigInteger x, ElGamalParameterSpec elSpec) {
        this.x = x;
        this.elSpec = elSpec;
    }

    public ElGamalPrivateKeyImpl(PKCS8EncodedKeySpec spec) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public String getAlgorithm() {
        return "ElGamal";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        byte[] pb = this.elSpec.getP().toByteArray();
        byte[] gb = this.elSpec.getG().toByteArray();
        byte[] xb = this.x.toByteArray();
        int seq3len = ElGamalPublicKeyImpl.spaceFor(pb.length) + ElGamalPublicKeyImpl.spaceFor(gb.length);
        int seq2len = 8 + ElGamalPublicKeyImpl.spaceFor(seq3len);
        int seq1len = 3 + ElGamalPublicKeyImpl.spaceFor(seq2len) + ElGamalPublicKeyImpl.spaceFor(xb.length);
        int totlen = ElGamalPublicKeyImpl.spaceFor(seq1len);
        byte[] rv = new byte[totlen];
        int idx = 0;
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, seq1len);
        rv[idx++] = 2;
        rv[idx++] = 1;
        rv[idx++] = 0;
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, seq2len);
        rv[idx++] = 6;
        rv[idx++] = 6;
        rv[idx++] = 43;
        rv[idx++] = 14;
        rv[idx++] = 7;
        rv[idx++] = 2;
        rv[idx++] = 1;
        rv[idx++] = 1;
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, seq3len);
        rv[idx++] = 2;
        idx = SigUtil.intToASN1(rv, idx, pb.length);
        System.arraycopy(pb, 0, rv, idx, pb.length);
        idx += pb.length;
        rv[idx++] = 2;
        idx = SigUtil.intToASN1(rv, idx, gb.length);
        System.arraycopy(gb, 0, rv, idx, gb.length);
        idx += gb.length;
        rv[idx++] = 4;
        idx = SigUtil.intToASN1(rv, idx, xb.length);
        System.arraycopy(xb, 0, rv, idx, xb.length);
        return rv;
    }

    @Override
    public ElGamalParameterSpec getParameters() {
        return this.elSpec;
    }

    @Override
    public DHParameterSpec getParams() {
        return new DHParameterSpec(this.elSpec.getP(), this.elSpec.getG());
    }

    @Override
    public BigInteger getX() {
        return this.x;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.x = (BigInteger)in.readObject();
        this.elSpec = new ElGamalParameterSpec((BigInteger)in.readObject(), (BigInteger)in.readObject());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.getX());
        out.writeObject(this.elSpec.getP());
        out.writeObject(this.elSpec.getG());
    }
}

