/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.sam.ReadLine;
import net.i2p.sam.SAMBridge;
import net.i2p.sam.SAMException;
import net.i2p.sam.SAMHandler;
import net.i2p.sam.SAMUtils;
import net.i2p.sam.SAMv1Handler;
import net.i2p.sam.SAMv2Handler;
import net.i2p.sam.SAMv3Handler;
import net.i2p.util.Log;
import net.i2p.util.PasswordManager;
import net.i2p.util.VersionComparator;

class SAMHandlerFactory {
    private static final String VERSION = "3.3";
    private static final int HELLO_TIMEOUT = 60000;

    SAMHandlerFactory() {
    }

    public static SAMHandler createSAMHandler(SocketChannel s, Properties i2cpProps, SAMBridge parent) throws SAMException {
        SAMv1Handler handler;
        String ver;
        String maxVer;
        Properties props;
        String line;
        Log log = I2PAppContext.getGlobalContext().logManager().getLog(SAMHandlerFactory.class);
        try {
            Socket sock = s.socket();
            sock.setKeepAlive(true);
            StringBuilder buf = new StringBuilder(128);
            ReadLine.readLine(sock, buf, 60000);
            sock.setSoTimeout(0);
            line = buf.toString();
        }
        catch (SocketTimeoutException e) {
            throw new SAMException("Timeout waiting for HELLO VERSION", e);
        }
        catch (IOException e) {
            throw new SAMException("Error reading from socket", e);
        }
        catch (RuntimeException e) {
            throw new SAMException("Unexpected error", e);
        }
        if (log.shouldDebug()) {
            log.debug("New message received: [" + line + ']');
        }
        if (!"HELLO".equals((props = SAMUtils.parseParams(line)).remove("\"\"COMMAND\"\"")) || !"VERSION".equals(props.remove("\"\"OPCODE\"\""))) {
            throw new SAMException("Must start with HELLO VERSION");
        }
        String minVer = props.getProperty("MIN");
        if (minVer == null) {
            minVer = "1";
        }
        if ((maxVer = props.getProperty("MAX")) == null) {
            maxVer = "99.99";
        }
        if ((ver = SAMHandlerFactory.chooseBestVersion(minVer, maxVer)) == null) {
            SAMHandler.writeString("HELLO REPLY RESULT=NOVERSION\n", s);
            return null;
        }
        if (Boolean.parseBoolean(i2cpProps.getProperty("sam.auth"))) {
            String user = props.getProperty("USER");
            String pw = props.getProperty("PASSWORD");
            if (user == null || pw == null) {
                if (user == null) {
                    log.logAlways(30, "SAM authentication failed");
                } else {
                    log.logAlways(30, "SAM authentication failed, user: " + user);
                }
                throw new SAMException("USER and PASSWORD required");
            }
            String savedPW = i2cpProps.getProperty("sam.auth." + user + ".shash");
            if (savedPW == null) {
                log.logAlways(30, "SAM authentication failed, user: " + user);
                throw new SAMException("Authorization failed");
            }
            PasswordManager pm = new PasswordManager(I2PAppContext.getGlobalContext());
            if (!pm.checkHash(savedPW, pw)) {
                log.logAlways(30, "SAM authentication failed, user: " + user);
                throw new SAMException("Authorization failed");
            }
        }
        if (!SAMHandler.writeString("HELLO REPLY RESULT=OK VERSION=" + ver + "\n", s)) {
            throw new SAMException("Error writing to socket");
        }
        int verMajor = SAMHandlerFactory.getMajor(ver);
        int verMinor = SAMHandlerFactory.getMinor(ver);
        try {
            switch (verMajor) {
                case 1: {
                    handler = new SAMv1Handler(s, verMajor, verMinor, i2cpProps, parent);
                    break;
                }
                case 2: {
                    handler = new SAMv2Handler(s, verMajor, verMinor, i2cpProps, parent);
                    break;
                }
                case 3: {
                    handler = new SAMv3Handler(s, verMajor, verMinor, i2cpProps, parent);
                    break;
                }
                default: {
                    log.error("BUG! Trying to initialize the wrong SAM version!");
                    throw new SAMException("BUG! (in handler instantiation)");
                }
            }
        }
        catch (IOException e) {
            log.error("Error creating the handler for version " + verMajor, e);
            throw new SAMException("IOException caught during SAM handler instantiation");
        }
        return handler;
    }

    private static String chooseBestVersion(String minVer, String maxVer) {
        if (VersionComparator.comp(VERSION, minVer) >= 0 && VersionComparator.comp(VERSION, maxVer) <= 0) {
            return VERSION;
        }
        if (VersionComparator.comp("3.2", minVer) >= 0 && VersionComparator.comp("3.2", maxVer) <= 0) {
            return "3.2";
        }
        if (VersionComparator.comp("3.1", minVer) >= 0 && VersionComparator.comp("3.1", maxVer) <= 0) {
            return "3.1";
        }
        if (VersionComparator.comp("3.0", minVer) >= 0 && VersionComparator.comp("3", maxVer) <= 0) {
            return "3.0";
        }
        if (VersionComparator.comp("2.0", minVer) >= 0 && VersionComparator.comp("2", maxVer) <= 0) {
            return "2.0";
        }
        if (VersionComparator.comp("1.0", minVer) >= 0 && VersionComparator.comp("1", maxVer) <= 0) {
            return "1.0";
        }
        return null;
    }

    private static int getMajor(String ver) {
        if (ver == null) {
            return -1;
        }
        int dot = ver.indexOf(46);
        if (dot == 0) {
            return -1;
        }
        if (dot > 0) {
            ver = ver.substring(0, dot);
        }
        try {
            return Integer.parseInt(ver);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static int getMinor(String ver) {
        if (ver == null || ver.indexOf(46) < 0) {
            return -1;
        }
        try {
            String major = ver.substring(ver.indexOf(46) + 1);
            return Integer.parseInt(major);
        }
        catch (NumberFormatException e) {
            return -1;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1;
        }
    }
}

