/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MultiSelectionListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.actions.EditTaskDialog;
import com.intellij.tasks.actions.GotoTaskAction;
import com.intellij.tasks.actions.TaskListItem;
import com.intellij.tasks.config.TaskSettings;
import com.intellij.tasks.impl.LocalTaskImpl;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.tools.SimpleActionGroup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchTaskAction
extends ComboBoxAction
implements DumbAware {
    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        if (presentation == null) {
            SwitchTaskAction.$$$reportNull$$$0(0);
        }
        if (place == null) {
            SwitchTaskAction.$$$reportNull$$$0(1);
        }
        return new ComboBoxAction.ComboBoxButton(presentation){

            @NotNull
            protected JBPopup createPopup(Runnable onDispose) {
                ListPopupImpl listPopupImpl = SwitchTaskAction.createPopup(DataManager.getInstance().getDataContext((Component)((Object)this)), onDispose, false);
                if (listPopupImpl == null) {
                    1.$$$reportNull$$$0(0);
                }
                return listPopupImpl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/actions/SwitchTaskAction$1", "createPopup"));
            }
        };
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        return new DefaultActionGroup();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SwitchTaskAction.$$$reportNull$$$0(2);
        }
        Presentation presentation = e.getPresentation();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDefault() || project.isDisposed()) {
            presentation.setEnabledAndVisible(false);
            presentation.setText("");
            presentation.setIcon(null);
        } else if (e.isFromActionToolbar()) {
            TaskManager taskManager = TaskManager.getManager((Project)project);
            LocalTask activeTask = taskManager.getActiveTask();
            if (SwitchTaskAction.isImplicit(activeTask) && taskManager.getAllRepositories().length == 0 && !TaskSettings.getInstance().ALWAYS_DISPLAY_COMBO) {
                presentation.setEnabledAndVisible(false);
            } else {
                String s = SwitchTaskAction.getText(activeTask);
                presentation.setEnabledAndVisible(true);
                presentation.setText(s, false);
                presentation.setIcon(activeTask.getIcon());
                presentation.setDescription(activeTask.getSummary());
            }
        } else {
            presentation.setEnabledAndVisible(true);
            presentation.copyFrom(this.getTemplatePresentation());
        }
    }

    private static boolean isImplicit(LocalTask activeTask) {
        return activeTask.isDefault() && Comparing.equal((Object)activeTask.getCreated(), (Object)activeTask.getUpdated());
    }

    @NlsActions.ActionText
    private static String getText(LocalTask activeTask) {
        String text = activeTask.getPresentableName();
        return StringUtil.first((String)text, (int)50, (boolean)true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SwitchTaskAction.$$$reportNull$$$0(3);
        }
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        assert (project != null);
        ListPopupImpl popup = SwitchTaskAction.createPopup(dataContext, null, true);
        popup.showCenteredInCurrentWindow(project);
    }

    private static ListPopupImpl createPopup(@NotNull DataContext dataContext, final @Nullable Runnable onDispose, boolean withTitle) {
        if (dataContext == null) {
            SwitchTaskAction.$$$reportNull$$$0(4);
        }
        final Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        final Ref shiftPressed = Ref.create((Object)false);
        final Ref componentRef = Ref.create();
        List items = project == null ? Collections.emptyList() : SwitchTaskAction.createPopupActionGroup(project, (Ref<Boolean>)shiftPressed, (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(dataContext));
        String title = withTitle ? TaskBundle.message((String)"popup.title.switch.to.task", (Object[])new Object[0]) : null;
        MultiSelectionListPopupStep<TaskListItem> step = new MultiSelectionListPopupStep<TaskListItem>(title, items){

            public PopupStep<?> onChosen(List<TaskListItem> selectedValues, boolean finalChoice) {
                if (finalChoice) {
                    selectedValues.get(0).select();
                    return FINAL_CHOICE;
                }
                ActionGroup group = SwitchTaskAction.createActionsStep(selectedValues, project, (Ref<Boolean>)shiftPressed);
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)componentRef.get());
                return JBPopupFactory.getInstance().createActionsStep(group, dataContext, null, false, false, null, null, true, 0, false);
            }

            public Icon getIconFor(TaskListItem aValue) {
                return aValue.getIcon();
            }

            @NotNull
            public String getTextFor(TaskListItem value) {
                String string = value.getText();
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Nullable
            public ListSeparator getSeparatorAbove(TaskListItem value) {
                return value.getSeparator() == null ? null : new ListSeparator(value.getSeparator());
            }

            public boolean hasSubstep(List<? extends TaskListItem> selectedValues) {
                return selectedValues.size() > 1 || selectedValues.get(0).getTask() != null;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/actions/SwitchTaskAction$2", "getTextFor"));
            }
        };
        final ListPopupImpl popup = (ListPopupImpl)JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        if (onDispose != null) {
            Disposer.register((Disposable)popup, (Disposable)new Disposable(){

                public void dispose() {
                    onDispose.run();
                }
            });
        }
        componentRef.set((Object)popup.getComponent());
        if (items.size() <= 2) {
            return popup;
        }
        popup.setAdText(TaskBundle.message((String)"popup.advertisement.press.shift.to.merge.with.current.context", (Object[])new Object[0]));
        popup.registerAction("shiftPressed", KeyStroke.getKeyStroke("shift pressed SHIFT"), (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                shiftPressed.set((Object)true);
                popup.setCaption(TaskBundle.message((String)"popup.title.merge.with.current.context", (Object[])new Object[0]));
            }
        });
        popup.registerAction("shiftReleased", KeyStroke.getKeyStroke("released SHIFT"), (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                shiftPressed.set((Object)false);
                popup.setCaption(TaskBundle.message((String)"popup.title.switch.to.task", (Object[])new Object[0]));
            }
        });
        popup.registerAction("invoke", KeyStroke.getKeyStroke("shift ENTER"), (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popup.handleSelect(true);
            }
        });
        return popup;
    }

    private static ActionGroup createActionsStep(final List<TaskListItem> tasks, final Project project, final Ref<Boolean> shiftPressed) {
        SimpleActionGroup group = new SimpleActionGroup();
        final TaskManager manager = TaskManager.getManager((Project)project);
        final LocalTask task = tasks.get(0).getTask();
        if (tasks.size() == 1 && task != null) {
            group.add((AnAction)new DumbAwareAction(TaskBundle.message((String)"action.switch.to.text", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    manager.activateTask((Task)task, (Boolean)shiftPressed.get() == false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/tasks/actions/SwitchTaskAction$7", "actionPerformed"));
                }
            });
            group.add((AnAction)new DumbAwareAction(TaskBundle.message((String)"action.edit.text.with.mnemonic", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    EditTaskDialog.editTask((LocalTaskImpl)task, project);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/tasks/actions/SwitchTaskAction$8", "actionPerformed"));
                }
            });
        }
        DumbAwareAction remove = new DumbAwareAction(TaskBundle.message((String)"action.remove.text", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                for (TaskListItem item : tasks) {
                    LocalTask itemTask = item.getTask();
                    if (itemTask == null) continue;
                    SwitchTaskAction.removeTask(project, itemTask, manager);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/tasks/actions/SwitchTaskAction$9", "actionPerformed"));
            }
        };
        remove.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(127, 0)), null);
        group.add((AnAction)remove);
        return group;
    }

    @NotNull
    private static List<TaskListItem> createPopupActionGroup(@NotNull Project project, final Ref<Boolean> shiftPressed, final Component contextComponent) {
        if (project == null) {
            SwitchTaskAction.$$$reportNull$$$0(5);
        }
        ArrayList<TaskListItem> group = new ArrayList<TaskListItem>();
        AnAction action = ActionManager.getInstance().getAction("tasks.goto");
        assert (action instanceof GotoTaskAction);
        final GotoTaskAction gotoTaskAction = (GotoTaskAction)action;
        group.add(new TaskListItem(gotoTaskAction.getTemplatePresentation().getText(), gotoTaskAction.getTemplatePresentation().getIcon()){

            @Override
            void select() {
                ActionManager.getInstance().tryToExecute((AnAction)gotoTaskAction, ActionCommand.getInputEvent((String)"tasks.goto"), contextComponent, "unknown", false);
            }
        });
        final TaskManager manager = TaskManager.getManager((Project)project);
        LocalTask activeTask = manager.getActiveTask();
        List localTasks = manager.getLocalTasks();
        localTasks.sort(TaskManagerImpl.TASK_UPDATE_COMPARATOR);
        ArrayList<LocalTask> temp = new ArrayList<LocalTask>();
        for (final LocalTask task : localTasks) {
            if (task == activeTask) continue;
            if (manager.isLocallyClosed(task)) {
                temp.add(task);
                continue;
            }
            group.add(new TaskListItem(task, group.size() == 1 ? "" : null, false){

                @Override
                void select() {
                    manager.activateTask((Task)task, (Boolean)shiftPressed.get() == false);
                }
            });
        }
        if (!temp.isEmpty()) {
            int tempSize = temp.size();
            for (int i = 0; i < Math.min(tempSize, 15); ++i) {
                final LocalTask task = (LocalTask)temp.get(i);
                group.add(new TaskListItem(task, i == 0 ? TaskBundle.message((String)"separator.recently.closed.tasks", (Object[])new Object[0]) : null, true){

                    @Override
                    void select() {
                        manager.activateTask((Task)task, (Boolean)shiftPressed.get() == false);
                    }
                });
            }
        }
        ArrayList<TaskListItem> arrayList = group;
        if (arrayList == null) {
            SwitchTaskAction.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public static void removeTask(@NotNull Project project, @NotNull LocalTask task, @NotNull TaskManager manager) {
        if (project == null) {
            SwitchTaskAction.$$$reportNull$$$0(7);
        }
        if (task == null) {
            SwitchTaskAction.$$$reportNull$$$0(8);
        }
        if (manager == null) {
            SwitchTaskAction.$$$reportNull$$$0(9);
        }
        if (task.isDefault()) {
            Messages.showInfoMessage((Project)project, (String)TaskBundle.message((String)"dialog.message.default.task.cannot.be.removed", (Object[])new Object[0]), (String)TaskBundle.message((String)"dialog.title.cannot.remove", (Object[])new Object[0]));
        } else {
            List infos = task.getChangeLists();
            List lists = ContainerUtil.mapNotNull((Collection)infos, (Function)((NullableFunction)changeListInfo -> {
                LocalChangeList changeList = ChangeListManager.getInstance((Project)project).getChangeList(changeListInfo.id);
                return changeList != null && !changeList.isDefault() ? changeList : null;
            }));
            boolean removeIt = true;
            block4: for (LocalChangeList list : lists) {
                if (list.getChanges().isEmpty()) continue;
                int result = Messages.showYesNoCancelDialog((Project)project, (String)TaskBundle.message((String)"dialog.message.changelist.associated.with.not.empty", (Object[])new Object[]{task.getSummary()}), (String)TaskBundle.message((String)"dialog.title.changelist.not.empty", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
                switch (result) {
                    case 0: {
                        break block4;
                    }
                    case 1: {
                        removeIt = false;
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (removeIt) {
                for (LocalChangeList list : lists) {
                    ChangeListManager.getInstance((Project)project).removeChangeList(list);
                }
            }
            manager.removeTask(task);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/actions/SwitchTaskAction";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/actions/SwitchTaskAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPopupActionGroup";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

