/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.trello.model;

import com.google.gson.annotations.SerializedName;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.tasks.trello.model.TrelloCommentAction;
import com.intellij.tasks.trello.model.TrelloLabel;
import com.intellij.tasks.trello.model.TrelloModel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrelloCard
extends TrelloModel {
    public static final String REQUIRED_FIELDS = "closed,desc,idMembers,idBoard,idList,idShort,labels,name,url,dateLastActivity";
    private String idBoard;
    private String idList;
    private String idShort;
    private List<String> idMembers;
    @NotNull
    private String name = "";
    @SerializedName(value="desc")
    private String description;
    private String url;
    private boolean closed;
    private Date dateLastActivity;
    private List<TrelloLabel> labels;
    @SerializedName(value="actions")
    private final List<TrelloCommentAction> comments = ContainerUtil.emptyList();
    private boolean isVisible = true;

    public String toString() {
        return String.format("TrelloCard(id='%s', name='%s')", this.getId(), this.name);
    }

    @NotNull
    public String getIdBoard() {
        String string = this.idBoard;
        if (string == null) {
            TrelloCard.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getIdList() {
        String string = this.idList;
        if (string == null) {
            TrelloCard.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getIdShort() {
        String string = this.idShort;
        if (string == null) {
            TrelloCard.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public List<String> getIdMembers() {
        List<String> list = this.idMembers;
        if (list == null) {
            TrelloCard.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @Attribute(value="name")
    @NotNull
    @NlsSafe
    public String getName() {
        String string = this.name;
        if (string == null) {
            TrelloCard.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public void setName(@NotNull String name) {
        if (name == null) {
            TrelloCard.$$$reportNull$$$0(5);
        }
        this.name = name;
    }

    @NotNull
    @NlsSafe
    public String getDescription() {
        String string = this.description;
        if (string == null) {
            TrelloCard.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getUrl() {
        String string = this.url;
        if (string == null) {
            TrelloCard.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @NotNull
    public List<TrelloLabel> getLabels() {
        List<TrelloLabel> list = this.labels;
        if (list == null) {
            TrelloCard.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public List<TrelloCommentAction> getComments() {
        List<TrelloCommentAction> list = this.comments;
        if (list == null) {
            TrelloCard.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public Set<TrelloLabel.LabelColor> getColors() {
        if (this.labels == null || this.labels.isEmpty()) {
            EnumSet<TrelloLabel.LabelColor> enumSet = EnumSet.noneOf(TrelloLabel.LabelColor.class);
            if (enumSet == null) {
                TrelloCard.$$$reportNull$$$0(10);
            }
            return enumSet;
        }
        List labelColors = ContainerUtil.mapNotNull(this.labels, label -> {
            TrelloLabel.LabelColor color = label.getColor();
            return color == TrelloLabel.LabelColor.NO_COLOR ? null : color;
        });
        EnumSet<TrelloLabel.LabelColor> enumSet = labelColors.isEmpty() ? EnumSet.noneOf(TrelloLabel.LabelColor.class) : EnumSet.copyOf(labelColors);
        if (enumSet == null) {
            TrelloCard.$$$reportNull$$$0(11);
        }
        return enumSet;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Nullable
    public Date getDateLastActivity() {
        return this.dateLastActivity;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/trello/model/TrelloCard";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdBoard";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdShort";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdMembers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/trello/model/TrelloCard";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabels";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getComments";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getColors";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

