/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.auth;

import java.util.Date;
import org.gradle.internal.impldep.com.amazonaws.annotation.SdkInternalApi;
import org.gradle.internal.impldep.com.amazonaws.annotation.ThreadSafe;
import org.gradle.internal.impldep.com.amazonaws.auth.SessionCredentialsHolder;
import org.gradle.internal.impldep.com.amazonaws.internal.SdkPredicate;

@SdkInternalApi
@ThreadSafe
class ShouldDoBlockingSessionRefresh
extends SdkPredicate<SessionCredentialsHolder> {
    private static final int EXPIRY_TIME_MILLIS = 60000;

    ShouldDoBlockingSessionRefresh() {
    }

    @Override
    public boolean test(SessionCredentialsHolder sessionCredentialsHolder) {
        return sessionCredentialsHolder == null || ShouldDoBlockingSessionRefresh.expiring(sessionCredentialsHolder.getSessionCredentialsExpiration());
    }

    private static boolean expiring(Date expiry) {
        long timeRemaining = expiry.getTime() - System.currentTimeMillis();
        return timeRemaining < 60000L;
    }
}

