/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.jcifs.smb;

import org.gradle.internal.impldep.jcifs.smb.ServerMessageBlock;
import org.gradle.internal.impldep.jcifs.smb.SmbComTransactionResponse;

class Trans2GetDfsReferralResponse
extends SmbComTransactionResponse {
    int pathConsumed;
    int numReferrals;
    int flags;
    Referral[] referrals;

    Trans2GetDfsReferralResponse() {
        this.subCommand = (byte)16;
    }

    int writeSetupWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int writeParametersWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        int start = bufferIndex;
        this.pathConsumed = Trans2GetDfsReferralResponse.readInt2(buffer, bufferIndex);
        bufferIndex += 2;
        if ((this.flags2 & 0x8000) != 0) {
            this.pathConsumed /= 2;
        }
        this.numReferrals = Trans2GetDfsReferralResponse.readInt2(buffer, bufferIndex);
        this.flags = Trans2GetDfsReferralResponse.readInt2(buffer, bufferIndex += 2);
        bufferIndex += 4;
        this.referrals = new Referral[this.numReferrals];
        for (int ri = 0; ri < this.numReferrals; ++ri) {
            this.referrals[ri] = new Referral();
            bufferIndex += this.referrals[ri].readWireFormat(buffer, bufferIndex, len);
        }
        return bufferIndex - start;
    }

    public String toString() {
        return new String("Trans2GetDfsReferralResponse[" + super.toString() + ",pathConsumed=" + this.pathConsumed + ",numReferrals=" + this.numReferrals + ",flags=" + this.flags + "]");
    }

    class Referral {
        private int version;
        private int size;
        private int serverType;
        private int flags;
        private int proximity;
        private int pathOffset;
        private int altPathOffset;
        private int nodeOffset;
        private String altPath;
        int ttl;
        String path = null;
        String node = null;

        Referral() {
        }

        int readWireFormat(byte[] buffer, int bufferIndex, int len) {
            int start = bufferIndex;
            this.version = ServerMessageBlock.readInt2(buffer, bufferIndex);
            if (this.version != 3 && this.version != 1) {
                throw new RuntimeException("Version " + this.version + " referral not supported. Please report this to jcifs at samba dot org.");
            }
            this.size = ServerMessageBlock.readInt2(buffer, bufferIndex += 2);
            this.serverType = ServerMessageBlock.readInt2(buffer, bufferIndex += 2);
            this.flags = ServerMessageBlock.readInt2(buffer, bufferIndex += 2);
            bufferIndex += 2;
            if (this.version == 3) {
                this.proximity = ServerMessageBlock.readInt2(buffer, bufferIndex);
                this.ttl = ServerMessageBlock.readInt2(buffer, bufferIndex += 2);
                this.pathOffset = ServerMessageBlock.readInt2(buffer, bufferIndex += 2);
                this.altPathOffset = ServerMessageBlock.readInt2(buffer, bufferIndex += 2);
                this.nodeOffset = ServerMessageBlock.readInt2(buffer, bufferIndex += 2);
                bufferIndex += 2;
                this.path = Trans2GetDfsReferralResponse.this.readString(buffer, start + this.pathOffset, len, (Trans2GetDfsReferralResponse.this.flags2 & 0x8000) != 0);
                if (this.nodeOffset > 0) {
                    this.node = Trans2GetDfsReferralResponse.this.readString(buffer, start + this.nodeOffset, len, (Trans2GetDfsReferralResponse.this.flags2 & 0x8000) != 0);
                }
            } else if (this.version == 1) {
                this.node = Trans2GetDfsReferralResponse.this.readString(buffer, bufferIndex, len, (Trans2GetDfsReferralResponse.this.flags2 & 0x8000) != 0);
            }
            return this.size;
        }

        public String toString() {
            return new String("Referral[version=" + this.version + ",size=" + this.size + ",serverType=" + this.serverType + ",flags=" + this.flags + ",proximity=" + this.proximity + ",ttl=" + this.ttl + ",pathOffset=" + this.pathOffset + ",altPathOffset=" + this.altPathOffset + ",nodeOffset=" + this.nodeOffset + ",path=" + this.path + ",altPath=" + this.altPath + ",node=" + this.node + "]");
        }
    }
}

