/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.launcher.core;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.internal.impldep.org.apiguardian.api.API;
import org.gradle.internal.impldep.org.junit.platform.commons.JUnitException;
import org.gradle.internal.impldep.org.junit.platform.commons.logging.Logger;
import org.gradle.internal.impldep.org.junit.platform.commons.logging.LoggerFactory;
import org.gradle.internal.impldep.org.junit.platform.commons.util.UnrecoverableExceptions;
import org.gradle.internal.impldep.org.junit.platform.engine.Filter;
import org.gradle.internal.impldep.org.junit.platform.engine.FilterResult;
import org.gradle.internal.impldep.org.junit.platform.engine.TestDescriptor;
import org.gradle.internal.impldep.org.junit.platform.engine.TestEngine;
import org.gradle.internal.impldep.org.junit.platform.engine.UniqueId;
import org.gradle.internal.impldep.org.junit.platform.launcher.EngineDiscoveryResult;
import org.gradle.internal.impldep.org.junit.platform.launcher.LauncherDiscoveryListener;
import org.gradle.internal.impldep.org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.gradle.internal.impldep.org.junit.platform.launcher.PostDiscoveryFilter;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.EngineDiscoveryErrorDescriptor;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.EngineDiscoveryResultValidator;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.LauncherDiscoveryResult;

@API(status=API.Status.INTERNAL, since="1.7", consumers={"testkit"})
public class EngineDiscoveryOrchestrator {
    private static final Logger logger = LoggerFactory.getLogger(EngineDiscoveryOrchestrator.class);
    private final EngineDiscoveryResultValidator discoveryResultValidator = new EngineDiscoveryResultValidator();
    private final Iterable<TestEngine> testEngines;
    private final Collection<PostDiscoveryFilter> postDiscoveryFilters;

    public EngineDiscoveryOrchestrator(Iterable<TestEngine> testEngines, Collection<PostDiscoveryFilter> postDiscoveryFilters) {
        this.testEngines = testEngines;
        this.postDiscoveryFilters = postDiscoveryFilters;
    }

    public LauncherDiscoveryResult discover(LauncherDiscoveryRequest request, String phase) {
        LinkedHashMap<TestEngine, TestDescriptor> testEngineDescriptors = new LinkedHashMap<TestEngine, TestDescriptor>();
        for (TestEngine testEngine : this.testEngines) {
            boolean engineIsExcluded = request.getEngineFilters().stream().map(engineFilter -> engineFilter.apply(testEngine)).anyMatch(FilterResult::excluded);
            if (engineIsExcluded) {
                logger.debug(() -> String.format("Test discovery for engine '%s' was skipped due to an EngineFilter in phase '%s'.", testEngine.getId(), phase));
                continue;
            }
            logger.debug(() -> String.format("Discovering tests during Launcher %s phase in engine '%s'.", phase, testEngine.getId()));
            TestDescriptor rootDescriptor = this.discoverEngineRoot(testEngine, request);
            testEngineDescriptors.put(testEngine, rootDescriptor);
        }
        LinkedList<PostDiscoveryFilter> filters = new LinkedList<PostDiscoveryFilter>(this.postDiscoveryFilters);
        filters.addAll(request.getPostDiscoveryFilters());
        this.applyPostDiscoveryFilters(testEngineDescriptors, filters);
        this.prune(testEngineDescriptors);
        return new LauncherDiscoveryResult(testEngineDescriptors, request.getConfigurationParameters());
    }

    private TestDescriptor discoverEngineRoot(TestEngine testEngine, LauncherDiscoveryRequest discoveryRequest) {
        LauncherDiscoveryListener discoveryListener = discoveryRequest.getDiscoveryListener();
        UniqueId uniqueEngineId = UniqueId.forEngine(testEngine.getId());
        try {
            discoveryListener.engineDiscoveryStarted(uniqueEngineId);
            TestDescriptor engineRoot = testEngine.discover(discoveryRequest, uniqueEngineId);
            this.discoveryResultValidator.validate(testEngine, engineRoot);
            discoveryListener.engineDiscoveryFinished(uniqueEngineId, EngineDiscoveryResult.successful());
            return engineRoot;
        }
        catch (Throwable throwable) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(throwable);
            String message = String.format("TestEngine with ID '%s' failed to discover tests", testEngine.getId());
            JUnitException cause = new JUnitException(message, throwable);
            discoveryListener.engineDiscoveryFinished(uniqueEngineId, EngineDiscoveryResult.failed(cause));
            return new EngineDiscoveryErrorDescriptor(uniqueEngineId, testEngine, cause);
        }
    }

    private void applyPostDiscoveryFilters(Map<TestEngine, TestDescriptor> testEngineDescriptors, List<PostDiscoveryFilter> filters) {
        Filter postDiscoveryFilter = Filter.composeFilters(filters);
        LinkedHashMap<String, List<TestDescriptor>> excludedTestDescriptorsByReason = new LinkedHashMap<String, List<TestDescriptor>>();
        TestDescriptor.Visitor removeExcludedTestDescriptors = descriptor -> {
            FilterResult filterResult = postDiscoveryFilter.apply(descriptor);
            if (!descriptor.isRoot() && this.isExcluded(descriptor, filterResult)) {
                this.populateExclusionReasonInMap(filterResult.getReason(), descriptor, excludedTestDescriptorsByReason);
                descriptor.removeFromHierarchy();
            }
        };
        this.acceptInAllTestEngines(testEngineDescriptors, removeExcludedTestDescriptors);
        this.logTestDescriptorExclusionReasons(excludedTestDescriptorsByReason);
    }

    private void populateExclusionReasonInMap(Optional<String> reason, TestDescriptor testDescriptor, Map<String, List<TestDescriptor>> excludedTestDescriptorsByReason) {
        excludedTestDescriptorsByReason.computeIfAbsent(reason.orElse("Unknown"), list -> new LinkedList()).add(testDescriptor);
    }

    private void logTestDescriptorExclusionReasons(Map<String, List<TestDescriptor>> excludedTestDescriptorsByReason) {
        excludedTestDescriptorsByReason.forEach((exclusionReason, testDescriptors) -> {
            String displayNames = testDescriptors.stream().map(TestDescriptor::getDisplayName).collect(Collectors.joining(", "));
            long containerCount = testDescriptors.stream().filter(TestDescriptor::isContainer).count();
            long methodCount = testDescriptors.stream().filter(TestDescriptor::isTest).count();
            logger.info(() -> String.format("%d containers and %d tests were %s", containerCount, methodCount, exclusionReason));
            logger.debug(() -> String.format("The following containers and tests were %s: %s", exclusionReason, displayNames));
        });
    }

    private void prune(Map<TestEngine, TestDescriptor> testEngineDescriptors) {
        this.acceptInAllTestEngines(testEngineDescriptors, TestDescriptor::prune);
    }

    private boolean isExcluded(TestDescriptor descriptor, FilterResult filterResult) {
        return descriptor.getChildren().isEmpty() && filterResult.excluded();
    }

    private void acceptInAllTestEngines(Map<TestEngine, TestDescriptor> testEngineDescriptors, TestDescriptor.Visitor visitor) {
        testEngineDescriptors.values().forEach(descriptor -> descriptor.accept(visitor));
    }
}

