/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.FastUtilHashingStrategies;
import com.intellij.util.containers.HashingStrategy;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileCollectionFactory {
    private static final HashingStrategy<File> FILE_HASH_STRATEGY = new SerializableHashingStrategy<File>(){

        @Override
        public int hashCode(@Nullable File o) {
            return FileUtilRt.pathHashCode(o == null ? null : o.getPath());
        }

        @Override
        public boolean equals(@Nullable File a, @Nullable File b) {
            return FileUtilRt.pathsEqual(a == null ? null : a.getPath(), b == null ? null : b.getPath());
        }
    };
    public static final HashingStrategy<String> FILE_PATH_HASH_STRATEGY = new HashingStrategy<String>(){

        @Override
        public int hashCode(@Nullable String o) {
            return FileUtilRt.pathHashCode(o);
        }

        @Override
        public boolean equals(@Nullable String p1, @Nullable String p2) {
            return FileUtilRt.pathsEqual(p1, p2);
        }
    };

    @NotNull
    public static <V> Map<Path, V> createCanonicalPathLinkedMap() {
        return new Object2ObjectLinkedOpenCustomHashMap((Hash.Strategy)new PathSerializableHashStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createCanonicalFilePathLinkedMap() {
        return new Object2ObjectLinkedOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<String>(){

            public int hashCode(@Nullable String value) {
                return FileUtilRt.pathHashCode(value);
            }

            public boolean equals(@Nullable String val1, @Nullable String val2) {
                return FileUtilRt.pathsEqual(val1, val2);
            }
        });
    }

    @NotNull
    public static <V> Map<File, V> createCanonicalFileMap() {
        Map map2 = CollectionFactory.createCustomHashingStrategyMap(FILE_HASH_STRATEGY);
        if (map2 == null) {
            FileCollectionFactory.$$$reportNull$$$0(0);
        }
        return map2;
    }

    @NotNull
    public static <V> Map<File, V> createCanonicalFileMap(int expected) {
        Map map2 = CollectionFactory.createCustomHashingStrategyMap(expected, FILE_HASH_STRATEGY);
        if (map2 == null) {
            FileCollectionFactory.$$$reportNull$$$0(1);
        }
        return map2;
    }

    @NotNull
    public static <V> Map<File, V> createCanonicalFileMap(@NotNull Map<? extends File, ? extends V> map2) {
        if (map2 == null) {
            FileCollectionFactory.$$$reportNull$$$0(2);
        }
        Map<File, V> result = FileCollectionFactory.createCanonicalFileMap(map2.size());
        result.putAll(map2);
        Map<File, V> map3 = result;
        if (map3 == null) {
            FileCollectionFactory.$$$reportNull$$$0(3);
        }
        return map3;
    }

    @NotNull
    public static Set<File> createCanonicalFileSet() {
        Set<File> set = CollectionFactory.createCustomHashingStrategySet(FILE_HASH_STRATEGY);
        if (set == null) {
            FileCollectionFactory.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public static Set<File> createCanonicalFileSet(@NotNull Collection<? extends File> files2) {
        if (files2 == null) {
            FileCollectionFactory.$$$reportNull$$$0(5);
        }
        Set<File> set = FileCollectionFactory.createCanonicalFileSet();
        set.addAll(files2);
        Set<File> set2 = set;
        if (set2 == null) {
            FileCollectionFactory.$$$reportNull$$$0(6);
        }
        return set2;
    }

    @NotNull
    public static Set<Path> createCanonicalPathSet() {
        return new ObjectOpenCustomHashSet((Hash.Strategy)new PathSerializableHashStrategy());
    }

    @NotNull
    public static Set<Path> createCanonicalPathSet(@NotNull Collection<? extends Path> files2) {
        if (files2 == null) {
            FileCollectionFactory.$$$reportNull$$$0(7);
        }
        return new ObjectOpenCustomHashSet(files2, (Hash.Strategy)new PathSerializableHashStrategy());
    }

    @NotNull
    public static Set<File> createCanonicalFileLinkedSet() {
        return new ObjectLinkedOpenCustomHashSet((Hash.Strategy)new Hash.Strategy<File>(){

            public int hashCode(@Nullable File o) {
                return FileUtilRt.pathHashCode(o == null ? null : o.getPath());
            }

            public boolean equals(@Nullable File a, @Nullable File b) {
                return FileUtilRt.pathsEqual(a == null ? null : a.getPath(), b == null ? null : b.getPath());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/FileCollectionFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCanonicalFileMap";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/FileCollectionFactory";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCanonicalFileSet";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCanonicalFileMap";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCanonicalFileSet";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCanonicalPathSet";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PathSerializableHashStrategy
    implements FastUtilHashingStrategies.SerializableHashStrategy<Path> {
        private PathSerializableHashStrategy() {
        }

        public int hashCode(@Nullable Path o) {
            return FileUtilRt.pathHashCode(o == null ? null : o.toString());
        }

        public boolean equals(@Nullable Path a, @Nullable Path b) {
            return FileUtilRt.pathsEqual(a == null ? null : a.toString(), b == null ? null : b.toString());
        }
    }

    private static interface SerializableHashingStrategy<T>
    extends HashingStrategy<T>,
    Serializable {
    }
}

