/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.util.PathUtilRt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedNioFile;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.ByteRange;
import org.jetbrains.io.FileResponsesKt;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011J6\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J*\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ6\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/io/FileResponses;", "", "()V", "checkCache", "", "request", "Lio/netty/handler/codec/http/HttpRequest;", "channel", "Lio/netty/channel/Channel;", "lastModified", "", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "doPrepareResponse", "Lio/netty/handler/codec/http/DefaultHttpResponse;", "response", "filename", "", "getContentType", "path", "prepareSend", "Lio/netty/handler/codec/http/HttpResponse;", "sendFile", "", "file", "Ljava/nio/file/Path;", "extraSuffix", "", "intellij.platform.ide.util.netty"})
public final class FileResponses {
    @NotNull
    public static final FileResponses INSTANCE;

    @NotNull
    public final String getContentType(@NotNull String path) {
        String string2;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                string2 = PathUtilRt.getFileExtension(path);
                if (string2 == null) break block2;
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                string2 = (String)FileResponsesKt.access$getFileExtToMimeType$p().get(it);
                if (string2 != null) break block3;
            }
            string2 = "application/octet-stream";
        }
        return string2;
    }

    @JvmOverloads
    public final boolean checkCache(@NotNull HttpRequest request, @NotNull Channel channel, long lastModified, @Nullable HttpHeaders extraHeaders) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Long ifModified = request.headers().getTimeMillis((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE);
        if (ifModified != null && ifModified >= lastModified) {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_MODIFIED;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"HttpResponseStatus.NOT_MODIFIED");
            Responses.send$default(httpResponseStatus, channel, request, null, extraHeaders, 4, null);
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean checkCache$default(FileResponses fileResponses, HttpRequest httpRequest, Channel channel, long l, HttpHeaders httpHeaders, int n, Object object) {
        if ((n & 8) != 0) {
            httpHeaders = null;
        }
        return fileResponses.checkCache(httpRequest, channel, l, httpHeaders);
    }

    @JvmOverloads
    public final boolean checkCache(@NotNull HttpRequest request, @NotNull Channel channel, long lastModified) {
        return FileResponses.checkCache$default(this, request, channel, lastModified, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public final HttpResponse prepareSend(@NotNull HttpRequest request, @NotNull Channel channel, long lastModified, @NotNull String filename, @Nullable HttpHeaders extraHeaders) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        if (request.headers().get((CharSequence)HttpHeaderNames.RANGE) == null && this.checkCache(request, channel, lastModified, extraHeaders)) {
            return null;
        }
        return (HttpResponse)this.doPrepareResponse(new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK), filename, lastModified, extraHeaders);
    }

    public static /* synthetic */ HttpResponse prepareSend$default(FileResponses fileResponses, HttpRequest httpRequest, Channel channel, long l, String string2, HttpHeaders httpHeaders, int n, Object object) {
        if ((n & 0x10) != 0) {
            httpHeaders = null;
        }
        return fileResponses.prepareSend(httpRequest, channel, l, string2, httpHeaders);
    }

    @JvmOverloads
    @Nullable
    public final HttpResponse prepareSend(@NotNull HttpRequest request, @NotNull Channel channel, long lastModified, @NotNull String filename) {
        return FileResponses.prepareSend$default(this, request, channel, lastModified, filename, null, 16, null);
    }

    private final DefaultHttpResponse doPrepareResponse(DefaultHttpResponse response, String filename, long lastModified, HttpHeaders extraHeaders) {
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)this.getContentType(filename));
        Responses.addCommonHeaders((HttpResponse)response);
        response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)HttpHeaderValues.NO_CACHE);
        if (Intrinsics.areEqual((Object)response.status(), (Object)HttpResponseStatus.PARTIAL_CONTENT) ^ true) {
            response.headers().set((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)new Date(lastModified));
        }
        if (extraHeaders != null) {
            response.headers().add(extraHeaders);
        }
        return response;
    }

    public final void sendFile(@NotNull HttpRequest request, @NotNull Channel channel, @NotNull Path file2, @Nullable HttpHeaders extraHeaders) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.sendFile(request, channel, file2, extraHeaders, null);
    }

    public static /* synthetic */ void sendFile$default(FileResponses fileResponses, HttpRequest httpRequest, Channel channel, Path path, HttpHeaders httpHeaders, int n, Object object) {
        if ((n & 8) != 0) {
            httpHeaders = null;
        }
        fileResponses.sendFile(httpRequest, channel, path, httpHeaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendFile(@NotNull HttpRequest request, @NotNull Channel channel, @NotNull Path file2, @Nullable HttpHeaders extraHeaders, @Nullable byte[] extraSuffix) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FileChannel fileChannel = null;
        String rangeHeader = request.headers().get((CharSequence)HttpHeaderNames.RANGE);
        long lastModified = 0L;
        try {
            block15: {
                block16: {
                    lastModified = Files.getLastModifiedTime(file2, new LinkOption[0]).toMillis();
                    if (rangeHeader != null) break block15;
                    if (extraSuffix == null) break block16;
                    byte[] byArray = extraSuffix;
                    boolean bl = false;
                    if (!(byArray.length == 0)) break block15;
                }
                if (this.checkCache(request, channel, lastModified, extraHeaders)) {
                    return;
                }
            }
            FileChannel fileChannel2 = FileChannel.open(file2, StandardOpenOption.READ);
            Intrinsics.checkNotNullExpressionValue((Object)fileChannel2, (String)"FileChannel.open(file, StandardOpenOption.READ)");
            fileChannel = fileChannel2;
        }
        catch (NoSuchFileException ignored) {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"HttpResponseStatus.NOT_FOUND");
            Responses.send$default(httpResponseStatus, channel, request, null, null, 12, null);
            return;
        }
        boolean isKeepAlive = false;
        boolean fileWillBeClosed = false;
        try {
            long fileSize = fileChannel.size();
            long responseLength = fileSize + (long)(extraSuffix != null ? extraSuffix.length : 0);
            ByteRange byteRange = FileResponsesKt.access$parseRange(rangeHeader, responseLength);
            if (byteRange == null) {
                byteRange = new ByteRange(0L, responseLength);
            }
            ByteRange range = byteRange;
            boolean isPartialContent = range.getStart() != 0L || range.getEnd() != responseLength;
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, isPartialContent ? HttpResponseStatus.PARTIAL_CONTENT : HttpResponseStatus.OK);
            isKeepAlive = Responses.addKeepAliveIfNeeded((HttpResponse)response, request);
            this.doPrepareResponse(response, ((Object)file2.getFileName()).toString(), lastModified, extraHeaders);
            if (isPartialContent) {
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_RANGE, (Object)("bytes " + range.getStart() + '-' + (range.getEnd() - 1L) + '/' + responseLength));
            }
            HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)range.getLength());
            channel.write((Object)response);
            if (request.method() != HttpMethod.HEAD) {
                ByteRange suffixRange;
                ByteRange fileRange = range.intersect(0L, fileSize);
                if (fileRange != null && fileRange.getLength() > 0L) {
                    if (channel.pipeline().get(SslHandler.class) == null) {
                        channel.write((Object)new DefaultFileRegion(fileChannel, range.getStart(), fileRange.getLength()));
                    } else {
                        channel.write((Object)new ChunkedNioFile(fileChannel, range.getStart(), fileRange.getLength(), 8192));
                    }
                }
                if (extraSuffix != null && (suffixRange = range.intersect(fileSize, fileSize + (long)extraSuffix.length)) != null && suffixRange.getLength() > 0L) {
                    ByteBuf byteBuf = Unpooled.copiedBuffer((byte[])extraSuffix, (int)((int)(suffixRange.getStart() - fileSize)), (int)((int)suffixRange.getLength()));
                    channel.write((Object)byteBuf);
                }
            }
            fileWillBeClosed = true;
        }
        catch (Throwable throwable) {
            fileChannel.close();
            throw throwable;
        }
        FileResponsesKt.flushChunkedResponse(channel, isKeepAlive);
    }

    public static /* synthetic */ void sendFile$default(FileResponses fileResponses, HttpRequest httpRequest, Channel channel, Path path, HttpHeaders httpHeaders, byte[] byArray, int n, Object object) {
        if ((n & 8) != 0) {
            httpHeaders = null;
        }
        if ((n & 0x10) != 0) {
            byArray = null;
        }
        fileResponses.sendFile(httpRequest, channel, path, httpHeaders, byArray);
    }

    private FileResponses() {
    }

    static {
        FileResponses fileResponses;
        INSTANCE = fileResponses = new FileResponses();
    }
}

