/*
 * Decompiled with CFR 0.152.
 */
package training.learn;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.KeyedLazyInstanceEP;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.learn.OpenLessonActivities;
import training.learn.OpenLessonParameters;
import training.learn.course.IftModule;
import training.learn.course.KLesson;
import training.learn.course.LearningCourse;
import training.learn.course.LearningCourseBase;
import training.learn.course.Lesson;
import training.learn.lesson.LessonManager;
import training.statistic.LessonStartingWay;
import training.ui.LearnToolWindow;
import training.util.UtilsKt;
import training.util.WeakReferenceDelegator;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 B2\u00020\u0001:\u0002BCB\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010(\u001a\u00020)J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020)H\u0016J\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\u00120\u00172\u0006\u00101\u001a\u00020\u0005J\u0010\u00102\u001a\u0004\u0018\u00010\r2\u0006\u00103\u001a\u00020\u0005J\u000e\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00020\u0012J*\u00106\u001a\u00020)2\u0006\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010\r2\u0006\u0010:\u001a\u00020;2\b\b\u0002\u0010<\u001a\u00020\bJ\b\u0010=\u001a\u00020)H\u0002J\u0016\u0010>\u001a\u00020)2\u0006\u00105\u001a\u00020\u00122\u0006\u0010?\u001a\u00020\u0013J\b\u0010@\u001a\u00020)H\u0002J\b\u0010A\u001a\u00020)H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000fR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR/\u0010!\u001a\u0004\u0018\u00010\u00122\b\u0010 \u001a\u0004\u0018\u00010\u00128F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006D"}, d2={"Ltraining/learn/CourseManager;", "Lcom/intellij/openapi/Disposable;", "()V", "commonCourses", "Lcom/intellij/util/containers/MultiMap;", "", "Ltraining/learn/CourseManager$ModuleInfo;", "currentConfiguration", "", "languageCourses", "Ltraining/lang/LangSupport;", "lessonsForModules", "", "Ltraining/learn/course/Lesson;", "getLessonsForModules", "()Ljava/util/List;", "mapModuleVirtualFile", "", "Ltraining/learn/course/IftModule;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getMapModuleVirtualFile", "()Ljava/util/Map;", "modules", "", "getModules", "()Ljava/util/Collection;", "newLessons", "getNewLessons", "previousOpenedVersion", "Lcom/intellij/openapi/util/BuildNumber;", "getPreviousOpenedVersion", "()Lcom/intellij/openapi/util/BuildNumber;", "<set-?>", "unfoldModuleOnInit", "getUnfoldModuleOnInit", "()Ltraining/learn/course/IftModule;", "setUnfoldModuleOnInit", "(Ltraining/learn/course/IftModule;)V", "unfoldModuleOnInit$delegate", "Ltraining/util/WeakReferenceDelegator;", "clearModules", "", "createModules", "course", "Ltraining/learn/course/LearningCourse;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "dispose", "findCommonModules", "commonCourseId", "findLessonById", "lessonId", "isModuleExternal", "module", "openLesson", "projectWhereToOpen", "Lcom/intellij/openapi/project/Project;", "lesson", "startingWay", "Ltraining/statistic/LessonStartingWay;", "forceStartLesson", "prepareLangModules", "registerVirtualFile", "virtualFile", "reloadCommonModules", "reloadLangModules", "Companion", "ModuleInfo", "intellij.featuresTrainer"})
public final class CourseManager
implements Disposable {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @Nullable
    private final BuildNumber previousOpenedVersion;
    @NotNull
    private final Map<IftModule, VirtualFile> mapModuleVirtualFile;
    @Nullable
    private final WeakReferenceDelegator unfoldModuleOnInit$delegate;
    private final MultiMap<LangSupport, ModuleInfo> languageCourses;
    private final MultiMap<String, ModuleInfo> commonCourses;
    private boolean currentConfiguration;
    @NotNull
    private static final ExtensionPointName<LanguageExtensionPoint<LearningCourseBase>> COURSE_MODULES_EP;
    @NotNull
    private static final ExtensionPointName<KeyedLazyInstanceEP<LearningCourse>> COMMON_COURSE_MODULES_EP;
    @NotNull
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(CourseManager.class, "unfoldModuleOnInit", "getUnfoldModuleOnInit()Ltraining/learn/course/IftModule;", 0))};
        Companion = new Companion(null);
        COURSE_MODULES_EP = new ExtensionPointName("training.ift.learning.course");
        COMMON_COURSE_MODULES_EP = new ExtensionPointName("training.ift.learning.commonCourse");
    }

    @Nullable
    public final BuildNumber getPreviousOpenedVersion() {
        return this.previousOpenedVersion;
    }

    @NotNull
    public final Map<IftModule, VirtualFile> getMapModuleVirtualFile() {
        return this.mapModuleVirtualFile;
    }

    @Nullable
    public final IftModule getUnfoldModuleOnInit() {
        return (IftModule)this.unfoldModuleOnInit$delegate.getValue(this, $$delegatedProperties[0]);
    }

    public final void setUnfoldModuleOnInit(@Nullable IftModule iftModule) {
        this.unfoldModuleOnInit$delegate.setValue(this, $$delegatedProperties[0], iftModule);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<IftModule> getModules() {
        Collection collection;
        this.prepareLangModules();
        LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
        if (langSupport2 != null) {
            void $this$mapTo$iv$iv;
            LangSupport langSupport3 = langSupport2;
            boolean bl = false;
            boolean bl2 = false;
            LangSupport it = langSupport3;
            boolean bl3 = false;
            Collection collection2 = this.languageCourses.get((Object)it);
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"languageCourses[it]");
            Iterable $this$map$iv = collection2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void receiver;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection3 = destination$iv$iv;
                boolean bl4 = false;
                IftModule iftModule = ((ModuleInfo)receiver).getModule();
                collection3.add(iftModule);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Lesson> getLessonsForModules() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getModules();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IftModule iftModule = (IftModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List<KLesson> list2 = it.getLessons();
            collection.add(list2);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Lesson> getNewLessons() {
        BuildNumber buildNumber = this.previousOpenedVersion;
        if (buildNumber == null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.getLessonsForModules();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Lesson it = (Lesson)element$iv$iv;
                boolean bl = false;
                if (!(it.getProperties().getAvailableSince() != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        BuildNumber previousVersion = buildNumber;
        Iterable $this$filter$iv = this.getLessonsForModules();
        boolean $i$f$filter = false;
        Iterable $this$filterTo$iv$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            Lesson it = (Lesson)element$iv$iv;
            boolean bl2 = false;
            if (it.getPassed$intellij_featuresTrainer()) {
                bl = false;
            } else if (it.getProperties().getAvailableSince() == null) {
                bl = false;
            } else {
                String availableSince;
                BuildNumber lessonVersion = BuildNumber.fromString((String)availableSince);
                if (lessonVersion == null) {
                    CourseManager $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(CourseManager.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.error("Invalid lesson version: " + availableSince);
                    bl = false;
                } else {
                    bl = lessonVersion.compareTo(previousVersion) > 0;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public void dispose() {
    }

    public final void clearModules() {
        this.languageCourses.clear();
        this.commonCourses.clear();
    }

    public final void registerVirtualFile(@NotNull IftModule module, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        this.mapModuleVirtualFile.put(module, virtualFile);
    }

    public final void openLesson(@NotNull Project projectWhereToOpen, @Nullable Lesson lesson, @NotNull LessonStartingWay startingWay, boolean forceStartLesson) {
        Intrinsics.checkNotNullParameter((Object)projectWhereToOpen, (String)"projectWhereToOpen");
        Intrinsics.checkNotNullParameter((Object)((Object)startingWay), (String)"startingWay");
        LessonManager.Companion.getInstance().stopLesson();
        if (lesson == null) {
            return;
        }
        OpenLessonActivities.INSTANCE.openLesson(new OpenLessonParameters(projectWhereToOpen, lesson, forceStartLesson, startingWay));
    }

    public static /* synthetic */ void openLesson$default(CourseManager courseManager, Project project, Lesson lesson, LessonStartingWay lessonStartingWay, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        courseManager.openLesson(project, lesson, lessonStartingWay, bl);
    }

    @Nullable
    public final Lesson findLessonById(@NotNull String lessonId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)lessonId, (String)"lessonId");
            Iterable $this$firstOrNull$iv = this.getLessonsForModules();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Lesson it = (Lesson)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)lessonId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<IftModule> findCommonModules(@NotNull String commonCourseId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)commonCourseId, (String)"commonCourseId");
        if (this.commonCourses.isEmpty()) {
            this.reloadCommonModules();
        }
        Collection collection = this.commonCourses.get((Object)commonCourseId);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"commonCourses[commonCourseId]");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void receiver;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            IftModule iftModule = ((ModuleInfo)receiver).getModule();
            collection2.add(iftModule);
        }
        return (List)destination$iv$iv;
    }

    public final boolean isModuleExternal(@NotNull IftModule module) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            this.prepareLangModules();
            if (this.commonCourses.isEmpty()) {
                this.reloadCommonModules();
            }
            Collection collection = this.languageCourses.values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"languageCourses.values()");
            Collection collection2 = this.commonCourses.values();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"commonCourses.values()");
            Iterable $this$any$iv = CollectionsKt.plus((Collection)collection, (Iterable)collection2);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ModuleInfo it = (ModuleInfo)element$iv;
                    boolean bl2 = false;
                    if (!(it.isExternal() && Intrinsics.areEqual((Object)it.getModule().getId(), (Object)module.getId()))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void reloadLangModules() {
        void $this$filterTo$iv$iv;
        Object[] objectArray = COURSE_MODULES_EP.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"COURSE_MODULES_EP.extensions");
        Object[] $this$filter$iv = objectArray;
        boolean $i$f$filter = false;
        Object[] objectArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            LanguageExtensionPoint it = (LanguageExtensionPoint)element$iv$iv;
            boolean bl = false;
            String string = it.language;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.language");
            if (!UtilsKt.courseCanBeUsed(string)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List extensions = (List)destination$iv$iv;
        for (LanguageExtensionPoint e : extensions) {
            LangManager langManager = LangManager.Companion.getInstance();
            String string = e.language;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.language");
            LangSupport langSupport2 = langManager.getLangSupportById(string);
            if (langSupport2 == null) continue;
            LanguageExtensionPoint languageExtensionPoint = e;
            Intrinsics.checkNotNullExpressionValue((Object)languageExtensionPoint, (String)"e");
            Object object = languageExtensionPoint.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.instance");
            LearningCourse learningCourse = (LearningCourse)object;
            PluginDescriptor pluginDescriptor = e.getPluginDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"e.pluginDescriptor");
            this.languageCourses.putValues((Object)langSupport2, this.createModules(learningCourse, pluginDescriptor));
        }
    }

    private final void reloadCommonModules() {
        KeyedLazyInstanceEP[] commonCoursesExtensions;
        for (KeyedLazyInstanceEP e : commonCoursesExtensions = (KeyedLazyInstanceEP[])COMMON_COURSE_MODULES_EP.getExtensions()) {
            if (!this.commonCourses.get((Object)e.key).isEmpty()) continue;
            String string = e.key;
            KeyedLazyInstanceEP keyedLazyInstanceEP = e;
            Intrinsics.checkNotNullExpressionValue((Object)keyedLazyInstanceEP, (String)"e");
            Object object = keyedLazyInstanceEP.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.instance");
            LearningCourse learningCourse = (LearningCourse)object;
            PluginDescriptor pluginDescriptor = e.getPluginDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"e.pluginDescriptor");
            this.commonCourses.put((Object)string, this.createModules(learningCourse, pluginDescriptor));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<ModuleInfo> createModules(LearningCourse course, PluginDescriptor pluginDescriptor) {
        void $this$mapTo$iv$iv;
        boolean isExternal = !PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)pluginDescriptor).isDevelopedByJetBrains();
        Iterable $this$map$iv = course.modules();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IftModule iftModule = (IftModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ModuleInfo moduleInfo = new ModuleInfo((IftModule)it, isExternal);
            collection.add(moduleInfo);
        }
        return (List)destination$iv$iv;
    }

    private final void prepareLangModules() {
        if (this.currentConfiguration != UtilsKt.getSwitchOnExperimentalLessons()) {
            this.languageCourses.clear();
            this.currentConfiguration = UtilsKt.getSwitchOnExperimentalLessons();
        }
        if (this.languageCourses.isEmpty()) {
            this.reloadLangModules();
        }
    }

    public CourseManager() {
        Object v0;
        String strBuild = PropertiesComponent.getInstance().getValue("ift.learning.panel.opened.in");
        if (strBuild == null) {
            v0 = null;
        } else {
            Iterator iterator;
            BuildNumber parseVersion = BuildNumber.fromString((String)strBuild);
            if (parseVersion == null) {
                CourseManager $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(CourseManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.error("Cannot parse previous version " + strBuild);
            }
            v0 = iterator;
        }
        this.previousOpenedVersion = v0;
        Map map = ContainerUtil.createWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"ContainerUtil.createWeakMap()");
        this.mapModuleVirtualFile = map;
        this.unfoldModuleOnInit$delegate = new WeakReferenceDelegator(null, 1, null);
        MultiMap multiMap = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"MultiMap.create()");
        this.languageCourses = multiMap;
        MultiMap multiMap2 = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap2, (String)"MultiMap.create()");
        this.commonCourses = multiMap2;
        this.currentConfiguration = UtilsKt.getSwitchOnExperimentalLessons();
        for (ExtensionPointName ep : CollectionsKt.listOf((Object[])new ExtensionPointName[]{COMMON_COURSE_MODULES_EP, COURSE_MODULES_EP})) {
            ep.addChangeListener(new Runnable(){

                @Override
                public final void run() {
                    this.clearModules();
                    for (LearnToolWindow toolWindow : UtilsKt.getAllLearnToolWindows()) {
                        toolWindow.reinitViews$intellij_featuresTrainer();
                    }
                }
            }, (Disposable)this);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Ltraining/learn/CourseManager$ModuleInfo;", "", "module", "Ltraining/learn/course/IftModule;", "isExternal", "", "(Ltraining/learn/course/IftModule;Z)V", "()Z", "getModule", "()Ltraining/learn/course/IftModule;", "intellij.featuresTrainer"})
    private static final class ModuleInfo {
        @NotNull
        private final IftModule module;
        private final boolean isExternal;

        @NotNull
        public final IftModule getModule() {
            return this.module;
        }

        public final boolean isExternal() {
            return this.isExternal;
        }

        public ModuleInfo(@NotNull IftModule module, boolean isExternal) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            this.module = module;
            this.isExternal = isExternal;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Ltraining/learn/CourseManager$Companion;", "", "()V", "COMMON_COURSE_MODULES_EP", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/util/KeyedLazyInstanceEP;", "Ltraining/learn/course/LearningCourse;", "getCOMMON_COURSE_MODULES_EP", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "COURSE_MODULES_EP", "Lcom/intellij/lang/LanguageExtensionPoint;", "Ltraining/learn/course/LearningCourseBase;", "getCOURSE_MODULES_EP", "instance", "Ltraining/learn/CourseManager;", "getInstance", "()Ltraining/learn/CourseManager;", "intellij.featuresTrainer"})
    public static final class Companion {
        @NotNull
        public final CourseManager getInstance() {
            Object object = ApplicationManager.getApplication().getService(CourseManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026ourseManager::class.java)");
            return (CourseManager)object;
        }

        @NotNull
        public final ExtensionPointName<LanguageExtensionPoint<LearningCourseBase>> getCOURSE_MODULES_EP() {
            return COURSE_MODULES_EP;
        }

        @NotNull
        public final ExtensionPointName<KeyedLazyInstanceEP<LearningCourse>> getCOMMON_COURSE_MODULES_EP() {
            return COMMON_COURSE_MODULES_EP;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

