/*
 * Decompiled with CFR 0.152.
 */
package training.project;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.RecentProjectListActionProvider;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.impl.TrustedPaths;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.learn.LearnBundle;
import training.project.FileUtils;
import training.project.ProjectUtils;
import training.project.ProjectUtils$importOrOpenProject$;
import training.util.UtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\nH\u0002J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\nH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u0013J;\u0010#\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010$\u001a\u0004\u0018\u00010\u00132!\u0010%\u001a\u001d\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b()\u0012\u0004\u0012\u00020\u00110&J\u0010\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\nH\u0002J\u0010\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\nH\u0002J\u000e\u0010.\u001a\u00020/2\u0006\u0010\u000e\u001a\u00020\u000fJC\u00100\u001a\u00020\u00112\u0006\u00101\u001a\u00020\n2\u0006\u00102\u001a\u0002032\u0006\u0010\u000e\u001a\u00020\u000f2!\u0010%\u001a\u001d\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b()\u0012\u0004\u0012\u00020\u00110&H\u0002J\u0016\u00104\u001a\u00020\u00112\u0006\u00105\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013JA\u00106\u001a\u00020\u00112\u0006\u00101\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00102\u001a\u0002032!\u0010%\u001a\u001d\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b()\u0012\u0004\u0012\u00020\u00110&J\u0010\u00107\u001a\u00020\u00112\u0006\u00108\u001a\u00020\u0013H\u0002J\u0018\u0010-\u001a\n 9*\u0004\u0018\u00010\n0\n2\u0006\u0010:\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006;"}, d2={"Ltraining/project/ProjectUtils;", "", "()V", "FEATURE_TRAINER_VERSION", "", "LEARNING_PROJECT_MODIFICATION", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "learningProjectsPath", "Ljava/nio/file/Path;", "getLearningProjectsPath", "()Ljava/nio/file/Path;", "chooseParentDirectoryForLearningProject", "langSupport", "Ltraining/lang/LangSupport;", "closeAllEditorsInProject", "", "project", "Lcom/intellij/openapi/project/Project;", "copyLearnProjectIcon", "projectDir", "Ljava/io/File;", "copyLearningProjectFiles", "newContentDirectory", "createProjectDirectory", "", "place", "createSdkDownloadingNotification", "Lcom/intellij/notification/Notification;", "createVersionFile", "newProjectDirectory", "getLearningInstallationContentRoot", "getProjectRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "importOrOpenProject", "projectToClose", "postInitCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "learnProject", "isEmptyDir", "path", "isSameVersion", "versionFile", "learningProjectUrl", "Ljava/net/URL;", "openOrImportLearningProject", "contentRoot", "openProjectTask", "Lcom/intellij/ide/impl/OpenProjectTask;", "restoreProject", "languageSupport", "simpleInstallAndOpenLearningProject", "updateLearningModificationTimestamp", "it", "kotlin.jvm.PlatformType", "dest", "intellij.featuresTrainer"})
public final class ProjectUtils {
    private static final String LEARNING_PROJECT_MODIFICATION = "LEARNING_PROJECT_MODIFICATION";
    private static final String FEATURE_TRAINER_VERSION = "feature-trainer-version.txt";
    private static final Logger LOG;
    @NotNull
    public static final ProjectUtils INSTANCE;

    @NotNull
    public final Path getLearningProjectsPath() {
        Path path = Paths.get(PathManager.getSystemPath(), "demo");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(PathManager.getSystemPath(), \"demo\")");
        return path;
    }

    public final void importOrOpenProject(@NotNull LangSupport langSupport2, @Nullable Project projectToClose, @NotNull Function1<? super Project, Unit> postInitCallback) {
        Intrinsics.checkNotNullParameter((Object)langSupport2, (String)"langSupport");
        Intrinsics.checkNotNullParameter(postInitCallback, (String)"postInitCallback");
        String title$iv = LearnBundle.INSTANCE.message("learn.project.initializing.process", new Object[0]);
        boolean cancellable$iv = true;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(projectToClose, title$iv, cancellable$iv, projectToClose, title$iv, cancellable$iv, langSupport2, projectToClose, postInitCallback){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ boolean $cancellable;
            final /* synthetic */ LangSupport $langSupport$inlined;
            final /* synthetic */ Project $projectToClose$inlined;
            final /* synthetic */ Function1 $postInitCallback$inlined;
            {
                this.$project = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                this.$cancellable = $captured_local_variable$3;
                this.$langSupport$inlined = langSupport2;
                this.$projectToClose$inlined = project;
                this.$postInitCallback$inlined = function1;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator it = indicator;
                boolean bl = false;
                Path path = ProjectUtils.access$getLearningInstallationContentRoot(ProjectUtils.INSTANCE, this.$langSupport$inlined);
                if (path == null) {
                } else {
                    Path dest = path;
                    Path path2 = ProjectUtils.access$versionFile(ProjectUtils.INSTANCE, dest);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"versionFile(dest)");
                    if (!ProjectUtils.access$isSameVersion(ProjectUtils.INSTANCE, path2)) {
                        if (PathKt.exists((Path)dest)) {
                            PathKt.delete$default((Path)dest, (boolean)false, (int)1, null);
                        }
                        this.$langSupport$inlined.installAndOpenLearningProject(dest, this.$projectToClose$inlined, (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>(this){
                            final /* synthetic */ importOrOpenProject$$inlined$runBackgroundableTask$1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final void invoke(@NotNull Project it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                String string = it.getBasePath();
                                if (string != null) {
                                    String string2 = string;
                                    boolean bl = false;
                                    boolean bl2 = false;
                                    String path = string2;
                                    boolean bl3 = false;
                                    ProjectUtils.access$copyLearnProjectIcon(ProjectUtils.INSTANCE, new File(path));
                                }
                                this.this$0.$postInitCallback$inlined.invoke((Object)it);
                            }
                        }));
                    } else {
                        String path3 = ((Object)this.$langSupport$inlined.getLearningProjectPath(dest).toAbsolutePath()).toString();
                        LangManager.Companion.getInstance().setLearningProjectPath(this.$langSupport$inlined, path3);
                        ProjectUtils.access$openOrImportLearningProject(ProjectUtils.INSTANCE, dest, new OpenProjectTask(false, this.$projectToClose$inlined, false, false, null, null, false, null, null, 0, 0, false, false, false, null, false, false, null, null, null, 1048573, null), this.$langSupport$inlined, this.$postInitCallback$inlined);
                    }
                }
            }
        });
    }

    private final Path getLearningInstallationContentRoot(LangSupport langSupport2) {
        Path path;
        Path path2;
        String storedProjectPath = LangManager.Companion.getInstance().getLearningProjectPath(langSupport2);
        if (storedProjectPath != null) {
            Path path3 = Paths.get(storedProjectPath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"Paths.get(storedProjectPath)");
            path2 = langSupport2.getContentRootPath(path3);
        } else {
            path2 = null;
        }
        Path path4 = path2;
        Path canonicalPlace = this.getLearningProjectsPath().resolve(langSupport2.getContentRootDirectoryName());
        boolean useCanonical = true;
        if (path4 != null && Intrinsics.areEqual((Object)path4, (Object)canonicalPlace) ^ true && PathKt.isDirectory((Path)path4)) {
            Path path5 = this.versionFile(path4);
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"versionFile(path)");
            if (PathKt.exists((Path)path5)) {
                Path path6 = canonicalPlace;
                Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"canonicalPlace");
                if (this.createProjectDirectory(path6)) {
                    RecentProjectListActionProvider rpProvider = RecentProjectListActionProvider.Companion.getInstance();
                    List projectActions = RecentProjectListActionProvider.getActions$default((RecentProjectListActionProvider)rpProvider, (boolean)false, (boolean)false, (int)3, null);
                    for (AnAction action2 : projectActions) {
                        AnAction anAction = action2;
                        if (!(anAction instanceof ReopenProjectAction)) {
                            anAction = null;
                        }
                        ReopenProjectAction reopenProjectAction = (ReopenProjectAction)anAction;
                        String projectPath = reopenProjectAction != null ? reopenProjectAction.getProjectPath() : null;
                        if (projectPath == null || !Intrinsics.areEqual((Object)Paths.get(projectPath, new String[0]), (Object)path4)) continue;
                        RecentProjectsManager.getInstance().removePath(projectPath);
                    }
                    PathKt.delete((Path)path4, (boolean)true);
                } else {
                    useCanonical = false;
                }
            }
        }
        if (useCanonical) {
            Path path7 = canonicalPlace;
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"canonicalPlace");
            if (this.createProjectDirectory(path7)) {
                path = canonicalPlace;
            } else {
                path = (Path)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Path>(langSupport2){
                    final /* synthetic */ LangSupport $langSupport;

                    @Nullable
                    public final Path invoke() {
                        return ProjectUtils.access$chooseParentDirectoryForLearningProject(ProjectUtils.INSTANCE, this.$langSupport);
                    }
                    {
                        this.$langSupport = langSupport2;
                        super(0);
                    }
                }), (int)1, null);
                if (path == null) {
                    return null;
                }
            }
        } else {
            Path path8 = path4;
            path = path8;
            Intrinsics.checkNotNull((Object)path8);
        }
        return path;
    }

    private final boolean createProjectDirectory(Path place) {
        if (PathKt.isDirectory((Path)place)) {
            return true;
        }
        try {
            PathKt.createDirectories((Path)place);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @NotNull
    public final VirtualFile getProjectRoot(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        Object[] roots = projectRootManager.getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)roots, (String)"roots");
        Object object = roots;
        boolean bl = false;
        Object[] objectArray = object;
        boolean bl2 = false;
        if (!(objectArray.length == 0)) {
            if (roots.length > 1) {
                LOG.warn("Multiple content roots in project " + project.getName() + ": " + ArraysKt.toList((Object[])roots));
            }
            VirtualFile virtualFile = roots[0];
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"roots[0]");
            return virtualFile;
        }
        LOG.error("Not found content roots in project " + project.getName() + ". " + "Base path: " + project.getBasePath() + ", project file path: " + project.getProjectFilePath());
        object = "Not found content roots for project";
        bl = false;
        throw (Throwable)new IllegalStateException(object.toString());
    }

    public final void simpleInstallAndOpenLearningProject(@NotNull Path contentRoot, @NotNull LangSupport langSupport2, @NotNull OpenProjectTask openProjectTask, @NotNull Function1<? super Project, Unit> postInitCallback) {
        Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
        Intrinsics.checkNotNullParameter((Object)langSupport2, (String)"langSupport");
        Intrinsics.checkNotNullParameter((Object)openProjectTask, (String)"openProjectTask");
        Intrinsics.checkNotNullParameter(postInitCallback, (String)"postInitCallback");
        Path actualContentRoot = this.copyLearningProjectFiles(contentRoot, langSupport2);
        if (actualContentRoot == null) {
            return;
        }
        this.createVersionFile(actualContentRoot);
        this.openOrImportLearningProject(actualContentRoot, openProjectTask, langSupport2, (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>(postInitCallback){
            final /* synthetic */ Function1 $postInitCallback;

            public final void invoke(@NotNull Project it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ProjectUtils.access$updateLearningModificationTimestamp(ProjectUtils.INSTANCE, it);
                this.$postInitCallback.invoke((Object)it);
            }
            {
                this.$postInitCallback = function1;
                super(1);
            }
        }));
    }

    private final void updateLearningModificationTimestamp(Project it) {
        PropertiesComponent.getInstance((Project)it).setValue(LEARNING_PROJECT_MODIFICATION, String.valueOf(System.currentTimeMillis()));
    }

    private final void openOrImportLearningProject(Path contentRoot, OpenProjectTask openProjectTask, LangSupport langSupport2, Function1<? super Project, Unit> postInitCallback) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(langSupport2.getLearningProjectPath(contentRoot));
        if (virtualFile == null) {
            String string = "Copied Learn project folder is null";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026 project folder is null\")");
        VirtualFile projectDirectoryVirtualFile = virtualFile;
        OpenProjectTask task2 = OpenProjectTask.copy$default((OpenProjectTask)openProjectTask, (boolean)false, null, (boolean)false, (boolean)false, null, null, (boolean)false, null, null, (int)0, (int)0, (boolean)false, (boolean)false, (boolean)false, null, (boolean)false, (boolean)false, (Function1)openOrImportLearningProject.task.1.INSTANCE, null, null, null, (int)0x1DFFFF, null);
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        Application application = ApplicationManager.getApplication();
        Runnable runnable = new Runnable(projectDirectoryVirtualFile, task2, langSupport2, postInitCallback){
            final /* synthetic */ VirtualFile $projectDirectoryVirtualFile$inlined;
            final /* synthetic */ OpenProjectTask $task$inlined;
            final /* synthetic */ LangSupport $langSupport$inlined;
            final /* synthetic */ Function1 $postInitCallback$inlined;
            {
                this.$projectDirectoryVirtualFile$inlined = virtualFile;
                this.$task$inlined = openProjectTask;
                this.$langSupport$inlined = langSupport2;
                this.$postInitCallback$inlined = function1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                Project project;
                boolean bl = false;
                Path path = this.$projectDirectoryVirtualFile$inlined.toNioPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"projectDirectoryVirtualFile.toNioPath()");
                Path nioPath = path;
                GeneralSettings generalSettings = GeneralSettings.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)generalSettings, (String)"GeneralSettings.getInstance()");
                int confirmOpenNewProject = generalSettings.getConfirmOpenNewProject();
                if (confirmOpenNewProject == 2) {
                    GeneralSettings generalSettings2 = GeneralSettings.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)generalSettings2, (String)"GeneralSettings.getInstance()");
                    generalSettings2.setConfirmOpenNewProject(1);
                }
                try {
                    Project project2 = ProjectUtil.openOrImport((Path)nioPath, (OpenProjectTask)this.$task$inlined);
                    if (project2 == null) {
                        String string = "Cannot create project for " + this.$langSupport$inlined.getPrimaryLanguage() + " at " + nioPath;
                        boolean bl2 = false;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    project = project2;
                }
                finally {
                    if (confirmOpenNewProject == 2) {
                        GeneralSettings generalSettings3 = GeneralSettings.getInstance();
                        Intrinsics.checkNotNullExpressionValue((Object)generalSettings3, (String)"GeneralSettings.getInstance()");
                        generalSettings3.setConfirmOpenNewProject(confirmOpenNewProject);
                    }
                }
                Project project3 = project;
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"try {\n        ProjectUti\u2026Project\n        }\n      }");
                Project project4 = project3;
                this.$postInitCallback$inlined.invoke((Object)project4);
            }
        };
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
        application.invokeLater(runnable, modalityState);
    }

    private final Path copyLearningProjectFiles(Path newContentDirectory, LangSupport langSupport2) {
        Path targetDirectory = newContentDirectory;
        File file = targetDirectory.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"targetDirectory.toFile()");
        if (!LangSupport.DefaultImpls.copyLearningProjectFiles$default(langSupport2, file, null, 2, null)) {
            Path path = (Path)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Path>(langSupport2){
                final /* synthetic */ LangSupport $langSupport;

                @Nullable
                public final Path invoke() {
                    return ProjectUtils.access$chooseParentDirectoryForLearningProject(ProjectUtils.INSTANCE, this.$langSupport);
                }
                {
                    this.$langSupport = langSupport2;
                    super(0);
                }
            }), (int)1, null);
            if (path == null) {
                return null;
            }
            targetDirectory = path;
            File file2 = targetDirectory.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"targetDirectory.toFile()");
            if (!LangSupport.DefaultImpls.copyLearningProjectFiles$default(langSupport2, file2, null, 2, null)) {
                Object modalityState$iv = null;
                boolean $i$f$invokeLater = false;
                Application application = ApplicationManager.getApplication();
                Runnable runnable = new Runnable(){

                    public final void run() {
                        boolean bl = false;
                        Messages.showInfoMessage((String)LearnBundle.INSTANCE.message("learn.project.initializing.cannot.create.message", new Object[0]), (String)LearnBundle.INSTANCE.message("learn.project.initializing.cannot.create.title", new Object[0]));
                    }
                };
                ModalityState modalityState = ModalityState.defaultModalityState();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                application.invokeLater(runnable, modalityState);
                modalityState$iv = "Cannot create learning demo project. See LOG files for details.";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(modalityState$iv.toString());
            }
        }
        Path path = langSupport2.getLearningProjectPath(targetDirectory);
        LangManager.Companion.getInstance().setLearningProjectPath(langSupport2, ((Object)path.toAbsolutePath()).toString());
        TrustedPaths.Companion.getInstance().setProjectPathTrusted(path, true);
        return targetDirectory;
    }

    @NotNull
    public final URL learningProjectUrl(@NotNull LangSupport langSupport2) {
        Intrinsics.checkNotNullParameter((Object)langSupport2, (String)"langSupport");
        URL uRL = langSupport2.getClass().getClassLoader().getResource(langSupport2.getProjectResourcePath());
        if (uRL == null) {
            throw (Throwable)new IllegalArgumentException("No project " + langSupport2.getProjectResourcePath() + " in resources " + "for " + langSupport2.getPrimaryLanguage() + " IDE learning course");
        }
        return uRL;
    }

    /*
     * WARNING - void declaration
     */
    private final Path chooseParentDirectoryForLearningProject(LangSupport langSupport2) {
        void result2;
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false).withTitle(LearnBundle.INSTANCE.message("learn.project.initializing.choose.place", langSupport2.getContentRootDirectoryName()));
        FileChooserDialogImpl dialog2 = new FileChooserDialogImpl(descriptor, null);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        dialog2.choose(VfsUtil.getUserHomeDir(), new Consumer((Ref.ObjectRef)result2){
            final /* synthetic */ Ref.ObjectRef $result;

            public final void consume(List<VirtualFile> it) {
                this.$result.element = it;
            }
            {
                this.$result = objectRef;
            }
        });
        List list2 = (List)result2.element;
        if (list2 == null) {
            return null;
        }
        List directories = list2;
        if (directories.isEmpty()) {
            String string = "No directory selected for the project";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        VirtualFile chosen = (VirtualFile)CollectionsKt.single((List)directories);
        String string = chosen.getCanonicalPath();
        if (string == null) {
            String string2 = "No canonical path for " + chosen;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"chosen.canonicalPath ?: \u2026onical path for $chosen\")");
        String canonicalPath = string;
        return new File(canonicalPath, langSupport2.getContentRootDirectoryName()).toPath();
    }

    private final void copyLearnProjectIcon(File projectDir) {
        String iconPath = "learnProjects/.idea";
        URL uRL = ProjectUtils.class.getClassLoader().getResource(iconPath);
        if (uRL == null) {
            throw (Throwable)new IllegalArgumentException("Unable to locate icon for learn project by path: " + iconPath);
        }
        URL iconUrl = uRL;
        File ideaDir = new File(projectDir, ".idea");
        FileUtil.ensureExists((File)ideaDir);
        FileUtils.copyResourcesRecursively$default(FileUtils.INSTANCE, iconUrl, ideaDir, null, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createVersionFile(Path newProjectDirectory) {
        Closeable closeable = new PrintWriter(newProjectDirectory.resolve(FEATURE_TRAINER_VERSION).toFile(), "UTF-8");
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            PrintWriter it = (PrintWriter)closeable;
            boolean bl3 = false;
            it.println(UtilsKt.getFeatureTrainerVersion());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final boolean isSameVersion(Path versionFile) {
        Optional<String> res;
        if (!PathKt.exists((Path)versionFile)) {
            return false;
        }
        Optional<String> optional = res = Files.lines(versionFile).findFirst();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"res");
        if (optional.isPresent()) {
            return Intrinsics.areEqual((Object)UtilsKt.getFeatureTrainerVersion(), (Object)res.get());
        }
        return false;
    }

    private final Path versionFile(Path dest) {
        return dest.resolve(FEATURE_TRAINER_VERSION);
    }

    @NotNull
    public final Notification createSdkDownloadingNotification() {
        NotificationGroup notificationGroup = UtilsKt.getIftNotificationGroup();
        String string = LearnBundle.INSTANCE.message("learn.project.initializing.jdk.download.notification.title", new Object[0]);
        Object[] objectArray = new Object[1];
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        String string2 = applicationNamesInfo.getFullProductName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ApplicationNamesInfo.getInstance().fullProductName");
        objectArray[0] = string2;
        return notificationGroup.createNotification(string, LearnBundle.INSTANCE.message("learn.project.initializing.jdk.download.notification.message", objectArray), NotificationType.INFORMATION);
    }

    public final void closeAllEditorsInProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FileEditorManagerEx fileEditorManagerEx = FileEditorManagerEx.getInstanceEx((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorManagerEx, (String)"FileEditorManagerEx.getInstanceEx(project)");
        EditorWindow[] editorWindowArray = fileEditorManagerEx.getWindows();
        Intrinsics.checkNotNullExpressionValue((Object)editorWindowArray, (String)"FileEditorManagerEx.getInstanceEx(project).windows");
        EditorWindow[] $this$forEach$iv = editorWindowArray;
        boolean $i$f$forEach = false;
        EditorWindow[] editorWindowArray2 = $this$forEach$iv;
        int n = editorWindowArray2.length;
        for (int j = 0; j < n; ++j) {
            VirtualFile[] $this$forEach$iv2;
            EditorWindow element$iv;
            EditorWindow it = element$iv = editorWindowArray2[j];
            boolean bl = false;
            EditorWindow editorWindow = it;
            Intrinsics.checkNotNullExpressionValue((Object)editorWindow, (String)"it");
            Intrinsics.checkNotNullExpressionValue((Object)editorWindow.getFiles(), (String)"it.files");
            boolean $i$f$forEach2 = false;
            VirtualFile[] virtualFileArray = $this$forEach$iv2;
            int n2 = virtualFileArray.length;
            for (int k = 0; k < n2; ++k) {
                VirtualFile element$iv2;
                VirtualFile file = element$iv2 = virtualFileArray[k];
                boolean bl2 = false;
                it.closeFile(file);
            }
        }
    }

    public final void restoreProject(@NotNull LangSupport languageSupport, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)languageSupport, (String)"languageSupport");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CompletableFuture done = new CompletableFuture();
        AppUIExecutor.onWriteThread().withDocumentsCommitted(project).submit(new Runnable(project, languageSupport, done){
            final /* synthetic */ Project $project;
            final /* synthetic */ LangSupport $languageSupport;
            final /* synthetic */ CompletableFuture $done;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                try {
                    void modified;
                    File contentRoodDirectory;
                    Path path;
                    long l;
                    boolean bl;
                    String string = PropertiesComponent.getInstance((Project)this.$project).getValue("LEARNING_PROJECT_MODIFICATION");
                    if (string != null) {
                        String string2 = string;
                        bl = false;
                        l = Long.parseLong(string2);
                    } else {
                        l = 0L;
                    }
                    long stamp = l;
                    bl = false;
                    List needReplace = new ArrayList<E>();
                    boolean bl2 = false;
                    List validContent = new ArrayList<E>();
                    boolean bl3 = false;
                    List directories = new ArrayList<E>();
                    VirtualFile root = ProjectUtils.INSTANCE.getProjectRoot(this.$project);
                    Path path2 = root.toNioPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"root.toNioPath()");
                    Path contentRootPath = this.$languageSupport.getContentRootPath(path2);
                    Iterator<T> iterator = Files.walk(contentRootPath, new FileVisitOption[0]).iterator();
                    while (iterator.hasNext()) {
                        boolean bl4;
                        Object $this$any$iv;
                        block13: {
                            path = (Path)iterator.next();
                            Path path3 = contentRootPath.relativize(path);
                            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"contentRootPath.relativize(path)");
                            $this$any$iv = path3;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl4 = false;
                            } else {
                                Iterator<T> iterator2 = $this$any$iv.iterator();
                                while (iterator2.hasNext()) {
                                    T element$iv = iterator2.next();
                                    Path file = (Path)element$iv;
                                    boolean bl5 = false;
                                    Path path4 = file;
                                    Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"file");
                                    if (!(Intrinsics.areEqual((Object)PathsKt.getName((Path)path4), (Object)".idea") || Intrinsics.areEqual((Object)PathsKt.getName((Path)file), (Object)"git") || Intrinsics.areEqual((Object)PathsKt.getName((Path)file), (Object)".git") || Intrinsics.areEqual((Object)PathsKt.getName((Path)file), (Object)".gitignore") || Intrinsics.areEqual((Object)PathsKt.getName((Path)file), (Object)"venv") || Intrinsics.areEqual((Object)PathsKt.getName((Path)file), (Object)"feature-trainer-version.txt") || StringsKt.endsWith$default((String)PathsKt.getName((Path)file), (String)".iml", (boolean)false, (int)2, null))) continue;
                                    bl4 = true;
                                    break block13;
                                }
                                bl4 = false;
                            }
                        }
                        if (bl4) continue;
                        Path path5 = path;
                        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"path");
                        if (PathKt.isDirectory((Path)path5)) {
                            directories.add(path);
                            continue;
                        }
                        $this$any$iv = path;
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        boolean bl6 = false;
                        FileTime fileTime = Files.getLastModifiedTime((Path)$this$any$iv, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"Files.getLastModifiedTime(this, *options)");
                        if (fileTime.toMillis() > stamp) {
                            needReplace.add(path);
                            continue;
                        }
                        validContent.add(path);
                    }
                    path = new Ref.BooleanRef();
                    ((Ref.BooleanRef)path).element = false;
                    for (Path path6 : needReplace) {
                        PathKt.delete$default((Path)path6, (boolean)false, (int)1, null);
                        modified.element = true;
                    }
                    File file = contentRoodDirectory = contentRootPath.toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"contentRoodDirectory");
                    this.$languageSupport.copyLearningProjectFiles(file, new FileFilter(needReplace, validContent, (Ref.BooleanRef)modified){
                        final /* synthetic */ List $needReplace;
                        final /* synthetic */ List $validContent;
                        final /* synthetic */ Ref.BooleanRef $modified;

                        /*
                         * WARNING - void declaration
                         */
                        public final boolean accept(File it) {
                            void var3_3;
                            Path path = it.toPath();
                            boolean needCopy = this.$needReplace.contains(path) || !this.$validContent.contains(path);
                            this.$modified.element = needCopy || this.$modified.element;
                            return (boolean)var3_3;
                        }
                        {
                            this.$needReplace = list2;
                            this.$validContent = list3;
                            this.$modified = booleanRef;
                        }
                    });
                    for (Path path7 : directories) {
                        if (!ProjectUtils.access$isEmptyDir(ProjectUtils.INSTANCE, path7)) continue;
                        modified.element = true;
                        PathKt.delete$default((Path)path7, (boolean)false, (int)1, null);
                    }
                    if (modified.element) {
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{root});
                        PropertiesComponent.getInstance((Project)this.$project).setValue("LEARNING_PROJECT_MODIFICATION", String.valueOf(System.currentTimeMillis()));
                    }
                    this.$done.complete(true);
                }
                catch (Exception e) {
                    this.$done.complete(false);
                    throw (Throwable)e;
                }
            }
            {
                this.$project = project;
                this.$languageSupport = langSupport2;
                this.$done = completableFuture;
            }
        });
        Boolean success = (Boolean)done.get();
        if (!success.booleanValue()) {
            ProjectUtils $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ProjectUtils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.error("IFT Learning project files refresh failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isEmptyDir(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            Closeable closeable = Files.newDirectoryStream(path);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                DirectoryStream directory = (DirectoryStream)closeable;
                boolean bl3 = false;
                boolean bl4 = !directory.iterator().hasNext();
                return bl4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return false;
    }

    private ProjectUtils() {
    }

    static {
        ProjectUtils projectUtils;
        INSTANCE = projectUtils = new ProjectUtils();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProjectUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Path access$getLearningInstallationContentRoot(ProjectUtils $this, LangSupport langSupport2) {
        return $this.getLearningInstallationContentRoot(langSupport2);
    }

    public static final /* synthetic */ boolean access$isSameVersion(ProjectUtils $this, Path versionFile) {
        return $this.isSameVersion(versionFile);
    }

    public static final /* synthetic */ Path access$versionFile(ProjectUtils $this, Path dest) {
        return $this.versionFile(dest);
    }

    public static final /* synthetic */ void access$copyLearnProjectIcon(ProjectUtils $this, File projectDir) {
        $this.copyLearnProjectIcon(projectDir);
    }

    public static final /* synthetic */ void access$openOrImportLearningProject(ProjectUtils $this, Path contentRoot, OpenProjectTask openProjectTask, LangSupport langSupport2, Function1 postInitCallback) {
        $this.openOrImportLearningProject(contentRoot, openProjectTask, langSupport2, (Function1<? super Project, Unit>)postInitCallback);
    }

    public static final /* synthetic */ Path access$chooseParentDirectoryForLearningProject(ProjectUtils $this, LangSupport langSupport2) {
        return $this.chooseParentDirectoryForLearningProject(langSupport2);
    }

    public static final /* synthetic */ void access$updateLearningModificationTimestamp(ProjectUtils $this, Project it) {
        $this.updateLearningModificationTimestamp(it);
    }

    public static final /* synthetic */ boolean access$isEmptyDir(ProjectUtils $this, Path path) {
        return $this.isEmptyDir(path);
    }
}

