/*
 * Decompiled with CFR 0.152.
 */
package training.statistic;

import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.impl.CloseProjectWindowHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.statistic.LearnProjectState;
import training.statistic.LearnProjectStateListenerKt;
import training.statistic.StatisticBase;
import training.util.UtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Ltraining/statistic/LearnProjectStateListener;", "Lcom/intellij/openapi/project/ProjectManagerListener;", "()V", "projectClosed", "", "project", "Lcom/intellij/openapi/project/Project;", "projectClosingBeforeSave", "projectOpened", "removeFromRecentProjects", "intellij.featuresTrainer"})
final class LearnProjectStateListener
implements ProjectManagerListener {
    public void projectOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
        if (langSupport2 == null) {
            return;
        }
        LangSupport langSupport3 = langSupport2;
        if (UtilsKt.isLearningProject(project, langSupport3)) {
            CloseProjectWindowHelper.Companion.getSHOW_WELCOME_FRAME_FOR_PROJECT().set((UserDataHolder)project, (Object)true);
            this.removeFromRecentProjects(project);
        } else {
            LearnProjectState learnProjectState = LearnProjectState.Companion.getInstance$intellij_featuresTrainer();
            StatisticBase.LearnProjectOpeningWay way = learnProjectState.getFirstTimeOpenedWay();
            if (way != null) {
                StatisticBase.Companion.logNonLearningProjectOpened(way);
                learnProjectState.setFirstTimeOpenedWay(null);
            }
            LearnProjectStateListenerKt.access$considerNotifyAboutNewLessons(project);
        }
    }

    public void projectClosingBeforeSave(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
        if (langSupport2 == null) {
            return;
        }
        LangSupport langSupport3 = langSupport2;
        if (UtilsKt.isLearningProject(project, langSupport3) && !StatisticBase.Companion.isLearnProjectCloseLogged()) {
            StatisticBase.Companion.logLessonStopped(StatisticBase.LessonStopReason.CLOSE_PROJECT);
        }
    }

    public void projectClosed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
        if (langSupport2 == null) {
            return;
        }
        LangSupport langSupport3 = langSupport2;
        if (UtilsKt.isLearningProject(project, langSupport3)) {
            StatisticBase.Companion.setLearnProjectCloseLogged(false);
            this.removeFromRecentProjects(project);
        }
    }

    private final void removeFromRecentProjects(Project project) {
        block0: {
            RecentProjectsManagerBase manager = RecentProjectsManagerBase.Companion.getInstanceEx();
            String string = manager.getProjectPath(project);
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            manager.removePath(it);
        }
    }
}

