/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.CharLongHashMap;
import com.carrotsearch.hppc.HashOrderMixing;

public class CharLongScatterMap
extends CharLongHashMap {
    public CharLongScatterMap() {
        this(4);
    }

    public CharLongScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public CharLongScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(char key) {
        return BitMixer.mixPhi(key);
    }

    public static CharLongScatterMap from(char[] keys, long[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharLongScatterMap map2 = new CharLongScatterMap(keys.length);
        for (int i2 = 0; i2 < keys.length; ++i2) {
            map2.put(keys[i2], values[i2]);
        }
        return map2;
    }
}

