/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.detector.utils.filter;

import com.intellij.grazie.detector.utils.filter.TextFilter;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/grazie/detector/utils/filter/EnglishCapitalizedWordsTextFilter;", "Lcom/intellij/grazie/detector/utils/filter/TextFilter;", "()V", "bigLetters", "Lkotlin/text/Regex;", "endPunctuation", "", "", "letter", "filter", "", "text", "nlp-detector"})
public final class EnglishCapitalizedWordsTextFilter
implements TextFilter {
    private static final Regex bigLetters;
    private static final Regex letter;
    private static final Set<Character> endPunctuation;
    @NotNull
    public static final EnglishCapitalizedWordsTextFilter INSTANCE;

    @Override
    @NotNull
    public CharSequence filter(@NotNull CharSequence text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        boolean isStartPhrase = true;
        boolean isStartWord = true;
        boolean skipWhileLetters = false;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        CharSequence charSequence = text2;
        for (int j = 0; j < charSequence.length(); ++j) {
            char c = charSequence.charAt(j);
            if (CharsKt.isWhitespace((char)c)) {
                skipWhileLetters = false;
                isStartWord = true;
                $this$buildString.append(c);
                continue;
            }
            if (endPunctuation.contains(Character.valueOf(c))) {
                skipWhileLetters = false;
                isStartPhrase = true;
                $this$buildString.append(c);
                continue;
            }
            if (skipWhileLetters && letter.matches((CharSequence)String.valueOf(c))) {
                isStartPhrase = false;
                isStartWord = false;
                continue;
            }
            if (!skipWhileLetters && !isStartPhrase && isStartWord && bigLetters.matches((CharSequence)String.valueOf(c))) {
                skipWhileLetters = true;
                isStartPhrase = false;
                isStartWord = false;
                continue;
            }
            $this$buildString.append(c);
            isStartPhrase = false;
            isStartWord = false;
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private EnglishCapitalizedWordsTextFilter() {
    }

    static {
        EnglishCapitalizedWordsTextFilter englishCapitalizedWordsTextFilter;
        INSTANCE = englishCapitalizedWordsTextFilter = new EnglishCapitalizedWordsTextFilter();
        bigLetters = new Regex("[A-Z]");
        letter = new Regex("[A-Za-z]");
        endPunctuation = SetsKt.setOf((Object[])new Character[]{Character.valueOf('.'), Character.valueOf('!'), Character.valueOf('?')});
    }
}

