/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.nio.ByteBuffer;
import morfologik.stemming.BufferUtils;
import morfologik.stemming.ISequenceEncoder;

public class TrimInfixAndSuffixEncoder
implements ISequenceEncoder {
    private static final int REMOVE_EVERYTHING = 255;
    private ByteBuffer scratch = ByteBuffer.allocate(0);

    @Override
    public ByteBuffer encode(ByteBuffer reuse, ByteBuffer source2, ByteBuffer target) {
        assert (source2.hasArray() && source2.position() == 0 && source2.arrayOffset() == 0);
        assert (target.hasArray() && target.position() == 0 && target.arrayOffset() == 0);
        int maxInfixIndex = 0;
        int maxSubsequenceLength = BufferUtils.sharedPrefixLength(source2, target);
        int maxInfixLength = 0;
        for (int i2 : new int[]{0, maxSubsequenceLength}) {
            for (int j = 1; j <= source2.remaining() - i2; ++j) {
                int len2 = source2.remaining() - (i2 + j);
                this.scratch = BufferUtils.clearAndEnsureCapacity(this.scratch, i2 + len2);
                this.scratch.put(source2.array(), 0, i2);
                this.scratch.put(source2.array(), i2 + j, len2);
                this.scratch.flip();
                int sharedPrefix = BufferUtils.sharedPrefixLength(this.scratch, target);
                if (sharedPrefix <= 0 || sharedPrefix <= maxSubsequenceLength || i2 >= 255 || j >= 255) continue;
                maxSubsequenceLength = sharedPrefix;
                maxInfixIndex = i2;
                maxInfixLength = j;
            }
        }
        int truncateSuffixBytes = source2.remaining() - (maxInfixLength + maxSubsequenceLength);
        if (truncateSuffixBytes == 0 && maxInfixIndex + maxInfixLength == source2.remaining()) {
            truncateSuffixBytes = maxInfixLength;
            maxInfixLength = 0;
            maxInfixIndex = 0;
        }
        if (maxInfixIndex >= 255 || maxInfixLength >= 255 || truncateSuffixBytes >= 255) {
            maxSubsequenceLength = 0;
            maxInfixIndex = 0;
            truncateSuffixBytes = 255;
            maxInfixLength = 255;
        }
        int len1 = target.remaining() - maxSubsequenceLength;
        reuse = BufferUtils.clearAndEnsureCapacity(reuse, 3 + len1);
        reuse.put((byte)(maxInfixIndex + 65 & 0xFF));
        reuse.put((byte)(maxInfixLength + 65 & 0xFF));
        reuse.put((byte)(truncateSuffixBytes + 65 & 0xFF));
        reuse.put(target.array(), maxSubsequenceLength, len1);
        reuse.flip();
        return reuse;
    }

    @Override
    public int prefixBytes() {
        return 3;
    }

    @Override
    public ByteBuffer decode(ByteBuffer reuse, ByteBuffer source2, ByteBuffer encoded) {
        assert (encoded.remaining() >= 3);
        int p2 = encoded.position();
        int infixIndex = encoded.get(p2) - 65 & 0xFF;
        int infixLength = encoded.get(p2 + 1) - 65 & 0xFF;
        int truncateSuffixBytes = encoded.get(p2 + 2) - 65 & 0xFF;
        if (infixLength == 255 || truncateSuffixBytes == 255) {
            infixIndex = 0;
            infixLength = source2.remaining();
            truncateSuffixBytes = 0;
        }
        int len1 = source2.remaining() - (infixIndex + infixLength + truncateSuffixBytes);
        int len2 = encoded.remaining() - 3;
        reuse = BufferUtils.clearAndEnsureCapacity(reuse, infixIndex + len1 + len2);
        assert (encoded.hasArray() && encoded.position() == 0 && encoded.arrayOffset() == 0);
        assert (source2.hasArray() && source2.position() == 0 && source2.arrayOffset() == 0);
        reuse.put(source2.array(), 0, infixIndex);
        reuse.put(source2.array(), infixIndex + infixLength, len1);
        reuse.put(encoded.array(), 3, len2);
        reuse.flip();
        return reuse;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

