/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public class WhitespaceBeforePunctuationRule
extends Rule {
    public WhitespaceBeforePunctuationRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(Categories.TYPOGRAPHY.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Whitespace);
    }

    @Override
    public final String getId() {
        return "WHITESPACE_PUNCTUATION";
    }

    @Override
    public final String getDescription() {
        return this.messages.getString("desc_whitespace_before_punctuation");
    }

    @Override
    public final RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokens();
        boolean prevWhite = false;
        int prevLen = 0;
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String token = tokens[i2].getToken();
            boolean isWhitespace = tokens[i2].isWhitespace() || StringTools.isNonBreakingWhitespace(token) || tokens[i2].isFieldCode();
            String msg = null;
            String suggestionText = null;
            if (prevWhite) {
                String prevPrevToken;
                if (token.equals(":")) {
                    msg = this.messages.getString("no_space_before_colon");
                    suggestionText = ":";
                    if (i2 + 2 < tokens.length && tokens[i2 + 1].isWhitespace() && Character.isDigit(tokens[i2 + 2].getToken().charAt(0))) {
                        msg = null;
                    }
                } else if (token.equals(";")) {
                    msg = this.messages.getString("no_space_before_semicolon");
                    suggestionText = ";";
                } else if (i2 > 1 && token.equals("%") && (prevPrevToken = tokens[i2 - 2].getToken()).length() > 0 && Character.isDigit(prevPrevToken.charAt(0))) {
                    msg = this.messages.getString("no_space_before_percentage");
                    suggestionText = "%";
                }
            }
            if (msg != null) {
                int fromPos = tokens[i2 - 1].getStartPos();
                int toPos = tokens[i2 - 1].getStartPos() + 1 + prevLen;
                RuleMatch ruleMatch = new RuleMatch(this, sentence, fromPos, toPos, msg);
                ruleMatch.setSuggestedReplacement(suggestionText);
                ruleMatches.add(ruleMatch);
            }
            prevWhite = isWhitespace && !tokens[i2].isFieldCode();
            prevLen = tokens[i2].getToken().length();
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

