/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.simplify;

import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;

final class ArrayAdapter<T> {
    private final T[] array;

    public static <T> ArrayAdapter<T> of(T[] array) {
        return new ArrayAdapter<T>(array);
    }

    private ArrayAdapter(T[] array) {
        this.array = array;
    }

    public void visitSequentialPairs(BiConsumer<T, T> visitor) {
        if (this.array.length < 2) {
            return;
        }
        for (int i2 = 1; i2 < this.array.length; ++i2) {
            visitor.accept(this.array[i2 - 1], this.array[i2]);
        }
    }

    public int visitSequentialPairsAndSimplify(BinaryOperator<T> visitor) {
        if (this.array.length < 2) {
            return 0;
        }
        int simplificationCount = 0;
        for (int i2 = 1; i2 < this.array.length; ++i2) {
            Object simplification;
            if (this.array[i2 - 1] == null || (simplification = visitor.apply(this.array[i2 - 1], this.array[i2])) == null) continue;
            this.array[i2 - 1] = simplification;
            this.array[i2] = null;
            ++simplificationCount;
        }
        return simplificationCount;
    }

    public T[] removeNulls(int nullCount) {
        T[] result2 = Arrays.copyOf(this.array, this.array.length - nullCount);
        int j = 0;
        for (int i2 = 0; i2 < this.array.length; ++i2) {
            if (this.array[i2] == null) continue;
            result2[j++] = this.array[i2];
        }
        return result2;
    }
}

