/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine.local.xalan;

import java.util.TooManyListenersException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.apache.xalan.trace.TraceListener;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xml.utils.DefaultErrorHandler;
import org.intellij.plugins.xsltDebugger.rt.engine.DebuggerStoppedException;
import org.intellij.plugins.xsltDebugger.rt.engine.local.LocalDebugger;
import org.intellij.plugins.xsltDebugger.rt.engine.local.xalan.XalanTraceListener;

public final class XalanSupport {
    public static boolean init(Transformer transformer, LocalDebugger dbg) {
        if (transformer instanceof TransformerImpl) {
            try {
                System.out.println("XALAN: " + Class.forName("org.apache.xalan.Version", true, transformer.getClass().getClassLoader()).getMethod("getVersion", new Class[0]).invoke(null, new Object[0]));
                TransformerImpl tr = (TransformerImpl)transformer;
                tr.setErrorListener((ErrorListener)new DefaultErrorHandler(false){

                    public void fatalError(TransformerException exception) throws TransformerException {
                        if (!(exception.getCause() instanceof DebuggerStoppedException)) {
                            super.fatalError(exception);
                        }
                    }
                });
                try {
                    tr.getTraceManager().addTraceListener((TraceListener)new XalanTraceListener(dbg, tr));
                }
                catch (TooManyListenersException e) {
                    throw new AssertionError((Object)e);
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static TransformerFactory createTransformerFactory() {
        TransformerFactoryImpl factory = new TransformerFactoryImpl();
        XalanSupport.prepareFactory((TransformerFactory)factory);
        return factory;
    }

    public static TransformerFactory prepareFactory(TransformerFactory factory) {
        try {
            factory.setAttribute("http://xml.apache.org/xalan/properties/source-location", Boolean.TRUE);
            factory.setAttribute("http://xml.apache.org/xalan/features/optimize", Boolean.FALSE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return factory;
    }

    public static String getPath(DTM dtm, int node) {
        switch (dtm.getNodeType(node)) {
            case 9: {
                return "/";
            }
            case 1: {
                String pre = XalanSupport.getPath(dtm, dtm.getParent(node));
                return (pre.equals("/") ? "" : pre) + "/" + dtm.getNodeName(node) + "[" + XalanSupport.getNumberSimple(dtm, node) + "]";
            }
            case 2: {
                return XalanSupport.getPath(dtm, dtm.getParent(node)) + "/@" + dtm.getNodeNameX(node);
            }
            case 3: {
                String pre = XalanSupport.getPath(dtm, dtm.getParent(node));
                return (pre.equals("/") ? "" : pre) + "/text()[" + XalanSupport.getNumberSimple(dtm, node) + "]";
            }
            case 8: {
                String pre = XalanSupport.getPath(dtm, dtm.getParent(node));
                return (pre.equals("/") ? "" : pre) + "/comment()[" + XalanSupport.getNumberSimple(dtm, node) + "]";
            }
            case 7: {
                String pre = XalanSupport.getPath(dtm, dtm.getParent(node));
                return (pre.equals("/") ? "" : pre) + "/processing-instruction()[" + XalanSupport.getNumberSimple(dtm, node) + "]";
            }
        }
        return "?";
    }

    private static int getNumberSimple(DTM dtm, int node) {
        String localName = dtm.getLocalName(node);
        String uri = dtm.getNamespaceURI(node);
        if (uri == null) {
            uri = "";
        }
        short type = dtm.getNodeType(node);
        int i = 1;
        int p = node;
        block3: while ((p = dtm.getPreviousSibling(p)) != -1) {
            if (dtm.getNodeType(p) != type) continue;
            switch (type) {
                case 3: 
                case 7: 
                case 8: {
                    ++i;
                    continue block3;
                }
            }
            if (!localName.equals(dtm.getLocalName(p)) || !uri.equals(dtm.getNamespaceURI(p))) continue;
            ++i;
        }
        return i;
    }
}

