/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.classFilter;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.classFilter.ClassFilterEditorAddDialog;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassFilterEditor
extends JPanel
implements ComponentWithEmptyText {
    protected JBTable myTable;
    protected FilterTableModel myTableModel;
    protected final Project myProject;
    private final com.intellij.ide.util.ClassFilter myChooserFilter;
    @Nullable
    private final String myPatternsHelpId;
    private String classDelimiter = "$";

    public ClassFilterEditor(Project project) {
        this(project, null);
    }

    public ClassFilterEditor(Project project, com.intellij.ide.util.ClassFilter classFilter) {
        this(project, classFilter, null);
    }

    public ClassFilterEditor(Project project, com.intellij.ide.util.ClassFilter classFilter, @Nullable String patternsHelpId) {
        super(new BorderLayout());
        this.myPatternsHelpId = patternsHelpId;
        this.myTable = new JBTable();
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myTable);
        if (this.addPatternButtonVisible()) {
            DefaultActionGroup addGroup = new DefaultActionGroup(new AnAction[]{new AddClassFilterAction(), new AddPatternFilterAction()});
            addGroup.getTemplatePresentation().setIcon(LayeredIcon.ADD_WITH_DROPDOWN);
            addGroup.getTemplatePresentation().setText(JavaBundle.messagePointer("button.add", new Object[0]));
            addGroup.registerCustomShortcutSet(CommonShortcuts.getNewForDialogs(), null);
            decorator.addExtraAction((AnActionButton)new AnActionButton.GroupPopupWrapper((ActionGroup)addGroup));
        } else {
            decorator.addExtraAction(AnActionButton.fromAction((AnAction)new AddClassFilterAction()));
        }
        this.add((Component)decorator.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.removeSelectedItems((JTable)ClassFilterEditor.this.myTable);
            }
        }).setButtonComparator(new String[]{this.getAddButtonText(), this.getAddPatternButtonText(), CommonBundle.message((String)"button.remove", (Object[])new Object[0])}).disableUpDownActions().createPanel(), "Center");
        this.myChooserFilter = classFilter;
        this.myProject = project;
        this.myTableModel = new FilterTableModel();
        this.myTable.setModel((TableModel)this.myTableModel);
        this.myTable.setShowGrid(false);
        this.myTable.setIntercellSpacing(new Dimension(0, 0));
        this.myTable.setAutoResizeMode(3);
        this.myTable.setColumnSelectionAllowed(false);
        this.myTable.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)200, (int)-1));
        this.myTable.setVisibleRowCount(7);
        TableColumnModel columnModel = this.myTable.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        this.myTable.setTableHeader(null);
        int preferredWidth = 0;
        TableUtil.setupCheckboxColumn((TableColumn)column, (int)preferredWidth);
        column.setCellRenderer(new EnabledCellRenderer(this.myTable.getDefaultRenderer(Boolean.class)));
        columnModel.getColumn(1).setCellRenderer(new FilterCellRenderer());
        this.getEmptyText().setText(JavaBundle.message("no.patterns", new Object[0]));
    }

    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = this.myTable.getEmptyText();
        if (statusText == null) {
            ClassFilterEditor.$$$reportNull$$$0(0);
        }
        return statusText;
    }

    @Nls
    protected String getAddButtonText() {
        return JavaBundle.message("button.add.class", new Object[0]);
    }

    @Nls
    protected String getAddPatternButtonText() {
        return JavaBundle.message("button.add.pattern", new Object[0]);
    }

    protected Icon getAddButtonIcon() {
        return AllIcons.Nodes.Class;
    }

    protected Icon getAddPatternButtonIcon() {
        return AllIcons.Actions.Regex;
    }

    protected boolean addPatternButtonVisible() {
        return true;
    }

    public void setFilters(ClassFilter[] filters) {
        this.myTableModel.setFilters(filters);
    }

    public ClassFilter[] getFilters() {
        return this.myTableModel.getFilters();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myTable.setEnabled(enabled);
        this.myTable.setRowSelectionAllowed(enabled);
        this.myTableModel.fireTableDataChanged();
    }

    public void stopEditing() {
        TableCellEditor editor = this.myTable.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    public void setupEasyFocusTraversing() {
        this.myTable.setupEasyFocusTraversing();
    }

    @NotNull
    protected ClassFilter createFilter(String pattern) {
        return new ClassFilter(pattern);
    }

    protected void addPatternFilter() {
        String pattern;
        ClassFilterEditorAddDialog dialog = new ClassFilterEditorAddDialog(this.myProject, this.myPatternsHelpId);
        if (dialog.showAndGet() && (pattern = dialog.getPattern()) != null) {
            ClassFilter filter2 = this.createFilter(pattern);
            this.myTableModel.addRow(filter2);
            int row = this.myTableModel.getRowCount() - 1;
            this.myTable.getSelectionModel().setSelectionInterval(row, row);
            this.myTable.scrollRectToVisible(this.myTable.getCellRect(row, 0, true));
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTable, true));
        }
    }

    protected void addClassFilter() {
        TreeClassChooser chooser = TreeClassChooserFactory.getInstance(this.myProject).createNoInnerClassesScopeChooser(JavaBundle.message("class.filter.editor.choose.class.title", new Object[0]), GlobalSearchScope.allScope((Project)this.myProject), this.myChooserFilter, null);
        chooser.showDialog();
        PsiClass selectedClass = chooser.getSelected();
        if (selectedClass != null) {
            ClassFilter filter2 = this.createFilter(this.getJvmClassName(selectedClass));
            this.myTableModel.addRow(filter2);
            int row = this.myTableModel.getRowCount() - 1;
            this.myTable.getSelectionModel().setSelectionInterval(row, row);
            this.myTable.scrollRectToVisible(this.myTable.getCellRect(row, 0, true));
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTable, true));
        }
    }

    @Nullable
    private String getJvmClassName(PsiClass aClass) {
        PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
        if (parentClass != null) {
            String parentName = this.getJvmClassName(parentClass);
            if (parentName == null) {
                return null;
            }
            return parentName + this.classDelimiter + aClass.getName();
        }
        return aClass.getQualifiedName();
    }

    public void setClassDelimiter(String classDelimiter) {
        this.classDelimiter = classDelimiter;
    }

    public void addPattern(String pattern) {
        ClassFilter filter2 = this.createFilter(pattern);
        this.myTableModel.addRow(filter2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/classFilter/ClassFilterEditor", "getEmptyText"));
    }

    private class EnabledCellRenderer
    extends DefaultTableCellRenderer {
        private final TableCellRenderer myDelegate;

        EnabledCellRenderer(TableCellRenderer delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = this.myDelegate.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
            component.setEnabled(ClassFilterEditor.this.isEnabled());
            return component;
        }
    }

    private class FilterCellRenderer
    extends DefaultTableCellRenderer {
        private FilterCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            Color color = UIUtil.getTableFocusCellBackground();
            UIManager.put("Table.focusCellBackground", table.getSelectionBackground());
            Component component = super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
            if (component instanceof JLabel) {
                ((JLabel)component).setBorder(noFocusBorder);
            }
            UIManager.put("Table.focusCellBackground", color);
            ClassFilter filter2 = (ClassFilter)table.getValueAt(row, 1);
            component.setEnabled(isSelected || ClassFilterEditor.this.isEnabled() && filter2.isEnabled());
            return component;
        }
    }

    protected final class FilterTableModel
    extends AbstractTableModel
    implements ItemRemovable {
        private final List<ClassFilter> myFilters = new LinkedList<ClassFilter>();
        public static final int CHECK_MARK = 0;
        public static final int FILTER = 1;
        private boolean myEditEnabled = true;

        protected FilterTableModel() {
        }

        public void setFilters(ClassFilter[] filters) {
            this.myFilters.clear();
            if (filters != null) {
                ContainerUtil.addAll(this.myFilters, (Object[])filters);
            }
            this.fireTableDataChanged();
        }

        public ClassFilter[] getFilters() {
            this.myFilters.removeIf(filter2 -> StringUtil.isEmpty((String)filter2.getPattern()));
            return this.myFilters.toArray(ClassFilter.EMPTY_ARRAY);
        }

        public ClassFilter getFilterAt(int index) {
            return this.myFilters.get(index);
        }

        public int getFilterIndex(ClassFilter filter2) {
            return this.myFilters.indexOf(filter2);
        }

        public void addRow(ClassFilter filter2) {
            this.myFilters.add(filter2);
            int row = this.myFilters.size() - 1;
            this.fireTableRowsInserted(row, row);
        }

        @Override
        public int getRowCount() {
            return this.myFilters.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        @NlsContexts.ColumnName
        public String getColumnName(int column) {
            if (column == 1) {
                return JavaBundle.message("class.filter.editor.table.model.column.name.pattern", new Object[0]);
            }
            return JavaBundle.message("class.filter.editor.table.model.column.name.isActive", new Object[0]);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ClassFilter filter2 = this.myFilters.get(rowIndex);
            if (columnIndex == 1) {
                return filter2;
            }
            if (columnIndex == 0) {
                return filter2.isEnabled();
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ClassFilter filter2 = this.myFilters.get(rowIndex);
            if (columnIndex == 1) {
                filter2.setPattern(aValue != null ? aValue.toString() : "");
            } else if (columnIndex == 0) {
                filter2.setEnabled(aValue == null || (Boolean)aValue != false);
            }
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return ClassFilterEditor.this.isEnabled() && (columnIndex != 1 || this.myEditEnabled);
        }

        public void removeRow(int idx) {
            this.myFilters.remove(idx);
            this.fireTableRowsDeleted(idx, idx);
        }

        public void setEditEnabled(boolean editEnabled) {
            this.myEditEnabled = editEnabled;
        }
    }

    private class AddPatternFilterAction
    extends DumbAwareAction {
        private AddPatternFilterAction() {
            super(ClassFilterEditor.this.getAddPatternButtonText(), null, ClassFilterEditor.this.getAddPatternButtonIcon());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddPatternFilterAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(!ClassFilterEditor.this.myProject.isDefault());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddPatternFilterAction.$$$reportNull$$$0(1);
            }
            ClassFilterEditor.this.addPatternFilter();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ui/classFilter/ClassFilterEditor$AddPatternFilterAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class AddClassFilterAction
    extends DumbAwareAction {
        private AddClassFilterAction() {
            super(ClassFilterEditor.this.getAddButtonText(), null, ClassFilterEditor.this.getAddButtonIcon());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddClassFilterAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(!ClassFilterEditor.this.myProject.isDefault());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddClassFilterAction.$$$reportNull$$$0(1);
            }
            ClassFilterEditor.this.addClassFilter();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ui/classFilter/ClassFilterEditor$AddClassFilterAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

