/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.execution.junit.TestInClassConfigurationProducer;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.junit.TestUniqueId;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class UniqueIdConfigurationProducer
extends JUnitConfigurationProducer {
    protected boolean setupConfigurationFromContext(@NotNull JUnitConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        String[] nodeIds;
        if (configuration == null) {
            UniqueIdConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            UniqueIdConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (sourceElement == null) {
            UniqueIdConfigurationProducer.$$$reportNull$$$0(2);
        }
        if ((nodeIds = UniqueIdConfigurationProducer.getNodeIds(context)) == null || nodeIds.length == 0) {
            return false;
        }
        JUnitConfiguration.Data data = configuration.getPersistentData();
        data.setUniqueIds(nodeIds);
        data.TEST_OBJECT = "uniqueId";
        AbstractTestProxy selectedProxy = (AbstractTestProxy)context.getDataContext().getData(AbstractTestProxy.DATA_KEY);
        if (selectedProxy != null) {
            configuration.setName(selectedProxy.getName());
        } else {
            configuration.setGeneratedName();
        }
        this.setupConfigurationModule(context, (ModuleBasedConfiguration)configuration);
        return true;
    }

    public static String[] getNodeIds(ConfigurationContext context) {
        GlobalSearchScope searchScope;
        DataContext dataContext = context.getDataContext();
        AbstractTestProxy[] testProxies = (AbstractTestProxy[])dataContext.getData(AbstractTestProxy.DATA_KEYS);
        if (testProxies == null) {
            return null;
        }
        RunConfiguration runConfiguration = (RunConfiguration)dataContext.getData(RunConfiguration.DATA_KEY);
        if (!(runConfiguration instanceof JUnitConfiguration)) {
            return null;
        }
        Module module = ((JavaRunConfigurationModule)((JUnitConfiguration)runConfiguration).getConfigurationModule()).getModule();
        Project project = context.getProject();
        GlobalSearchScope globalSearchScope = searchScope = module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : GlobalSearchScope.projectScope((Project)project);
        if (!((Boolean)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> JUnitUtil.isJUnit5((GlobalSearchScope)searchScope, (Project)project) || TestObject.hasJUnit5EnginesAPI(searchScope, JavaPsiFacade.getInstance((Project)project)))).booleanValue()) {
            return null;
        }
        return (String[])Arrays.stream(testProxies).map(testProxy -> TestUniqueId.getEffectiveNodeId(testProxy, project, searchScope)).filter(Objects::nonNull).toArray(String[]::new);
    }

    protected boolean isApplicableTestType(String type, ConfigurationContext context) {
        return "uniqueId".equals(type);
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        if (self == null) {
            UniqueIdConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (other == null) {
            UniqueIdConfigurationProducer.$$$reportNull$$$0(4);
        }
        return self.isProducedBy(UniqueIdConfigurationProducer.class) && (other.isProducedBy(TestInClassConfigurationProducer.class) || other.isProducedBy(PatternConfigurationProducer.class));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/junit/UniqueIdConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupConfigurationFromContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldReplace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

