/*
 * Decompiled with CFR 0.152.
 */
package fleet.diff;

import andel.text.TextRange;
import fleet.diff.FileText;
import fleet.diff.MergeConflict;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"BASE_SPLITTER", "", "CONFLICT_END", "CONFLICT_SPLITTER", "CONFLICT_START", "parseConflicts", "", "Lfleet/diff/MergeConflict;", "text", "Lfleet/diff/FileText;", "fleet.andel.common"})
public final class ConflictParserKt {
    private static final String CONFLICT_START = "<<<<<<<";
    private static final String BASE_SPLITTER = "|||||||";
    private static final String CONFLICT_SPLITTER = "=======";
    private static final String CONFLICT_END = ">>>>>>>";

    @NotNull
    public static final List<MergeConflict> parseConflicts(@NotNull FileText text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ArrayList<MergeConflict> conflicts = new ArrayList<MergeConflict>();
        int start2 = -1;
        int splitterStart = -1;
        int splitterEnd = -1;
        for (FileText.Line line : text.getLines()) {
            CharSequence lineText = line.getLineText();
            if (StringsKt.startsWith$default((CharSequence)lineText, (CharSequence)CONFLICT_START, (boolean)false, (int)2, null)) {
                start2 = line.getStart();
                continue;
            }
            if (StringsKt.startsWith$default((CharSequence)lineText, (CharSequence)BASE_SPLITTER, (boolean)false, (int)2, null) && splitterStart < 0) {
                splitterStart = line.getStart() - 1;
                continue;
            }
            if (Intrinsics.areEqual((Object)lineText, (Object)CONFLICT_SPLITTER)) {
                if (splitterStart < 0) {
                    splitterStart = line.getStart() - 1;
                }
                splitterEnd = line.getEnd() + 1;
                continue;
            }
            if (!StringsKt.startsWith$default((CharSequence)lineText, (CharSequence)CONFLICT_END, (boolean)false, (int)2, null)) continue;
            if (start2 >= 0 && splitterStart > 0 && splitterEnd > 0) {
                conflicts.add(new MergeConflict(new TextRange(start2, splitterStart), new TextRange(splitterEnd, line.getEnd())));
            }
            start2 = -1;
            splitterStart = -1;
            splitterEnd = -1;
        }
        return conflicts;
    }
}

