/*
 * Decompiled with CFR 0.152.
 */
package fleet.util.tracing;

import fleet.util.tracing.PercentileAccumulation;
import io.opentelemetry.api.metrics.common.Labels;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.aggregator.AbstractAggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.DoubleSummaryData;
import io.opentelemetry.sdk.metrics.data.DoubleSummaryPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.ValueAtPercentile;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB1\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J6\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001cH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lfleet/util/tracing/PercentilesAggregator;", "Lio/opentelemetry/sdk/metrics/aggregator/AbstractAggregator;", "Lfleet/util/tracing/PercentileAccumulation;", "percentiles", "", "", "resource", "Lio/opentelemetry/sdk/resources/Resource;", "instrumentationLibraryInfo", "Lio/opentelemetry/sdk/common/InstrumentationLibraryInfo;", "descriptor", "Lio/opentelemetry/sdk/metrics/common/InstrumentDescriptor;", "(Ljava/util/List;Lio/opentelemetry/sdk/resources/Resource;Lio/opentelemetry/sdk/common/InstrumentationLibraryInfo;Lio/opentelemetry/sdk/metrics/common/InstrumentDescriptor;)V", "getPercentiles", "()Ljava/util/List;", "accumulateDouble", "value", "createHandle", "Lio/opentelemetry/sdk/metrics/aggregator/AggregatorHandle;", "merge", "previousAccumulation", "accumulation", "toMetricData", "Lio/opentelemetry/sdk/metrics/data/MetricData;", "accumulationByLabels", "", "Lio/opentelemetry/api/metrics/common/Labels;", "startEpochNanos", "", "lastCollectionEpoch", "epochNanos", "Handle", "fleet.util.telemetry"})
public final class PercentilesAggregator
extends AbstractAggregator<PercentileAccumulation> {
    @NotNull
    private final List<Double> percentiles;

    @Override
    @NotNull
    public AggregatorHandle<PercentileAccumulation> createHandle() {
        return new Handle(this.percentiles);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PercentileAccumulation accumulateDouble(double value) {
        Map map2;
        void $this$associateWith$iv;
        Iterable iterable = this.percentiles;
        double d = value;
        int n = 1;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            double d2 = ((Number)element$iv$iv).doubleValue();
            Object t = element$iv$iv;
            map2 = result$iv;
            boolean bl = false;
            Double d3 = value;
            map2.put(t, d3);
        }
        Map map3 = map2 = (Map)result$iv;
        double d4 = d;
        int n2 = n;
        return new PercentileAccumulation(n2, d4, map3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PercentileAccumulation merge(@NotNull PercentileAccumulation previousAccumulation, @NotNull PercentileAccumulation accumulation) {
        Map map2;
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter((Object)previousAccumulation, (String)"previousAccumulation");
        Intrinsics.checkNotNullParameter((Object)accumulation, (String)"accumulation");
        int nA = previousAccumulation.getPointsCount();
        int nB = accumulation.getPointsCount();
        Iterable iterable = this.percentiles;
        double d = previousAccumulation.getSum() + accumulation.getSum();
        int n = nA + nB;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            double d2;
            boolean bl;
            void percentile;
            double d3 = ((Number)element$iv$iv).doubleValue();
            Object t = element$iv$iv;
            map2 = result$iv;
            boolean bl2 = false;
            Double d4 = previousAccumulation.getPercentileToValue().get((double)percentile);
            Intrinsics.checkNotNull((Object)d4);
            double a = ((Number)d4).doubleValue();
            Double d5 = accumulation.getPercentileToValue().get((double)percentile);
            Intrinsics.checkNotNull((Object)d5);
            double b = ((Number)d5).doubleValue();
            if (percentile < (double)50) {
                bl = false;
                d2 = Math.min(a, b);
            } else if (percentile == 50.0) {
                d2 = ((double)nA * a + (double)nB * b) / (double)(nA + nB);
            } else {
                bl = false;
                d2 = Math.max(a, b);
            }
            Double d6 = d2;
            map2.put(t, d6);
        }
        Map map3 = map2 = (Map)result$iv;
        double d7 = d;
        int n2 = n;
        return new PercentileAccumulation(n2, d7, map3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public MetricData toMetricData(@NotNull Map<Labels, PercentileAccumulation> accumulationByLabels, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(accumulationByLabels, (String)"accumulationByLabels");
        Map<Labels, PercentileAccumulation> $this$map$iv = accumulationByLabels;
        boolean $i$f$map = false;
        Map<Labels, PercentileAccumulation> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var14_10 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var14_10.entrySet().iterator();
        while (iterator.hasNext()) {
            Collection<ValueAtPercentile> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void labels;
            void $dstr$labels$accumulation;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            Map<Double, Double> map3 = $dstr$labels$accumulation;
            boolean bl3 = false;
            Labels labels2 = (Labels)map3.getKey();
            map3 = $dstr$labels$accumulation;
            bl3 = false;
            PercentileAccumulation accumulation = (PercentileAccumulation)map3.getValue();
            map3 = accumulation.getPercentileToValue();
            double d = accumulation.getSum();
            long l = accumulation.getPointsCount();
            void var28_22 = labels;
            long l2 = epochNanos;
            long l3 = startEpochNanos;
            boolean $i$f$map2 = false;
            void var33_25 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo2 = false;
            void var36_28 = $this$mapTo$iv$iv2;
            boolean bl4 = false;
            Iterator iterator2 = var36_28.entrySet().iterator();
            while (iterator2.hasNext()) {
                void percentile;
                void $dstr$percentile$value;
                Map.Entry item$iv$iv2;
                Map.Entry entry2 = item$iv$iv2 = iterator2.next();
                collection = destination$iv$iv2;
                boolean bl5 = false;
                void var43_35 = $dstr$percentile$value;
                boolean bl6 = false;
                double d2 = ((Number)var43_35.getKey()).doubleValue();
                var43_35 = $dstr$percentile$value;
                bl6 = false;
                double value = ((Number)var43_35.getValue()).doubleValue();
                ValueAtPercentile valueAtPercentile = ValueAtPercentile.create((double)percentile, value);
                collection.add(valueAtPercentile);
            }
            collection = (List)destination$iv$iv2;
            DoubleSummaryPointData doubleSummaryPointData = DoubleSummaryPointData.create(l3, l2, (Labels)var28_22, l, d, (List<ValueAtPercentile>)collection);
            collection2.add(doubleSummaryPointData);
        }
        DoubleSummaryData data = DoubleSummaryData.create((List)destination$iv$iv);
        Resource resource = this.getResource();
        InstrumentationLibraryInfo instrumentationLibraryInfo = this.getInstrumentationLibraryInfo();
        InstrumentDescriptor instrumentDescriptor = this.getInstrumentDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)instrumentDescriptor, (String)"instrumentDescriptor");
        String string = instrumentDescriptor.getName();
        InstrumentDescriptor instrumentDescriptor2 = this.getInstrumentDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)instrumentDescriptor2, (String)"instrumentDescriptor");
        String string2 = instrumentDescriptor2.getDescription();
        InstrumentDescriptor instrumentDescriptor3 = this.getInstrumentDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)instrumentDescriptor3, (String)"instrumentDescriptor");
        return MetricData.createDoubleSummary(resource, instrumentationLibraryInfo, string, string2, instrumentDescriptor3.getUnit(), data);
    }

    @NotNull
    public final List<Double> getPercentiles() {
        return this.percentiles;
    }

    public PercentilesAggregator(@NotNull List<Double> percentiles, @Nullable Resource resource, @Nullable InstrumentationLibraryInfo instrumentationLibraryInfo, @Nullable InstrumentDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(percentiles, (String)"percentiles");
        super(resource, instrumentationLibraryInfo, descriptor, false);
        this.percentiles = percentiles;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0002H\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lfleet/util/tracing/PercentilesAggregator$Handle;", "Lio/opentelemetry/sdk/metrics/aggregator/AggregatorHandle;", "Lfleet/util/tracing/PercentileAccumulation;", "percentiles", "", "", "(Ljava/util/List;)V", "current", "Lfleet/util/tracing/PercentilesAggregator$Handle$MutableState;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "doAccumulateThenReset", "doRecordDouble", "", "value", "MutableState", "fleet.util.telemetry"})
    public static final class Handle
    extends AggregatorHandle<PercentileAccumulation> {
        private final ReentrantReadWriteLock lock;
        private final MutableState current;
        private final List<Double> percentiles;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected PercentileAccumulation doAccumulateThenReset() {
            void var1_1;
            this.lock.writeLock().lock();
            try {
                PercentileAccumulation toReturn = this.current.toAccumulation(this.percentiles);
                this.current.reset();
            }
            finally {
                this.lock.writeLock().unlock();
            }
            return var1_1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doRecordDouble(double value) {
            this.lock.writeLock().lock();
            try {
                this.current.record(value);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public Handle(@NotNull List<Double> percentiles) {
            Intrinsics.checkNotNullParameter(percentiles, (String)"percentiles");
            this.percentiles = percentiles;
            this.lock = new ReentrantReadWriteLock();
            this.current = new MutableState(null, 0.0, 3, null);
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c2\u0003J\t\u0010\b\u001a\u00020\u0004H\u00c2\u0003J#\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004J\u0006\u0010\u0012\u001a\u00020\u0010J\u0014\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lfleet/util/tracing/PercentilesAggregator$Handle$MutableState;", "", "points", "", "", "sum", "(Ljava/util/List;D)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "record", "", "value", "reset", "toAccumulation", "Lfleet/util/tracing/PercentileAccumulation;", "percentiles", "", "toString", "", "fleet.util.telemetry"})
        private static final class MutableState {
            private final List<Double> points;
            private double sum;

            public final void record(double value) {
                this.points.add(value);
                this.sum += value;
            }

            public final void reset() {
                this.points.clear();
                this.sum = 0.0;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final PercentileAccumulation toAccumulation(@NotNull List<Double> percentiles) {
                Map map2;
                void $this$associateWith$iv;
                Intrinsics.checkNotNullParameter(percentiles, (String)"percentiles");
                CollectionsKt.sort(this.points);
                Iterable iterable = percentiles;
                double d = this.sum;
                int n = this.points.size();
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                void $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo = false;
                for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                    void percentile;
                    double d2 = ((Number)element$iv$iv).doubleValue();
                    Object t = element$iv$iv;
                    map2 = result$iv;
                    boolean bl = false;
                    int index = RangesKt.coerceIn((int)MathKt.roundToInt((double)((double)(this.points.size() - 1) * percentile / (double)100)), (ClosedRange)((ClosedRange)CollectionsKt.getIndices((Collection)this.points)));
                    Double d3 = ((Number)this.points.get(index)).doubleValue();
                    map2.put(t, d3);
                }
                Map map3 = map2 = (Map)result$iv;
                double d4 = d;
                int n2 = n;
                return new PercentileAccumulation(n2, d4, map3);
            }

            public MutableState(@NotNull List<Double> points, double sum) {
                Intrinsics.checkNotNullParameter(points, (String)"points");
                this.points = points;
                this.sum = sum;
            }

            public /* synthetic */ MutableState(List list, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    list = new ArrayList();
                }
                if ((n & 2) != 0) {
                    d = 0.0;
                }
                this(list, d);
            }

            public MutableState() {
                this(null, 0.0, 3, null);
            }

            private final List<Double> component1() {
                return this.points;
            }

            private final double component2() {
                return this.sum;
            }

            @NotNull
            public final MutableState copy(@NotNull List<Double> points, double sum) {
                Intrinsics.checkNotNullParameter(points, (String)"points");
                return new MutableState(points, sum);
            }

            public static /* synthetic */ MutableState copy$default(MutableState mutableState, List list, double d, int n, Object object) {
                if ((n & 1) != 0) {
                    list = mutableState.points;
                }
                if ((n & 2) != 0) {
                    d = mutableState.sum;
                }
                return mutableState.copy(list, d);
            }

            @NotNull
            public String toString() {
                return "MutableState(points=" + this.points + ", sum=" + this.sum + ")";
            }

            public int hashCode() {
                List<Double> list = this.points;
                return (list != null ? ((Object)list).hashCode() : 0) * 31 + Double.hashCode(this.sum);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof MutableState)) break block3;
                        MutableState mutableState = (MutableState)object;
                        if (!Intrinsics.areEqual(this.points, mutableState.points) || Double.compare(this.sum, mutableState.sum) != 0) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

