/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.trace;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.UnknownFieldSet;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.exporter.otlp.trace.AttributeMarshaler;
import io.opentelemetry.exporter.otlp.trace.InstrumentationLibraryMarshaler;
import io.opentelemetry.exporter.otlp.trace.Marshaler;
import io.opentelemetry.exporter.otlp.trace.MarshalerUtil;
import io.opentelemetry.exporter.otlp.trace.MarshalerWithSize;
import io.opentelemetry.exporter.otlp.trace.ResourceMarshaler;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import io.opentelemetry.proto.trace.v1.Span;
import io.opentelemetry.proto.trace.v1.Status;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class TraceMarshaler {
    private static Map<Resource, Map<InstrumentationLibraryInfo, List<SpanMarshaler>>> groupByResourceAndLibrary(Collection<SpanData> spanDataList) {
        HashMap<Resource, Map<InstrumentationLibraryInfo, List<SpanMarshaler>>> result2 = new HashMap<Resource, Map<InstrumentationLibraryInfo, List<SpanMarshaler>>>();
        for (SpanData spanData : spanDataList) {
            ArrayList<SpanMarshaler> spanList;
            Resource resource = spanData.getResource();
            HashMap<InstrumentationLibraryInfo, ArrayList<SpanMarshaler>> libraryInfoListMap = (HashMap<InstrumentationLibraryInfo, ArrayList<SpanMarshaler>>)result2.get(spanData.getResource());
            if (libraryInfoListMap == null) {
                libraryInfoListMap = new HashMap<InstrumentationLibraryInfo, ArrayList<SpanMarshaler>>();
                result2.put(resource, libraryInfoListMap);
            }
            if ((spanList = (ArrayList<SpanMarshaler>)libraryInfoListMap.get(spanData.getInstrumentationLibraryInfo())) == null) {
                spanList = new ArrayList<SpanMarshaler>();
                libraryInfoListMap.put(spanData.getInstrumentationLibraryInfo(), spanList);
            }
            spanList.add(SpanMarshaler.create(spanData));
        }
        return result2;
    }

    private static Span.SpanKind toProtoSpanKind(SpanKind kind) {
        switch (kind) {
            case INTERNAL: {
                return Span.SpanKind.SPAN_KIND_INTERNAL;
            }
            case SERVER: {
                return Span.SpanKind.SPAN_KIND_SERVER;
            }
            case CLIENT: {
                return Span.SpanKind.SPAN_KIND_CLIENT;
            }
            case PRODUCER: {
                return Span.SpanKind.SPAN_KIND_PRODUCER;
            }
            case CONSUMER: {
                return Span.SpanKind.SPAN_KIND_CONSUMER;
            }
        }
        return Span.SpanKind.UNRECOGNIZED;
    }

    private TraceMarshaler() {
    }

    private static final class SpanStatusMarshaler
    extends MarshalerWithSize {
        private final Status.StatusCode protoStatusCode;
        private final Status.DeprecatedStatusCode deprecatedStatusCode;
        private final byte[] description;

        static SpanStatusMarshaler create(StatusData status) {
            Status.StatusCode protoStatusCode = Status.StatusCode.STATUS_CODE_UNSET;
            Status.DeprecatedStatusCode deprecatedStatusCode = Status.DeprecatedStatusCode.DEPRECATED_STATUS_CODE_OK;
            if (status.getStatusCode() == StatusCode.OK) {
                protoStatusCode = Status.StatusCode.STATUS_CODE_OK;
            } else if (status.getStatusCode() == StatusCode.ERROR) {
                protoStatusCode = Status.StatusCode.STATUS_CODE_ERROR;
                deprecatedStatusCode = Status.DeprecatedStatusCode.DEPRECATED_STATUS_CODE_UNKNOWN_ERROR;
            }
            byte[] description = MarshalerUtil.toBytes(status.getDescription());
            return new SpanStatusMarshaler(protoStatusCode, deprecatedStatusCode, description);
        }

        private SpanStatusMarshaler(Status.StatusCode protoStatusCode, Status.DeprecatedStatusCode deprecatedStatusCode, byte[] description) {
            super(SpanStatusMarshaler.computeSize(protoStatusCode, deprecatedStatusCode, description));
            this.protoStatusCode = protoStatusCode;
            this.deprecatedStatusCode = deprecatedStatusCode;
            this.description = description;
        }

        @Override
        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.deprecatedStatusCode != Status.DeprecatedStatusCode.DEPRECATED_STATUS_CODE_OK) {
                output.writeEnum(1, this.deprecatedStatusCode.getNumber());
            }
            MarshalerUtil.marshalBytes(2, this.description, output);
            if (this.protoStatusCode != Status.StatusCode.STATUS_CODE_UNSET) {
                output.writeEnum(3, this.protoStatusCode.getNumber());
            }
        }

        private static int computeSize(Status.StatusCode protoStatusCode, Status.DeprecatedStatusCode deprecatedStatusCode, byte[] description) {
            int size = 0;
            if (deprecatedStatusCode != Status.DeprecatedStatusCode.DEPRECATED_STATUS_CODE_OK) {
                size += CodedOutputStream.computeEnumSize((int)1, (int)deprecatedStatusCode.getNumber());
            }
            size += MarshalerUtil.sizeBytes(2, description);
            if (protoStatusCode != Status.StatusCode.STATUS_CODE_UNSET) {
                size += CodedOutputStream.computeEnumSize((int)3, (int)protoStatusCode.getNumber());
            }
            return size;
        }
    }

    private static final class SpanLinkMarshaler
    extends MarshalerWithSize {
        private static final SpanLinkMarshaler[] EMPTY = new SpanLinkMarshaler[0];
        private final byte[] traceId;
        private final byte[] spanId;
        private final AttributeMarshaler[] attributeMarshalers;
        private final int droppedAttributesCount;

        private static SpanLinkMarshaler[] create(List<LinkData> links) {
            if (links.isEmpty()) {
                return EMPTY;
            }
            SpanLinkMarshaler[] result2 = new SpanLinkMarshaler[links.size()];
            int pos = 0;
            for (LinkData link : links) {
                result2[pos++] = new SpanLinkMarshaler(link.getSpanContext().getTraceIdBytes(), link.getSpanContext().getSpanIdBytes(), AttributeMarshaler.createRepeated(link.getAttributes()), link.getTotalAttributeCount() - link.getAttributes().size());
            }
            return result2;
        }

        private SpanLinkMarshaler(byte[] traceId, byte[] spanId, AttributeMarshaler[] attributeMarshalers, int droppedAttributesCount) {
            super(SpanLinkMarshaler.calculateSize(traceId, spanId, attributeMarshalers, droppedAttributesCount));
            this.traceId = traceId;
            this.spanId = spanId;
            this.attributeMarshalers = attributeMarshalers;
            this.droppedAttributesCount = droppedAttributesCount;
        }

        @Override
        public void writeTo(CodedOutputStream output) throws IOException {
            MarshalerUtil.marshalBytes(1, this.traceId, output);
            MarshalerUtil.marshalBytes(2, this.spanId, output);
            MarshalerUtil.marshalRepeatedMessage((int)4, (Marshaler[])this.attributeMarshalers, (CodedOutputStream)output);
            MarshalerUtil.marshalUInt32(5, this.droppedAttributesCount, output);
        }

        private static int calculateSize(byte[] traceId, byte[] spanId, AttributeMarshaler[] attributeMarshalers, int droppedAttributesCount) {
            int size = 0;
            size += MarshalerUtil.sizeBytes(1, traceId);
            size += MarshalerUtil.sizeBytes(2, spanId);
            size += MarshalerUtil.sizeRepeatedMessage((int)4, (Marshaler[])attributeMarshalers);
            return size += MarshalerUtil.sizeUInt32(5, droppedAttributesCount);
        }
    }

    private static final class SpanEventMarshaler
    extends MarshalerWithSize {
        private static final SpanEventMarshaler[] EMPTY = new SpanEventMarshaler[0];
        private final long epochNanos;
        private final byte[] name;
        private final AttributeMarshaler[] attributeMarshalers;
        private final int droppedAttributesCount;

        private static SpanEventMarshaler[] create(List<EventData> events) {
            if (events.isEmpty()) {
                return EMPTY;
            }
            SpanEventMarshaler[] result2 = new SpanEventMarshaler[events.size()];
            int pos = 0;
            for (EventData event : events) {
                result2[pos++] = new SpanEventMarshaler(event.getEpochNanos(), MarshalerUtil.toBytes(event.getName()), AttributeMarshaler.createRepeated(event.getAttributes()), event.getTotalAttributeCount() - event.getAttributes().size());
            }
            return result2;
        }

        private SpanEventMarshaler(long epochNanos, byte[] name, AttributeMarshaler[] attributeMarshalers, int droppedAttributesCount) {
            super(SpanEventMarshaler.calculateSize(epochNanos, name, attributeMarshalers, droppedAttributesCount));
            this.epochNanos = epochNanos;
            this.name = name;
            this.attributeMarshalers = attributeMarshalers;
            this.droppedAttributesCount = droppedAttributesCount;
        }

        @Override
        public void writeTo(CodedOutputStream output) throws IOException {
            MarshalerUtil.marshalFixed64(1, this.epochNanos, output);
            MarshalerUtil.marshalBytes(2, this.name, output);
            MarshalerUtil.marshalRepeatedMessage((int)3, (Marshaler[])this.attributeMarshalers, (CodedOutputStream)output);
            MarshalerUtil.marshalUInt32(4, this.droppedAttributesCount, output);
        }

        private static int calculateSize(long epochNanos, byte[] name, AttributeMarshaler[] attributeMarshalers, int droppedAttributesCount) {
            int size = 0;
            size += MarshalerUtil.sizeFixed64(1, epochNanos);
            size += MarshalerUtil.sizeBytes(2, name);
            size += MarshalerUtil.sizeRepeatedMessage((int)3, (Marshaler[])attributeMarshalers);
            return size += MarshalerUtil.sizeUInt32(4, droppedAttributesCount);
        }
    }

    private static final class SpanMarshaler
    extends MarshalerWithSize {
        private final byte[] traceId;
        private final byte[] spanId;
        private final byte[] parentSpanId;
        private final byte[] name;
        private final int spanKind;
        private final long startEpochNanos;
        private final long endEpochNanos;
        private final AttributeMarshaler[] attributeMarshalers;
        private final int droppedAttributesCount;
        private final SpanEventMarshaler[] spanEventMarshalers;
        private final int droppedEventsCount;
        private final SpanLinkMarshaler[] spanLinkMarshalers;
        private final int droppedLinksCount;
        private final SpanStatusMarshaler spanStatusMarshaler;

        private static SpanMarshaler create(SpanData spanData) {
            AttributeMarshaler[] attributeMarshalers = AttributeMarshaler.createRepeated(spanData.getAttributes());
            SpanEventMarshaler[] spanEventMarshalers = SpanEventMarshaler.create(spanData.getEvents());
            SpanLinkMarshaler[] spanLinkMarshalers = SpanLinkMarshaler.create(spanData.getLinks());
            byte[] parentSpanId = MarshalerUtil.EMPTY_BYTES;
            SpanContext parentSpanContext = spanData.getParentSpanContext();
            if (parentSpanContext.isValid()) {
                parentSpanId = parentSpanContext.getSpanIdBytes();
            }
            return new SpanMarshaler(spanData.getSpanContext().getTraceIdBytes(), spanData.getSpanContext().getSpanIdBytes(), parentSpanId, MarshalerUtil.toBytes(spanData.getName()), TraceMarshaler.toProtoSpanKind(spanData.getKind()).getNumber(), spanData.getStartEpochNanos(), spanData.getEndEpochNanos(), attributeMarshalers, spanData.getTotalAttributeCount() - spanData.getAttributes().size(), spanEventMarshalers, spanData.getTotalRecordedEvents() - spanData.getEvents().size(), spanLinkMarshalers, spanData.getTotalRecordedLinks() - spanData.getLinks().size(), SpanStatusMarshaler.create(spanData.getStatus()));
        }

        private SpanMarshaler(byte[] traceId, byte[] spanId, byte[] parentSpanId, byte[] name, int spanKind, long startEpochNanos, long endEpochNanos, AttributeMarshaler[] attributeMarshalers, int droppedAttributesCount, SpanEventMarshaler[] spanEventMarshalers, int droppedEventsCount, SpanLinkMarshaler[] spanLinkMarshalers, int droppedLinksCount, SpanStatusMarshaler spanStatusMarshaler) {
            super(SpanMarshaler.calculateSize(traceId, spanId, parentSpanId, name, spanKind, startEpochNanos, endEpochNanos, attributeMarshalers, droppedAttributesCount, spanEventMarshalers, droppedEventsCount, spanLinkMarshalers, droppedLinksCount, spanStatusMarshaler));
            this.traceId = traceId;
            this.spanId = spanId;
            this.parentSpanId = parentSpanId;
            this.name = name;
            this.spanKind = spanKind;
            this.startEpochNanos = startEpochNanos;
            this.endEpochNanos = endEpochNanos;
            this.attributeMarshalers = attributeMarshalers;
            this.droppedAttributesCount = droppedAttributesCount;
            this.spanEventMarshalers = spanEventMarshalers;
            this.droppedEventsCount = droppedEventsCount;
            this.spanLinkMarshalers = spanLinkMarshalers;
            this.droppedLinksCount = droppedLinksCount;
            this.spanStatusMarshaler = spanStatusMarshaler;
        }

        @Override
        public void writeTo(CodedOutputStream output) throws IOException {
            MarshalerUtil.marshalBytes(1, this.traceId, output);
            MarshalerUtil.marshalBytes(2, this.spanId, output);
            MarshalerUtil.marshalBytes(4, this.parentSpanId, output);
            MarshalerUtil.marshalBytes(5, this.name, output);
            output.writeEnum(6, this.spanKind);
            MarshalerUtil.marshalFixed64(7, this.startEpochNanos, output);
            MarshalerUtil.marshalFixed64(8, this.endEpochNanos, output);
            MarshalerUtil.marshalRepeatedMessage((int)9, (Marshaler[])this.attributeMarshalers, (CodedOutputStream)output);
            MarshalerUtil.marshalUInt32(10, this.droppedAttributesCount, output);
            MarshalerUtil.marshalRepeatedMessage((int)11, (Marshaler[])this.spanEventMarshalers, (CodedOutputStream)output);
            MarshalerUtil.marshalUInt32(12, this.droppedEventsCount, output);
            MarshalerUtil.marshalRepeatedMessage((int)13, (Marshaler[])this.spanLinkMarshalers, (CodedOutputStream)output);
            MarshalerUtil.marshalUInt32(14, this.droppedLinksCount, output);
            MarshalerUtil.marshalMessage(15, this.spanStatusMarshaler, output);
        }

        private static int calculateSize(byte[] traceId, byte[] spanId, byte[] parentSpanId, byte[] name, int spanKind, long startEpochNanos, long endEpochNanos, AttributeMarshaler[] attributeMarshalers, int droppedAttributesCount, SpanEventMarshaler[] spanEventMarshalers, int droppedEventsCount, SpanLinkMarshaler[] spanLinkMarshalers, int droppedLinksCount, SpanStatusMarshaler spanStatusMarshaler) {
            int size = 0;
            size += MarshalerUtil.sizeBytes(1, traceId);
            size += MarshalerUtil.sizeBytes(2, spanId);
            size += MarshalerUtil.sizeBytes(4, parentSpanId);
            size += MarshalerUtil.sizeBytes(5, name);
            size += CodedOutputStream.computeEnumSize((int)6, (int)spanKind);
            size += MarshalerUtil.sizeFixed64(7, startEpochNanos);
            size += MarshalerUtil.sizeFixed64(8, endEpochNanos);
            size += MarshalerUtil.sizeRepeatedMessage((int)9, (Marshaler[])attributeMarshalers);
            size += MarshalerUtil.sizeUInt32(10, droppedAttributesCount);
            size += MarshalerUtil.sizeRepeatedMessage((int)11, (Marshaler[])spanEventMarshalers);
            size += MarshalerUtil.sizeUInt32(12, droppedEventsCount);
            size += MarshalerUtil.sizeRepeatedMessage((int)13, (Marshaler[])spanLinkMarshalers);
            size += MarshalerUtil.sizeUInt32(14, droppedLinksCount);
            return size += MarshalerUtil.sizeMessage(15, spanStatusMarshaler);
        }
    }

    private static final class InstrumentationLibrarySpansMarshaler
    extends MarshalerWithSize {
        private final InstrumentationLibraryMarshaler instrumentationLibrary;
        private final List<SpanMarshaler> spanMarshalers;

        private InstrumentationLibrarySpansMarshaler(InstrumentationLibraryMarshaler instrumentationLibrary, List<SpanMarshaler> spanMarshalers) {
            super(InstrumentationLibrarySpansMarshaler.calculateSize(instrumentationLibrary, spanMarshalers));
            this.instrumentationLibrary = instrumentationLibrary;
            this.spanMarshalers = spanMarshalers;
        }

        @Override
        public void writeTo(CodedOutputStream output) throws IOException {
            MarshalerUtil.marshalMessage(1, this.instrumentationLibrary, output);
            MarshalerUtil.marshalRepeatedMessage(2, this.spanMarshalers, output);
        }

        private static int calculateSize(InstrumentationLibraryMarshaler instrumentationLibrary, List<SpanMarshaler> spanMarshalers) {
            int size = 0;
            size += MarshalerUtil.sizeMessage(1, instrumentationLibrary);
            return size += MarshalerUtil.sizeRepeatedMessage(2, spanMarshalers);
        }
    }

    private static final class ResourceSpansMarshaler
    extends MarshalerWithSize {
        private final ResourceMarshaler resourceMarshaler;
        private final InstrumentationLibrarySpansMarshaler[] instrumentationLibrarySpansMarshalers;

        private ResourceSpansMarshaler(ResourceMarshaler resourceMarshaler, InstrumentationLibrarySpansMarshaler[] instrumentationLibrarySpansMarshalers) {
            super(ResourceSpansMarshaler.calculateSize(resourceMarshaler, instrumentationLibrarySpansMarshalers));
            this.resourceMarshaler = resourceMarshaler;
            this.instrumentationLibrarySpansMarshalers = instrumentationLibrarySpansMarshalers;
        }

        @Override
        public void writeTo(CodedOutputStream output) throws IOException {
            MarshalerUtil.marshalMessage(1, this.resourceMarshaler, output);
            MarshalerUtil.marshalRepeatedMessage((int)2, (Marshaler[])this.instrumentationLibrarySpansMarshalers, (CodedOutputStream)output);
        }

        private static int calculateSize(ResourceMarshaler resourceMarshaler, InstrumentationLibrarySpansMarshaler[] instrumentationLibrarySpansMarshalers) {
            int size = 0;
            size += MarshalerUtil.sizeMessage(1, resourceMarshaler);
            return size += MarshalerUtil.sizeRepeatedMessage((int)2, (Marshaler[])instrumentationLibrarySpansMarshalers);
        }
    }

    static final class RequestMarshaler
    extends MarshalerWithSize {
        private final ResourceSpansMarshaler[] resourceSpansMarshalers;

        static RequestMarshaler create(Collection<SpanData> spanDataList) {
            Map resourceAndLibraryMap = TraceMarshaler.groupByResourceAndLibrary(spanDataList);
            ResourceSpansMarshaler[] resourceSpansMarshalers = new ResourceSpansMarshaler[resourceAndLibraryMap.size()];
            int posResource = 0;
            for (Map.Entry entry : resourceAndLibraryMap.entrySet()) {
                InstrumentationLibrarySpansMarshaler[] instrumentationLibrarySpansMarshalers = new InstrumentationLibrarySpansMarshaler[((Map)entry.getValue()).size()];
                int posInstrumentation = 0;
                for (Map.Entry entryIs : ((Map)entry.getValue()).entrySet()) {
                    instrumentationLibrarySpansMarshalers[posInstrumentation++] = new InstrumentationLibrarySpansMarshaler(InstrumentationLibraryMarshaler.create((InstrumentationLibraryInfo)entryIs.getKey()), (List)entryIs.getValue());
                }
                resourceSpansMarshalers[posResource++] = new ResourceSpansMarshaler(ResourceMarshaler.create((Resource)entry.getKey()), instrumentationLibrarySpansMarshalers);
            }
            return new RequestMarshaler(resourceSpansMarshalers);
        }

        private RequestMarshaler(ResourceSpansMarshaler[] resourceSpansMarshalers) {
            super(MarshalerUtil.sizeRepeatedMessage((int)1, (Marshaler[])resourceSpansMarshalers));
            this.resourceSpansMarshalers = resourceSpansMarshalers;
        }

        ExportTraceServiceRequest toRequest() throws IOException {
            byte[] buf = new byte[this.getSerializedSize()];
            this.writeTo(CodedOutputStream.newInstance((byte[])buf));
            return ExportTraceServiceRequest.newBuilder().setUnknownFields(UnknownFieldSet.newBuilder().mergeFrom(buf).build()).build();
        }

        @Override
        public void writeTo(CodedOutputStream output) throws IOException {
            MarshalerUtil.marshalRepeatedMessage((int)1, (Marshaler[])this.resourceSpansMarshalers, (CodedOutputStream)output);
        }
    }
}

