/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.internal.ComponentRegistry;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.SdkMeter;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.ViewRegistry;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class SdkMeterProvider
implements MeterProvider,
MetricProducer {
    private static final Logger LOGGER = Logger.getLogger(SdkMeterProvider.class.getName());
    static final String DEFAULT_METER_NAME = "unknown";
    private final ComponentRegistry<SdkMeter> registry;
    private final MeterProviderSharedState sharedState;

    SdkMeterProvider(Clock clock, Resource resource, ViewRegistry viewRegistry) {
        this.sharedState = MeterProviderSharedState.create(clock, resource, viewRegistry);
        this.registry = new ComponentRegistry<SdkMeter>(instrumentationLibraryInfo -> new SdkMeter(this.sharedState, (InstrumentationLibraryInfo)instrumentationLibraryInfo));
    }

    @Override
    public Meter get(String instrumentationName) {
        return this.get(instrumentationName, null);
    }

    @Override
    public Meter get(String instrumentationName, @Nullable String instrumentationVersion) {
        if (instrumentationName == null || instrumentationName.isEmpty()) {
            LOGGER.fine("Meter requested without instrumentation name.");
            instrumentationName = DEFAULT_METER_NAME;
        }
        return this.registry.get(instrumentationName, instrumentationVersion);
    }

    @Override
    public Collection<MetricData> collectAllMetrics() {
        Collection<SdkMeter> meters = this.registry.getComponents();
        ArrayList<MetricData> result2 = new ArrayList<MetricData>(meters.size());
        for (SdkMeter meter2 : meters) {
            result2.addAll(meter2.collectAll(this.sharedState.getClock().now()));
        }
        return Collections.unmodifiableCollection(result2);
    }

    public static SdkMeterProviderBuilder builder() {
        return new SdkMeterProviderBuilder();
    }
}

