/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.aggregator.DoubleLastValueAggregator;
import io.opentelemetry.sdk.metrics.aggregator.LongLastValueAggregator;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.resources.Resource;

final class LastValueAggregatorFactory
implements AggregatorFactory {
    static final AggregatorFactory INSTANCE = new LastValueAggregatorFactory();

    private LastValueAggregatorFactory() {
    }

    @Override
    public <T> Aggregator<T> create(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor) {
        switch (descriptor.getValueType()) {
            case LONG: {
                return new LongLastValueAggregator(resource, instrumentationLibraryInfo, descriptor);
            }
            case DOUBLE: {
                return new DoubleLastValueAggregator(resource, instrumentationLibraryInfo, descriptor);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }
}

