/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.export;

import com.google.auto.value.AutoValue;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.DaemonThreadFactory;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.AutoValue_IntervalMetricReader_InternalState;
import io.opentelemetry.sdk.metrics.export.IntervalMetricReaderBuilder;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

public final class IntervalMetricReader {
    private static final Logger logger = Logger.getLogger(IntervalMetricReader.class.getName());
    private final Exporter exporter;
    private final ScheduledExecutorService scheduler;
    private volatile ScheduledFuture<?> scheduledFuture;
    private final Object lock = new Object();

    public CompletableResultCode shutdown() {
        CompletableResultCode result2 = new CompletableResultCode();
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
        this.scheduler.shutdown();
        try {
            this.scheduler.awaitTermination(5L, TimeUnit.SECONDS);
            CompletableResultCode flushResult = this.exporter.doRun();
            flushResult.join(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
        finally {
            CompletableResultCode shutdownResult = this.exporter.shutdown();
            shutdownResult.whenComplete(() -> {
                if (!shutdownResult.isSuccess()) {
                    result2.fail();
                } else {
                    result2.succeed();
                }
            });
        }
        return result2;
    }

    public static IntervalMetricReaderBuilder builder() {
        return new IntervalMetricReaderBuilder(InternalState.builder());
    }

    IntervalMetricReader(InternalState internalState) {
        this(internalState, Executors.newScheduledThreadPool(1, new DaemonThreadFactory("IntervalMetricReader")));
    }

    IntervalMetricReader(InternalState internalState, ScheduledExecutorService intervalMetricReader) {
        this.exporter = new Exporter(internalState);
        this.scheduler = intervalMetricReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntervalMetricReader start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.scheduledFuture != null) {
                return this;
            }
            this.scheduledFuture = this.scheduler.scheduleAtFixedRate(this.exporter, this.exporter.internalState.getExportIntervalMillis(), this.exporter.internalState.getExportIntervalMillis(), TimeUnit.MILLISECONDS);
            return this;
        }
    }

    @AutoValue
    @Immutable
    static abstract class InternalState {
        static final long DEFAULT_INTERVAL_MILLIS = 60000L;

        InternalState() {
        }

        abstract MetricExporter getMetricExporter();

        abstract long getExportIntervalMillis();

        abstract Collection<MetricProducer> getMetricProducers();

        static Builder builder() {
            return new AutoValue_IntervalMetricReader_InternalState.Builder().setExportIntervalMillis(60000L);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setExportIntervalMillis(long var1);

            abstract Builder setMetricExporter(MetricExporter var1);

            abstract Builder setMetricProducers(Collection<MetricProducer> var1);

            abstract InternalState build();
        }
    }

    private static final class Exporter
    implements Runnable {
        private final InternalState internalState;
        private final AtomicBoolean exportAvailable = new AtomicBoolean(true);

        private Exporter(InternalState internalState) {
            this.internalState = internalState;
        }

        @Override
        public void run() {
            this.doRun();
        }

        CompletableResultCode doRun() {
            CompletableResultCode flushResult = new CompletableResultCode();
            if (this.exportAvailable.compareAndSet(true, false)) {
                try {
                    ArrayList<MetricData> metricsList = new ArrayList<MetricData>();
                    for (MetricProducer metricProducer : this.internalState.getMetricProducers()) {
                        metricsList.addAll(metricProducer.collectAllMetrics());
                    }
                    CompletableResultCode result2 = this.internalState.getMetricExporter().export(Collections.unmodifiableList(metricsList));
                    result2.whenComplete(() -> {
                        if (!result2.isSuccess()) {
                            logger.log(Level.FINE, "Exporter failed");
                        }
                        flushResult.succeed();
                        this.exportAvailable.set(true);
                    });
                }
                catch (Throwable t) {
                    this.exportAvailable.set(true);
                    logger.log(Level.WARNING, "Exporter threw an Exception", t);
                    flushResult.fail();
                }
            } else {
                logger.log(Level.FINE, "Exporter busy. Dropping metrics.");
                flushResult.fail();
            }
            return flushResult;
        }

        CompletableResultCode shutdown() {
            return this.internalState.getMetricExporter().shutdown();
        }
    }
}

