/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.stacktrace;

import java.util.ArrayDeque;
import java.util.Deque;
import net.logstash.logback.stacktrace.StackElementFilter;

public class StackHasher {
    private final StackElementFilter filter;

    public StackHasher(StackElementFilter filter2) {
        this.filter = filter2;
    }

    public StackHasher() {
        this(StackElementFilter.withSourceInfo());
    }

    public String hexHash(Throwable error2) {
        return this.toHex(this.hash(error2, null));
    }

    public Deque<String> hexHashes(Throwable error2) {
        ArrayDeque<String> hexHashes = new ArrayDeque<String>();
        this.hash(error2, hexHashes);
        return hexHashes;
    }

    int hash(Throwable error2, Deque<String> hexHashes) {
        int hash = 0;
        if (error2.getCause() != null && error2.getCause() != error2) {
            hash = this.hash(error2.getCause(), hexHashes);
        }
        hash = 31 * hash + error2.getClass().getName().hashCode();
        for (StackTraceElement element : error2.getStackTrace()) {
            if (!this.filter.accept(element)) continue;
            hash = 31 * hash + this.hash(element);
        }
        if (hexHashes != null) {
            hexHashes.push(this.toHex(hash));
        }
        return hash;
    }

    String toHex(int hash) {
        return String.format("%08x", hash);
    }

    int hash(StackTraceElement element) {
        int result2 = element.getClassName().hashCode();
        result2 = 31 * result2 + element.getMethodName().hashCode();
        result2 = 31 * result2 + element.getLineNumber();
        return result2;
    }
}

