/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.highlight;

import com.google.gson.JsonParseException;
import com.intellij.ide.IdeBundle;
import com.intellij.navigation.LocationInFile;
import com.intellij.navigation.NavigatorWithinProject;
import com.intellij.navigation.NavigatorWithinProjectKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.JBProtocolCommand;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.jetbrains.qodana.sarif.SarifUtil;
import com.jetbrains.qodana.sarif.model.ArtifactLocation;
import com.jetbrains.qodana.sarif.model.Location;
import com.jetbrains.qodana.sarif.model.Message;
import com.jetbrains.qodana.sarif.model.PhysicalLocation;
import com.jetbrains.qodana.sarif.model.Region;
import com.jetbrains.qodana.sarif.model.Result;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.RunAutomationDetails;
import com.jetbrains.qodana.sarif.model.SarifReport;
import com.jetbrains.qodana.sarif.model.Tool;
import com.jetbrains.qodana.sarif.model.ToolComponent;
import com.jetbrains.qodana.sarif.model.VersionControlDetails;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.highlight.QodanaReportsService;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00132\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J$\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00132\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J8\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/qodana/highlight/JBProtocolShowQodanaReportCommand;", "Lcom/intellij/openapi/application/JBProtocolCommand;", "()V", "constructSingleMarkerReport", "Lcom/jetbrains/qodana/sarif/model/SarifReport;", "parameters", "", "", "findAndNavigate", "", "project", "Lcom/intellij/openapi/project/Project;", "locationToOffset", "", "locationInFile", "Lcom/intellij/navigation/LocationInFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "navigateAndOpenReport", "Ljava/util/concurrent/Future;", "navigateAndShowMarker", "perform", "target", "", "fragment", "OpenReportTask", "intellij.qodana"})
public final class JBProtocolShowQodanaReportCommand
extends JBProtocolCommand {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Future<String> perform(@Nullable String target, @NotNull Map<String, String> parameters, @Nullable String fragment) {
        Future future;
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        String string = target;
        if (string != null) {
            switch (string) {
                case "openReport": {
                    future = this.navigateAndOpenReport(parameters);
                    return future;
                }
                case "showMarker": {
                    future = this.navigateAndShowMarker(parameters);
                    return future;
                }
            }
        }
        CompletableFuture<String> completableFuture = CompletableFuture.completedFuture(IdeBundle.message((String)"jb.protocol.unknown.target", (Object[])new Object[]{target}));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.comple\u2026unknown.target\", target))");
        future = completableFuture;
        return future;
    }

    private final Future<String> navigateAndOpenReport(Map<String, String> parameters) {
        CompletionStage completionStage = NavigatorWithinProjectKt.openProject(parameters).handle(new BiFunction(this, parameters){
            final /* synthetic */ JBProtocolShowQodanaReportCommand this$0;
            final /* synthetic */ Map $parameters;

            @Nullable
            public final String apply(@Nullable Project project, Throwable t) {
                String string;
                if (t != null) {
                    string = t.getClass().getName() + ": " + t.getMessage();
                } else if (project == null) {
                    string = IdeBundle.message((String)"jb.protocol.navigate.no.project", (Object[])new Object[0]);
                } else {
                    JBProtocolShowQodanaReportCommand.access$findAndNavigate(this.this$0, project, this.$parameters);
                    String string2 = JBProtocolShowQodanaReportCommand.access$parameter(this.this$0, this.$parameters, "report");
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parameter(parameters, \"report\")");
                    new OpenReportTask(project, string2).queue();
                    string = null;
                }
                return string;
            }
            {
                this.this$0 = jBProtocolShowQodanaReportCommand;
                this.$parameters = map;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"openProject(parameters).\u2026l\n        }\n      }\n    }");
        return (Future)((Object)completionStage);
    }

    private final Future<String> navigateAndShowMarker(Map<String, String> parameters) {
        CompletionStage completionStage = NavigatorWithinProjectKt.openProject(parameters).handle(new BiFunction(this, parameters){
            final /* synthetic */ JBProtocolShowQodanaReportCommand this$0;
            final /* synthetic */ Map $parameters;

            @Nullable
            public final String apply(@Nullable Project project, Throwable t) {
                String string;
                if (t != null) {
                    string = t.getClass().getName() + ": " + t.getMessage();
                } else if (project == null) {
                    string = IdeBundle.message((String)"jb.protocol.navigate.no.project", (Object[])new Object[0]);
                } else {
                    JBProtocolShowQodanaReportCommand.access$findAndNavigate(this.this$0, project, this.$parameters);
                    SarifReport report = JBProtocolShowQodanaReportCommand.access$constructSingleMarkerReport(this.this$0, this.$parameters);
                    QodanaReportsService reportService = (QodanaReportsService)project.getService(QodanaReportsService.class);
                    QodanaReportsService.ReportDescription reportDescription2 = reportService.addReport(report);
                    reportService.setReportToHighlight(reportDescription2.getReportGuid());
                    string = null;
                }
                return string;
            }
            {
                this.this$0 = jBProtocolShowQodanaReportCommand;
                this.$parameters = map;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"openProject(parameters).\u2026l\n        }\n      }\n    }");
        return (Future)((Object)completionStage);
    }

    private final void findAndNavigate(Project project, Map<String, String> parameters) {
        new NavigatorWithinProject(project, parameters, (Function2)new Function2<LocationInFile, Editor, Integer>(this){

            public final int invoke(@NotNull LocationInFile p1, @NotNull Editor p2) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                return JBProtocolShowQodanaReportCommand.access$locationToOffset((JBProtocolShowQodanaReportCommand)((Object)this.receiver), p1, p2);
            }
        }).navigate(CollectionsKt.listOf((Object)NavigatorWithinProject.NavigationKeyPrefix.PATH));
    }

    /*
     * WARNING - void declaration
     */
    private final SarifReport constructSingleMarkerReport(Map<String, String> parameters) {
        void line;
        void path;
        String string = this.parameter(parameters, "message");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameter(parameters, \"message\")");
        String message = string;
        String string2 = this.parameter(parameters, "path");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parameter(parameters, \"path\")");
        String pathText = string2;
        String string3 = this.parameter(parameters, "length");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"parameter(parameters, \"length\")");
        String markerLength = string3;
        String string4 = parameters.get("origin");
        if (string4 == null) {
            string4 = "Unknown";
        }
        String origin = string4;
        String revisionId = parameters.get("marker_revision");
        Triple triple = NavigatorWithinProject.Companion.parseNavigationPath(pathText);
        String string5 = (String)triple.component1();
        String string6 = (String)triple.component2();
        String column = (String)triple.component3();
        if (path == null || line == null || column == null) {
            throw (Throwable)new IllegalArgumentException("The URL should have a 'path' parameter in the '$path:$line:$column' format");
        }
        RunAutomationDetails automationDetails = new RunAutomationDetails().withGuid(UUID.randomUUID().toString()).withId(pathText + " - " + message);
        VersionControlDetails vcsDetails = revisionId != null ? new VersionControlDetails(URI.create(origin)).withRevisionId(revisionId) : null;
        String string7 = column;
        boolean bl = false;
        Region region = new Region().withStartColumn(Integer.valueOf(Integer.parseInt(string7)));
        string7 = line;
        bl = false;
        Region region2 = region.withStartLine(Integer.valueOf(Integer.parseInt(string7)));
        string7 = markerLength;
        bl = false;
        Result result = new Result(new Message().withText(message)).withLocations(CollectionsKt.listOf((Object)new Location().withPhysicalLocation(new PhysicalLocation().withArtifactLocation(new ArtifactLocation().withUri((String)path).withUriBaseId("SRCROOT")).withRegion(region2.withCharLength(Integer.valueOf(Integer.parseInt(string7)))))));
        Run run = new Run(new Tool(new ToolComponent("single-marker-tool"))).withAutomationDetails(automationDetails).withVersionControlProvenance(SetsKt.setOf((Object)vcsDetails)).withResults(CollectionsKt.listOf((Object)result));
        return new SarifReport(SarifReport.Version._2_1_0, CollectionsKt.listOf((Object)run));
    }

    private final int locationToOffset(LocationInFile locationInFile, Editor editor) {
        Comparable comparable = ComparatorUtil.max((Comparable)Integer.valueOf(locationInFile.getLine() - 1), (Comparable)Integer.valueOf(0));
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"max(locationInFile.line - 1, 0)");
        int offsetOfLine = editor.logicalPositionToOffset(new LogicalPosition(((Number)((Object)comparable)).intValue(), 0));
        Comparable comparable2 = ComparatorUtil.max((Comparable)Integer.valueOf(locationInFile.getColumn() - 1), (Comparable)Integer.valueOf(0));
        Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"max(locationInFile.column - 1, 0)");
        int offsetInLine = ((Number)((Object)comparable2)).intValue();
        return offsetOfLine + offsetInLine;
    }

    public JBProtocolShowQodanaReportCommand() {
        super("qodana");
    }

    public static final /* synthetic */ void access$findAndNavigate(JBProtocolShowQodanaReportCommand $this, Project project, Map parameters) {
        $this.findAndNavigate(project, parameters);
    }

    public static final /* synthetic */ String access$parameter(JBProtocolShowQodanaReportCommand $this, Map p0, String p1) {
        return $this.parameter(p0, p1);
    }

    public static final /* synthetic */ SarifReport access$constructSingleMarkerReport(JBProtocolShowQodanaReportCommand $this, Map parameters) {
        return $this.constructSingleMarkerReport(parameters);
    }

    public static final /* synthetic */ int access$locationToOffset(JBProtocolShowQodanaReportCommand $this, LocationInFile locationInFile, Editor editor) {
        return $this.locationToOffset(locationInFile, editor);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001a\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/qodana/highlight/JBProtocolShowQodanaReportCommand$OpenReportTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "project", "Lcom/intellij/openapi/project/Project;", "reportUrl", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "downloadReport", "Lcom/intellij/openapi/vfs/VirtualFile;", "downloadReportOrNotify", "parseSarifReport", "Lcom/jetbrains/qodana/sarif/model/SarifReport;", "reportFile", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.qodana"})
    public static final class OpenReportTask
    extends Task.Backgroundable {
        private final String reportUrl;

        public void run(@NotNull ProgressIndicator indicator) {
            Object object;
            QodanaReportsService reportService;
            block6: {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    Project project = this.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                    VirtualFile virtualFile = this.downloadReportOrNotify(this.reportUrl, project);
                    if (virtualFile == null) {
                        return;
                    }
                    VirtualFile reportFile = virtualFile;
                    SarifReport sarifReport = this.parseSarifReport(reportFile, this.reportUrl);
                    if (sarifReport == null) {
                        return;
                    }
                    SarifReport sarifReport2 = sarifReport;
                    reportService = (QodanaReportsService)this.getProject().getService(QodanaReportsService.class);
                    object = reportFile.getCanonicalPath();
                    if (object == null) break block5;
                    String string = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string;
                    boolean bl3 = false;
                    Path path = Paths.get(it, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(it)");
                    object = reportService.addLocalReport(path, sarifReport2);
                    if (object != null) break block6;
                }
                return;
            }
            Object reportDescription2 = object;
            reportService.setReportToHighlight(((QodanaReportsService.ReportDescription)reportDescription2).getReportGuid());
        }

        private final SarifReport parseSarifReport(VirtualFile reportFile, String reportUrl) {
            SarifReport sarifReport;
            try {
                sarifReport = SarifUtil.readReport((Path)reportFile.toNioPath());
            }
            catch (JsonParseException e) {
                String string = QodanaBundle.message("notification.title.cant.parse.report", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"QodanaBundle.message(\"no\u2026title.cant.parse.report\")");
                String title = string;
                String string2 = QodanaBundle.message("notification.content.cant.parse.report", reportUrl);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"QodanaBundle.message(\"no\u2026parse.report\", reportUrl)");
                String message = string2;
                new Notification("Qodana", title, message, NotificationType.WARNING).notify(this.getProject());
                sarifReport = null;
            }
            return sarifReport;
        }

        private final VirtualFile downloadReportOrNotify(String reportUrl, Project project) {
            VirtualFile reportFile = this.downloadReport(reportUrl, project);
            if (reportFile == null) {
                String string = QodanaBundle.message("notification.title.cant.download.report", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"QodanaBundle.message(\"no\u2026le.cant.download.report\")");
                String title = string;
                String string2 = QodanaBundle.message("notification.content.cant.download.report", reportUrl);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"QodanaBundle.message(\"no\u2026nload.report\", reportUrl)");
                String message = string2;
                new Notification("Qodana", title, message, NotificationType.WARNING).notify(project);
            }
            return reportFile;
        }

        private final VirtualFile downloadReport(String reportUrl, Project project) {
            DownloadableFileService service = DownloadableFileService.getInstance();
            File file = FileUtil.createTempFile((String)"qodana-report.", (String)".json");
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"FileUtil.createTempFile(\"qodana-report.\", \".json\")");
            File reportFile = file;
            FileDownloader fileDownloader = service.createDownloader(CollectionsKt.listOf((Object)service.createFileDescription(reportUrl, reportFile.getName())), reportUrl);
            Intrinsics.checkNotNullExpressionValue((Object)fileDownloader, (String)"service.createDownloader\u2026rtFile.name)), reportUrl)");
            FileDownloader downloader = fileDownloader;
            CompletableFuture completableFuture = downloader.downloadWithBackgroundProgress(reportFile.getParent(), project);
            Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"downloader.downloadWithB\u2026portFile.parent, project)");
            CompletableFuture future = completableFuture;
            try {
                List list = (List)future.get(10L, TimeUnit.MINUTES);
                return list != null && (list = (Pair)CollectionsKt.firstOrNull((List)list)) != null ? (VirtualFile)((Pair)list).first : null;
            }
            catch (ExecutionException e) {
                OpenReportTask $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(OpenReportTask.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.warn("Can't download report from: " + reportUrl, (Throwable)e);
            }
            catch (TimeoutException e) {
                OpenReportTask $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(OpenReportTask.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.warn("Timeout for downloading report from: " + reportUrl, (Throwable)e);
            }
            return null;
        }

        public OpenReportTask(@NotNull Project project, @NotNull String reportUrl) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)reportUrl, (String)"reportUrl");
            super(project, QodanaBundle.message("progress.title.qodana.highlight", new Object[0]), true);
            this.reportUrl = reportUrl;
        }
    }
}

