/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.highlight;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.navigation.JBProtocolRevisionResolver;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.qodana.sarif.model.Region;
import com.jetbrains.qodana.sarif.model.Result;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.SarifReport;
import com.jetbrains.qodana.sarif.model.VersionControlDetails;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.highlight.ProblemsKt;
import org.jetbrains.qodana.highlight.QodanaReportHighlightingPassKt;
import org.jetbrains.qodana.highlight.QodanaReportsService;
import org.jetbrains.qodana.highlight.QodanaRevisionData;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001fB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J(\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0002J0\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00130\u00120\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u0017H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/qodana/highlight/QodanaReportHighlightingPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "Lcom/intellij/openapi/project/DumbAware;", "myFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)V", "myInfos", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "calculateTextRanges", "", "Lcom/intellij/openapi/util/TextRange;", "relevantResults", "Lcom/jetbrains/qodana/sarif/model/Region;", "revisionPsiFile", "collectRelevantResults", "Lkotlin/Pair;", "Lcom/jetbrains/qodana/sarif/model/Result;", "results", "", "relativePath", "", "doApplyInformationToEditor", "", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getPsiFileByRevision", "revisionId", "Registrar", "intellij.qodana"})
public final class QodanaReportHighlightingPass
extends TextEditorHighlightingPass
implements DumbAware {
    private final List<HighlightInfo> myInfos;
    private final PsiFile myFile;
    private final Editor editor;

    /*
     * WARNING - void declaration
     */
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Region region;
        Pair it;
        Collection<Region> collection;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        QodanaRevisionData data;
        List<Pair<Region, Result>> relevantResults;
        block11: {
            void title$iv;
            String revisionId;
            block10: {
                Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
                this.myInfos.clear();
                QodanaReportsService reportsService = (QodanaReportsService)this.myFile.getProject().getService(QodanaReportsService.class);
                SarifReport sarifReport = reportsService.getReportForHighlight();
                if (sarifReport == null) {
                    return;
                }
                SarifReport report = sarifReport;
                List runs = report.getRuns();
                if (runs.isEmpty()) {
                    return;
                }
                Object e = runs.get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"runs[0]");
                List list = ((Run)e).getResults();
                if (list == null) {
                    return;
                }
                List results = list;
                Project project = this.myFile.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myFile.project");
                VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
                if (virtualFile == null) {
                    return;
                }
                VirtualFile projectDir = virtualFile;
                String string = VfsUtilCore.getRelativePath((VirtualFile)this.myFile.getVirtualFile(), (VirtualFile)projectDir);
                if (string == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtilCore.getRelativeP\u2026le, projectDir) ?: return");
                String relativePath = string;
                relevantResults = this.collectRelevantResults(results, relativePath);
                if (relevantResults.isEmpty()) {
                    return;
                }
                Object e2 = report.getRuns().get(0);
                Intrinsics.checkNotNullExpressionValue(e2, (String)"report.runs[0]");
                Set set = ((Run)e2).getVersionControlProvenance();
                revisionId = set != null && (set = (VersionControlDetails)CollectionsKt.firstOrNull((Iterable)set)) != null ? set.getRevisionId() : null;
                data = (QodanaRevisionData)this.editor.getDocument().getUserData(QodanaReportHighlightingPassKt.getQODANA_REVISION_DATA());
                if (data == null || Intrinsics.areEqual((Object)data.getRevisionId(), (Object)revisionId) ^ true) break block10;
                PsiFile psiFile = data.getRevisionPsiFile();
                if (psiFile == null) break block11;
                if (psiFile.isValid()) break block11;
            }
            String string = QodanaBundle.message("progress.title.qodana.highlight.calc", this.myFile.getName());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"QodanaBundle.message(\"pr\u2026light.calc\", myFile.name)");
            String string2 = string;
            Project project$iv = this.myFile.getProject();
            boolean cancellable$iv = true;
            boolean $i$f$runBackgroundableTask = false;
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project$iv, (String)title$iv, cancellable$iv, project$iv, (String)title$iv, cancellable$iv, this, revisionId){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $title;
                final /* synthetic */ boolean $cancellable;
                final /* synthetic */ QodanaReportHighlightingPass this$0;
                final /* synthetic */ String $revisionId$inlined;
                {
                    this.$project = $captured_local_variable$1;
                    this.$title = $captured_local_variable$2;
                    this.$cancellable = $captured_local_variable$3;
                    this.this$0 = qodanaReportHighlightingPass;
                    this.$revisionId$inlined = string;
                    super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ProgressIndicator it = indicator;
                    boolean bl = false;
                    PsiFile revisionPsiFile = QodanaReportHighlightingPass.access$getPsiFileByRevision(this.this$0, QodanaReportHighlightingPass.access$getMyFile$p(this.this$0), this.$revisionId$inlined);
                    QodanaReportHighlightingPass.access$getEditor$p(this.this$0).getDocument().putUserData(QodanaReportHighlightingPassKt.getQODANA_REVISION_DATA(), (Object)new QodanaRevisionData(this.$revisionId$inlined, revisionPsiFile));
                    DaemonCodeAnalyzer.getInstance((Project)QodanaReportHighlightingPass.access$getMyProject$p(this.this$0)).restart(QodanaReportHighlightingPass.access$getMyFile$p(this.this$0));
                }
            });
            return;
        }
        Iterable project$iv = relevantResults;
        Object object2 = this;
        boolean $i$f$map = false;
        void $i$f$runBackgroundableTask = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            object = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            region = (Region)it.getFirst();
            collection.add(region);
        }
        collection = (List)destination$iv$iv;
        List<TextRange> textRanges = ((QodanaReportHighlightingPass)((Object)object2)).calculateTextRanges((List<? extends Region>)collection, data.getRevisionPsiFile());
        $this$map$iv = relevantResults;
        object2 = this.myInfos;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            region = (Result)it.getSecond();
            collection.add(region);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = CollectionsKt.zip((Iterable)collection, (Iterable)textRanges);
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            HighlightInfo highlightInfo;
            void result;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            Pair $dstr$result$range = (Pair)element$iv$iv;
            boolean bl2 = false;
            Result result2 = (Result)$dstr$result$range.component1();
            TextRange range = (TextRange)$dstr$result$range.component2();
            if (ProblemsKt.buildHighlightInfo((Result)result, range) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            HighlightInfo it$iv$iv = highlightInfo;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        collection = (List)destination$iv$iv;
        object2.addAll(collection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final PsiFile getPsiFileByRevision(PsiFile myFile, String revisionId) {
        PsiFile psiFile;
        if (revisionId == null) return null;
        VirtualFile virtualFile = myFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"myFile.virtualFile");
        String string = virtualFile.getCanonicalPath();
        if (string == null) return null;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myFile.virtualFile.canonicalPath ?: return null");
        String path = string;
        Project project = myFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myFile.project");
        Project project2 = project;
        VirtualFile virtualFile2 = JBProtocolRevisionResolver.processResolvers((Project)project2, (String)path, (String)revisionId);
        if (virtualFile2 == null) return null;
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"JBProtocolRevisionResolv\u2026evisionId) ?: return null");
        VirtualFile revisionFile = virtualFile2;
        boolean $i$f$runReadAction = false;
        PsiFile psiFile2 = psiFile = (PsiFile)ApplicationManager.getApplication().runReadAction(new Computable(project2, revisionFile){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ VirtualFile $revisionFile$inlined;
            {
                this.$project$inlined = project;
                this.$revisionFile$inlined = virtualFile;
            }

            public final T compute() {
                boolean bl = false;
                return (T)PsiManager.getInstance((Project)this.$project$inlined).findFile(this.$revisionFile$inlined);
            }
        });
        if (psiFile2 != null) {
            if (!psiFile2.isValid()) {
                return null;
            }
        }
        PsiFile psiFile3 = psiFile;
        return psiFile3;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TextRange> calculateTextRanges(List<? extends Region> relevantResults, PsiFile revisionPsiFile) {
        int n;
        int n2;
        TextRange textRange;
        Collection collection;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = relevantResults;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (Region)item$iv$iv;
            collection = destination$iv$iv22;
            boolean bl = false;
            Document document = this.myDocument;
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"myDocument");
            textRange = ProblemsKt.toTextRange((Region)it, document);
            collection.add(textRange);
        }
        List rangesInCurrentDocument = (List)destination$iv$iv22;
        if (revisionPsiFile == null) {
            return rangesInCurrentDocument;
        }
        FileViewProvider fileViewProvider = revisionPsiFile.getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"revisionPsiFile.viewProvider");
        Document revisionDocument = fileViewProvider.getDocument();
        if (revisionDocument == null) {
            return rangesInCurrentDocument;
        }
        OffsetsInFile offsetsInFile = new OffsetsInFile(revisionPsiFile);
        boolean destination$iv$iv22 = false;
        List keys = new ArrayList();
        Iterable $this$forEachIndexed$iv = relevantResults;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void region;
            n2 = index$iv++;
            n = 0;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Region region2 = (Region)item$iv;
            int index = n2;
            boolean bl = false;
            OffsetKey start = OffsetKey.create((String)("START" + index));
            OffsetKey end = OffsetKey.create((String)("END" + index));
            keys.add(TuplesKt.to((Object)start, (Object)end));
            TextRange oldTextRange = ProblemsKt.toTextRange((Region)region, revisionDocument);
            if (oldTextRange == null) continue;
            offsetsInFile.getOffsets().addOffset(start, oldTextRange.getStartOffset());
            offsetsInFile.getOffsets().addOffset(end, oldTextRange.getEndOffset());
        }
        TextRange textRange2 = revisionPsiFile.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"revisionPsiFile.textRange");
        int n3 = textRange2.getEndOffset();
        String string = this.myFile.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myFile.text");
        OffsetMap newOffsets = offsetsInFile.copyWithReplacement(0, n3, string).getOffsets();
        int n4 = relevantResults.size();
        boolean bl = false;
        boolean bl2 = false;
        object = new ArrayList(n4);
        n2 = 0;
        n = 0;
        int n5 = n4;
        for (n = 0; n < n5; ++n) {
            void startKey;
            void index;
            int n6 = n;
            boolean bl3 = false;
            int start = n6;
            collection = object;
            boolean bl4 = false;
            Pair pair = (Pair)keys.get((int)index);
            OffsetKey offsetKey = (OffsetKey)pair.component1();
            OffsetKey endKey = (OffsetKey)pair.component2();
            textRange = newOffsets.containsOffset((OffsetKey)startKey) && newOffsets.containsOffset(endKey) ? new TextRange(newOffsets.getOffset((OffsetKey)startKey), newOffsets.getOffset(endKey)) : null;
            ((ArrayList)collection).add(textRange);
        }
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Region, Result>> collectRelevantResults(Iterable<? extends Result> results, String relativePath) {
        void $this$flatMapTo$iv$iv;
        Iterable<? extends Result> $this$flatMap$iv = results;
        boolean $i$f$flatMap = false;
        Iterable<? extends Result> iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            Result result = (Result)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = ProblemsKt.findRangesIn(result, relativePath);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void region;
                Region region2 = (Region)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                Pair pair = TuplesKt.to((Object)region, (Object)result);
                collection.add(pair);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public void doApplyInformationToEditor() {
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), (Collection)this.myInfos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    public QodanaReportHighlightingPass(@NotNull PsiFile myFile, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)myFile, (String)"myFile");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(myFile.getProject(), editor.getDocument());
        this.myFile = myFile;
        this.editor = editor;
        boolean bl = false;
        this.myInfos = new ArrayList();
    }

    public static final /* synthetic */ PsiFile access$getPsiFileByRevision(QodanaReportHighlightingPass $this, PsiFile myFile, String revisionId) {
        return $this.getPsiFileByRevision(myFile, revisionId);
    }

    public static final /* synthetic */ PsiFile access$getMyFile$p(QodanaReportHighlightingPass $this) {
        return $this.myFile;
    }

    public static final /* synthetic */ Editor access$getEditor$p(QodanaReportHighlightingPass $this) {
        return $this.editor;
    }

    public static final /* synthetic */ Project access$getMyProject$p(QodanaReportHighlightingPass $this) {
        return $this.myProject;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/qodana/highlight/QodanaReportHighlightingPass$Registrar;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.qodana"})
    public static final class Registrar
    implements TextEditorHighlightingPassFactory,
    TextEditorHighlightingPassFactoryRegistrar,
    DumbAware {
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
        }

        @NotNull
        public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return new QodanaReportHighlightingPass(file, editor);
        }
    }
}

