/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.merge.PerforceMergeProvider;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class ResolveAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ResolveAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(ResolveAction.isEnabled(e));
    }

    private static boolean isEnabled(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ResolveAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return false;
        }
        VirtualFile[] vFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (vFiles == null) {
            return false;
        }
        List<VirtualFile> selectedFiles = ResolveAction.getSelectedPerforceFiles(vFiles, project);
        if (selectedFiles.isEmpty() || ContainerUtil.exists(selectedFiles, it -> it.isDirectory())) {
            return false;
        }
        PerforceSettings perforceSettings = PerforceSettings.getSettings(project);
        if (!perforceSettings.ENABLED) {
            return false;
        }
        return !ResolveAction.getMergedFiles(project, selectedFiles).isEmpty();
    }

    static boolean serverSupportsConflictsResolve(@NotNull PerforceSettings perforceSettings, @NotNull Collection<P4Connection> connections) {
        if (perforceSettings == null) {
            ResolveAction.$$$reportNull$$$0(2);
        }
        if (connections == null) {
            ResolveAction.$$$reportNull$$$0(3);
        }
        try {
            for (P4Connection connection : connections) {
                long serverVersion = perforceSettings.getServerVersionCached(connection);
                if (serverVersion >= 2004L) continue;
                return false;
            }
            return true;
        }
        catch (VcsException e) {
            return false;
        }
    }

    private static List<VirtualFile> getSelectedPerforceFiles(VirtualFile @NotNull [] vFiles, @NotNull Project project) {
        if (project == null) {
            ResolveAction.$$$reportNull$$$0(4);
        }
        if (vFiles == null) {
            ResolveAction.$$$reportNull$$$0(5);
        }
        return ContainerUtil.filter((Object[])vFiles, file -> VcsUtil.getVcsFor((Project)project, (VirtualFile)file) instanceof PerforceVcs);
    }

    private static List<VirtualFile> getMergedFiles(Project project, List<VirtualFile> selectedFiles) {
        ArrayList<VirtualFile> merged = new ArrayList<VirtualFile>();
        for (VirtualFile file : selectedFiles) {
            FileStatus status = FileStatusManager.getInstance((Project)project).getStatus(file);
            if (status != FileStatus.MERGE && status != FileStatus.MERGED_WITH_CONFLICTS) continue;
            merged.add(file);
        }
        return merged;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Set connections;
        if (e == null) {
            ResolveAction.$$$reportNull$$$0(6);
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VirtualFile[] vFiles = (VirtualFile[])e.getRequiredData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        List<VirtualFile> selectedFiles = ResolveAction.getSelectedPerforceFiles(vFiles, project);
        PerforceSettings perforceSettings = PerforceSettings.getSettings(project);
        if (!ResolveAction.serverSupportsConflictsResolve(perforceSettings, connections = ContainerUtil.map2Set(selectedFiles, file -> perforceSettings.getConnectionForFile((VirtualFile)file)))) {
            Messages.showErrorDialog((Project)project, (String)PerforceBundle.message("message.server.cant.resolve.conflicts", new Object[0]), (String)PerforceBundle.message("message.title.resolve", new Object[0]));
            return;
        }
        new PerforceMergeProvider(project).showMergeDialog(ResolveAction.getMergedFiles(project, selectedFiles));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "perforceSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connections";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFiles";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/perforce/actions/ResolveAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "serverSupportsConflictsResolve";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectedPerforceFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

