/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.operations;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.operations.VcsOperationOnPath;
import org.jetbrains.idea.perforce.perforce.FStat;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceCachingContentRevision;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;

public class P4EditOperation
extends VcsOperationOnPath {
    private static final Logger LOG = Logger.getInstance(P4EditOperation.class);
    @NonNls
    private static final String CANNOT_FIND_ERROR = "the system cannot find";
    @NonNls
    private static final String CANNOT_FIND_ERROR_2 = "no such file or directory";
    private boolean mySuppressErrors;

    public P4EditOperation() {
    }

    public P4EditOperation(String changeList, VirtualFile file) {
        super(changeList, file.getPath());
    }

    public P4EditOperation(String changeList, String path) {
        super(changeList, path);
    }

    public boolean isSuppressErrors() {
        return this.mySuppressErrors;
    }

    public void setSuppressErrors(boolean suppressErrors) {
        this.mySuppressErrors = suppressErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Project project, ProcessingContext context) throws VcsException {
        Ref vcs = new Ref();
        Ref runner = new Ref();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed()) {
                return;
            }
            vcs.set((Object)PerforceVcs.getInstance(project));
            runner.set((Object)PerforceRunner.getInstance(project));
        });
        if (vcs.isNull()) {
            return;
        }
        try {
            P4File p4File = P4File.createInefficientFromLocalPath(this.myPath);
            FStat p4FStat = ((PerforceVcs)((Object)vcs.get())).getFstatSafe(p4File);
            if (p4FStat == null) {
                return;
            }
            if ((p4FStat.status == FStat.STATUS_NOT_ADDED || p4FStat.status == FStat.STATUS_ONLY_LOCAL) && p4FStat.local != FStat.LOCAL_BRANCHING) {
                throw new VcsException(PerforceBundle.message("confirmation.text.auto.edit.file.not.registered.on.server", p4File.getLocalPath()));
            }
            if (p4FStat.status == FStat.STATUS_DELETED) {
                throw new VcsException(PerforceBundle.message("exception.text.file.deleted.from.server.cannot.edit", p4File.getLocalPath()));
            }
            if (p4FStat.local == FStat.LOCAL_MOVE_DELETING) {
                return;
            }
            if (p4FStat.local != FStat.LOCAL_CHECKED_IN && p4FStat.local != FStat.LOCAL_INTEGRATING && p4FStat.local != FStat.LOCAL_BRANCHING) {
                throw new VcsException(PerforceBundle.message("exception.text.file..should.not.be.readonly.cannot.edit", p4File.getLocalPath()));
            }
            long changeListNumber = this.getPerforceChangeList(project, p4File, context);
            ((PerforceRunner)runner.get()).edit(p4File, changeListNumber);
        }
        catch (VcsException e) {
            if (this.mySuppressErrors) {
                LOG.debug((Throwable)e);
            } else {
                String message = StringUtil.toLowerCase((String)e.getMessage());
                if (!message.contains(CANNOT_FIND_ERROR) && !message.contains(CANNOT_FIND_ERROR_2)) {
                    throw e;
                }
            }
        }
        finally {
            VirtualFile vFile = this.getFilePath().getVirtualFile();
            if (vFile != null) {
                vFile.refresh(true, false);
                ((PerforceVcs)((Object)vcs.get())).asyncEditCompleted(vFile);
            }
        }
        FilePath filePath = this.getFilePath();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!project.isDisposed()) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(filePath);
            }
        });
    }

    @Override
    public Change getChange(Project project, ChangeListManagerGate addGate) {
        FilePath path = this.getFilePath();
        FileStatus status = addGate.getStatus(path);
        ContentRevision beforeRevision = FileStatus.ADDED.equals(status) ? null : PerforceCachingContentRevision.createOffline(project, path, path);
        ContentRevision afterRevision = CurrentContentRevision.create((FilePath)path);
        return new Change(beforeRevision, afterRevision);
    }
}

