/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.google.common.collect.Lists;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsConnectionProblem;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.FastUtilHashingStrategies;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.SyncDateFormat;
import com.intellij.vcsUtil.VcsUtil;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.ChangeListData;
import org.jetbrains.idea.perforce.ClientVersion;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.ServerVersion;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.FileGrouper;
import org.jetbrains.idea.perforce.application.LocalPathsSet;
import org.jetbrains.idea.perforce.application.PerforceClient;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceNumberNameSynchronizer;
import org.jetbrains.idea.perforce.application.PerforceShelf;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.application.PerforceVcsRevisionNumber;
import org.jetbrains.idea.perforce.application.ShelvedChange;
import org.jetbrains.idea.perforce.application.annotation.AnnotationInfo;
import org.jetbrains.idea.perforce.changesBrowser.FileChange;
import org.jetbrains.idea.perforce.merge.BaseRevision;
import org.jetbrains.idea.perforce.perforce.BranchSpec;
import org.jetbrains.idea.perforce.perforce.CommandArguments;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.FStat;
import org.jetbrains.idea.perforce.perforce.FormParser;
import org.jetbrains.idea.perforce.perforce.OutputMessageParser;
import org.jetbrains.idea.perforce.perforce.P4Command;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.P4HaveParser;
import org.jetbrains.idea.perforce.perforce.P4Revision;
import org.jetbrains.idea.perforce.perforce.P4WhereResult;
import org.jetbrains.idea.perforce.perforce.PathsHelper;
import org.jetbrains.idea.perforce.perforce.PerforceAuthenticationException;
import org.jetbrains.idea.perforce.perforce.PerforceChange;
import org.jetbrains.idea.perforce.perforce.PerforceChangeCache;
import org.jetbrains.idea.perforce.perforce.PerforceChangeList;
import org.jetbrains.idea.perforce.perforce.PerforceChangeListHelper;
import org.jetbrains.idea.perforce.perforce.PerforceContext;
import org.jetbrains.idea.perforce.perforce.PerforceOutputMessageParser;
import org.jetbrains.idea.perforce.perforce.PerforcePasswordNotAllowedException;
import org.jetbrains.idea.perforce.perforce.PerforceRunnerI;
import org.jetbrains.idea.perforce.perforce.PerforceRunnerProxy;
import org.jetbrains.idea.perforce.perforce.PerforceServerUnavailable;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.ResolvedFile;
import org.jetbrains.idea.perforce.perforce.WhereParser;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.connections.PerforceLocalConnection;
import org.jetbrains.idea.perforce.perforce.jobs.JobsSearchSpecificator;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJob;
import org.jetbrains.idea.perforce.perforce.login.LoginSupport;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;

@Service
public final class PerforceRunner
implements PerforceRunnerI {
    private final Project myProject;
    private final PerforceConnectionManagerI myConnectionManager;
    private final PerforceSettings mySettings;
    private final PerforceRunnerProxy myProxy;
    private static final int MAX_LOG_LENGTH = 10000000;
    private static final int OPENED_SIZE = 50;
    @NonNls
    static final String PASSWORD_INVALID_MESSAGE = "Perforce password (P4PASSWD) invalid or unset";
    @NlsSafe
    public static final String PASSWORD_INVALID_MESSAGE2 = "Password invalid.";
    @NonNls
    private static final String SESSION_EXPIRED_MESSAGE = "Your session has expired";
    @NonNls
    public static final String FILES_UP_TO_DATE = "file(s) up-to-date.";
    @NonNls
    private static final String PASSWORD_NOT_ALLOWED_MESSAGE = "Password not allowed at this server security level";
    @NonNls
    public static final String NO_SUCH_FILE_MESSAGE = " - no such file(s)";
    @NonNls
    private static final String STANDARD_REVERT_UNCHANGED_ERROR_MESSAGE = "file(s) not opened on this client";
    @NonNls
    private static final String YET_ANOTHER_STANDARD_REVERT_UNCHANGED_ERROR_MESSAGE = "file(s) not opened for edit.";
    @NonNls
    private static final String NO_FILES_TO_RESOLVE_MESSAGE = "no file(s) to resolve";
    @NonNls
    private static final String UBINARY_MERGING_MESSAGE = "- ubinary/ubinary merge ";
    @NonNls
    private static final String BINARY_MERGING_MESSAGE = "- binary/binary merge ";
    @NonNls
    private static final String MERGING_MESSAGE = "- merging ";
    @NonNls
    private static final String USING_BASE_MESSAGE = "using base";
    @NonNls
    public static final String NOT_UNDER_CLIENT_ROOT_MESSAGE = "is not under client's root";
    @NonNls
    public static final String NOT_IN_CLIENT_VIEW_MESSAGE = " - file(s) not in client view";
    @NonNls
    public static final String NOT_ON_CLIENT_MESSAGE = "file(s) not on client";
    @NonNls
    private static final String NO_FILES_RESOLVED_MESSAGE = "no file(s) resolved";
    @NonNls
    private static final String INVALID_REVISION_NUMBER = "Invalid revision number";
    @NonNls
    public static final String CHANGE = "Change:";
    @NonNls
    public static final String DATE = "Date:";
    @NonNls
    public static final String CLIENT = "Client:";
    @NonNls
    public static final String USER = "User:";
    @NonNls
    public static final String STATUS = "Status:";
    @NonNls
    public static final String DESCRIPTION = "Description:";
    @NonNls
    public static final String JOB = "Job:";
    @NonNls
    public static final String JOBS = "Jobs:";
    @NonNls
    public static final String FILES = "Files:";
    @NonNls
    public static final String OWNER = "Owner:";
    @NonNls
    public static final String VIEW = "View:";
    @NonNls
    public static final String TYPE = "Type:";
    @NonNls
    public static final String CLIENTSPEC_ROOT = "Root:";
    @NonNls
    public static final String CLIENTSPEC_ALTROOTS = "AltRoots:";
    @NonNls
    public static final String USER_NAME = "User name:";
    @NonNls
    public static final String CLIENT_NAME = "Client name:";
    @NonNls
    public static final String CLIENT_HOST = "Client host:";
    @NonNls
    public static final String CLIENT_ROOT = "Client root:";
    @NonNls
    public static final String CLIENT_UNKNOWN = "Client unknown.";
    @NonNls
    public static final String CURRENT_DIRECTORY = "Current directory:";
    @NonNls
    public static final String CLIENT_ADDRESS = "Client address:";
    @NonNls
    public static final String PEER_ADDRESS = "Client address:";
    @NonNls
    public static final String CLIENT_OPTIONS = "Options:";
    @NonNls
    public static final String SERVER_ADDRESS = "Server address:";
    @NonNls
    public static final String SERVER_ROOT = "Server root:";
    @NonNls
    public static final String SERVER_DATE = "Server date:";
    @NonNls
    public static final String SERVER_LICENSE = "Server license:";
    @NonNls
    public static final String SERVER_VERSION = "Server version:";
    @NonNls
    private static final SyncDateFormat DATESPEC_DATE_FORMAT = new SyncDateFormat((DateFormat)new SimpleDateFormat("yyyy/MM/dd:HH:mm:ss", Locale.US));
    @NonNls
    private static final String NOW = "now";
    @NonNls
    private static final String DEFAULT_CHANGELIST_NUMBER = "default";
    @NonNls
    public static final String CLIENT_FILE_PREFIX = "... clientFile ";
    private static final int CHUNK_SIZE = SystemProperties.getIntProperty((String)"p4.chunk.size", (int)2000);
    public static final String[] CHANGE_FORM_FIELDS = new String[]{"Change:", "Date:", "Client:", "User:", "Status:", "Type:", "Description:", "Jobs:", "Files:"};
    private static final String[] AVAILABLE_INFO = new String[]{"User name:", "Client name:", "Client host:", "Client root:", "Client unknown.", "Current directory:", "Client address:", "Server address:", "Client address:", "Server root:", "Server date:", "Server license:", "Server version:"};
    private static final Logger LOG = Logger.getInstance(PerforceRunner.class);
    private static final Logger SPECIFICATION_LOG = Logger.getInstance((String)"#PerforceJobSpecificationLogging");
    @NonNls
    private static final String DEFAULT_DESCRIPTION = "<none>";
    @NonNls
    private static final String DUMP_FILE_NAME = "p4output.log";
    private static final String CLIENT_VERSION_REV = "Rev.";
    private final PerforceManager myPerforceManager;
    private final LoginSupport myLoginManager;

    public static PerforceRunner getInstance(Project project) {
        return (PerforceRunner)project.getService(PerforceRunner.class);
    }

    public PerforceRunner(Project project) {
        this(PerforceConnectionManager.getInstance(project), PerforceSettings.getSettings(project), PerforceLoginManager.getInstance(project));
    }

    @NonInjectable
    public PerforceRunner(PerforceConnectionManagerI connectionManager, PerforceSettings settings, LoginSupport loginManager) {
        this.myProject = settings.getProject();
        this.myConnectionManager = connectionManager;
        this.mySettings = settings;
        this.myPerforceManager = PerforceManager.getInstance(this.myProject);
        this.myLoginManager = loginManager;
        this.myProxy = new PerforceRunnerProxy(this.myProject, this);
    }

    public PerforceRunnerI getProxy() {
        return this.myProxy.getProxy();
    }

    public Map<String, List<String>> getInfo(@NotNull P4Connection connection) throws VcsException {
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(0);
        }
        @NonNls String[] p4args = new String[]{"info"};
        ExecResult execResult = this.executeP4Command(p4args, connection);
        this.checkError(execResult, connection);
        return FormParser.execute(execResult.getStdout(), AVAILABLE_INFO, CLIENT_UNKNOWN);
    }

    @Nullable
    public String getClient(@Nullable P4Connection connection) throws VcsException {
        if (connection == null) {
            return null;
        }
        List<String> clientNames = this.getInfo(connection).get(CLIENT_NAME);
        return clientNames == null ? null : clientNames.get(0);
    }

    @Override
    public void edit(P4File file) throws VcsException {
        P4Connection connection = this.myConnectionManager.getConnectionForFile(file);
        this.edit(file, this.getActiveListNumber(connection));
    }

    public void edit(P4File file, long changeListNumber) throws VcsException {
        this.edit(file, changeListNumber, false);
    }

    public void edit(P4File file, long changeListNumber, boolean keepWorkspace) throws VcsException {
        P4Connection connection = this.getNotNullConnection(file);
        this.editAll(ContainerUtil.newArrayList((Object[])new P4File[]{file}), changeListNumber, keepWorkspace, connection);
    }

    /*
     * WARNING - void declaration
     */
    public void editAll(List<P4File> files, long changeListNumber, boolean keepWorkspace, @NotNull P4Connection p4Connection) throws VcsException {
        void connection;
        if (p4Connection == null) {
            PerforceRunner.$$$reportNull$$$0(1);
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (P4File file : files) {
            file.invalidateFstat();
            paths.add(file.getEscapedPath());
        }
        CommandArguments arguments = CommandArguments.createOn(P4Command.edit);
        if (keepWorkspace) {
            arguments.append("-k");
        }
        PerforceRunner.appendChangeListNumber(changeListNumber, arguments);
        ExecResult execResult = this.executeP4Command(arguments.getArguments(), paths, null, new PerforceContext((P4Connection)connection));
        this.checkError(execResult, (P4Connection)connection);
    }

    @NotNull
    private P4Connection getNotNullConnection(P4File file) throws VcsException {
        P4Connection connection = this.myConnectionManager.getConnectionForFile(file);
        if (connection == null) {
            throw new VcsException(PerforceBundle.message("error.no.connection.for.file", file.getLocalPath()));
        }
        P4Connection p4Connection = connection;
        if (p4Connection == null) {
            PerforceRunner.$$$reportNull$$$0(2);
        }
        return p4Connection;
    }

    private static void appendChangeListNumber(long changeListNumber, CommandArguments arguments) {
        if (changeListNumber > 0L) {
            arguments.append("-c").append(String.valueOf(changeListNumber));
        }
    }

    public Map<P4File, FStat> fstatBulk(List<P4File> files) throws VcsException {
        if (files.isEmpty()) {
            return Collections.emptyMap();
        }
        P4Connection connection = this.getNotNullConnection(files.get(0));
        LinkedHashSet<String> p4Args = new LinkedHashSet<String>();
        for (P4File file : files) {
            p4Args.add(file.getEscapedPath());
        }
        ExecResult execResult = this.executeP4Command(new String[]{"fstat"}, p4Args, null, new PerforceContext(connection));
        LinkedHashMap<P4File, FStat> result = new LinkedHashMap<P4File, FStat>();
        String stderr = execResult.getStderr();
        Map path2File = CollectionFactory.createFilePathMap();
        for (P4File file : files) {
            path2File.put(FileUtil.toSystemIndependentName((String)file.getLocalPath()), file);
        }
        for (String line : StringUtil.splitByLines((String)stderr)) {
            int index = line.indexOf(NO_SUCH_FILE_MESSAGE);
            if (index < 0) {
                index = line.indexOf(NOT_IN_CLIENT_VIEW_MESSAGE);
            }
            if (index >= 0) {
                FStat fStat = new FStat();
                fStat.status = line.contains(NO_SUCH_FILE_MESSAGE) ? FStat.Status.NOT_ADDED : FStat.Status.NOT_IN_CLIENTSPEC;
                result.put(PerforceRunner.getP4FileByPath(line.substring(0, index), path2File), fStat);
                continue;
            }
            this.checkError(execResult, connection);
        }
        try {
            execResult.allowSafeStdoutUsage((ThrowableConsumer<InputStream, IOException>)((ThrowableConsumer)stream -> {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
                try {
                    FStat fStat;
                    while ((fStat = FStat.parseFStat(reader)) != null) {
                        result.put(PerforceRunner.getP4FileByPath(fStat.clientFile, path2File), fStat);
                    }
                }
                catch (VcsException e) {
                    throw new IOException(e);
                }
            }));
        }
        catch (IOException e) {
            if (e.getCause() instanceof VcsException) {
                throw (VcsException)e.getCause();
            }
            throw new VcsException((Throwable)e);
        }
        return result;
    }

    private static P4File getP4FileByPath(String path, Map<String, P4File> path2File) throws VcsException {
        String clientFile = P4File.unescapeWildcards(FileUtil.toSystemIndependentName((String)path));
        P4File p4File = path2File.get(clientFile);
        if (p4File == null) {
            throw new VcsException(PerforceBundle.message("error.invalid.file.fstat.mapping", clientFile, new ArrayList<String>(path2File.keySet())));
        }
        return p4File;
    }

    @Override
    public FStat fstat(P4File p4File) throws VcsException {
        Map<P4File, FStat> map = this.fstatBulk(Collections.singletonList(p4File));
        FStat result = map.get(p4File);
        if (result == null) {
            throw new VcsException(PerforceBundle.message("error.no.fstat.for.file", p4File, map));
        }
        return result;
    }

    public void revertAll(List<String> files, @NotNull P4Connection connection) throws VcsException {
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(3);
        }
        CommandArguments arguments = CommandArguments.createOn(P4Command.revert);
        this.checkError(this.executeP4Command(arguments.getArguments(), files, null, new PerforceContext(connection)), connection);
    }

    @Override
    public void revert(P4File p4File, boolean justTry) throws VcsException {
        p4File.invalidateFstat();
        CommandArguments arguments = CommandArguments.createOn(P4Command.revert).append(p4File.getEscapedPath());
        P4Connection connection = this.getNotNullConnection(p4File);
        ExecResult execResult = this.executeP4Command(arguments.getArguments(), connection);
        if (!justTry) {
            this.checkError(execResult, connection);
        }
    }

    public void revertUnchanged(@NotNull P4Connection connection, Collection<String> files) throws VcsException {
        ExecResult execResult;
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(4);
        }
        if (!(execResult = this.executeP4Command(new String[]{"revert", "-a"}, files, null, new PerforceContext(connection))).getStderr().contains(STANDARD_REVERT_UNCHANGED_ERROR_MESSAGE) && !execResult.getStderr().contains(YET_ANOTHER_STANDARD_REVERT_UNCHANGED_ERROR_MESSAGE)) {
            this.checkError(execResult, connection);
        }
    }

    public void revertUnchanged(P4Connection connection, long changeListNumber) throws VcsException {
        String changeListNum = changeListNumber == -1L ? DEFAULT_CHANGELIST_NUMBER : String.valueOf(changeListNumber);
        ExecResult execResult = this.executeP4Command(new String[]{"revert", "-a", "-c", changeListNum}, connection);
        if (!execResult.getStderr().contains(STANDARD_REVERT_UNCHANGED_ERROR_MESSAGE) && !execResult.getStderr().contains(YET_ANOTHER_STANDARD_REVERT_UNCHANGED_ERROR_MESSAGE)) {
            this.checkError(execResult, connection);
        }
    }

    private long getActiveListNumber(@Nullable P4Connection connection) throws VcsException {
        if (connection == null) {
            return -1L;
        }
        PerforceManager.ensureValidClient(this.myProject, connection);
        LocalChangeList activeList = ChangeListManager.getInstance((Project)this.myProject).getDefaultChangeList();
        ConnectionKey connectionKey = connection.getConnectionKey();
        Long number = PerforceNumberNameSynchronizer.getInstance(this.myProject).getNumber(connectionKey, activeList.getName());
        return number == null ? -1L : number;
    }

    public void add(P4File p4File) throws VcsException {
        P4Connection connection = this.myConnectionManager.getConnectionForFile(p4File);
        this.add(p4File, this.getActiveListNumber(connection));
    }

    public void add(P4File p4File, long changeListNumber) throws VcsException {
        p4File.invalidateFstat();
        CommandArguments arguments = CommandArguments.createOn(P4Command.add);
        if (PerforceVcs.getFileNameComplaint(p4File) != null) {
            arguments.append("-f");
        }
        P4Connection connection = this.getNotNullConnection(p4File);
        PerforceRunner.appendChangeListNumber(changeListNumber, arguments);
        arguments.append(p4File.getLocalPath());
        ExecResult execResult = this.executeP4Command(arguments.getArguments(), connection);
        this.checkError(execResult, connection);
    }

    public ExecResult previewAdd(@NotNull P4Connection connection, Collection<VirtualFile> files) {
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(5);
        }
        CommandArguments arguments = CommandArguments.createOn(P4Command.add).append("-f").append("-n");
        ArrayList<String> paths = new ArrayList<String>();
        for (VirtualFile file : files) {
            paths.add(VfsUtilCore.virtualToIoFile((VirtualFile)file).getPath());
        }
        return this.executeP4Command(arguments.getArguments(), paths, null, new PerforceContext(connection));
    }

    public ExecResult ignores(@NotNull P4Connection connection, Collection<VirtualFile> files) {
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(6);
        }
        CommandArguments arguments = CommandArguments.createOn(P4Command.ignores).append("-i");
        File cwd = connection.getWorkingDirectory();
        for (VirtualFile file : files) {
            String relativePath = FileUtil.getRelativePath((File)cwd, (File)VfsUtilCore.virtualToIoFile((VirtualFile)file));
            if (relativePath == null) continue;
            arguments.append(relativePath);
        }
        return this.executeP4Command(arguments.getArguments(), connection);
    }

    @Override
    public ExecResult sync(P4File p4File, boolean forceSync) throws VcsException {
        return this.doSync(p4File, forceSync ? "-f" : null);
    }

    public ExecResult previewSync(P4File p4File) throws VcsException {
        return this.doSync(p4File, "-n");
    }

    private ExecResult doSync(P4File p4File, @Nullable @NonNls String arg) throws VcsException {
        p4File.invalidateFstat();
        P4Connection connection = this.getNotNullConnection(p4File);
        CommandArguments arguments = CommandArguments.createOn(P4Command.sync);
        if (arg != null) {
            arguments.append(arg);
        }
        arguments.append(p4File.getRecursivePath());
        return this.executeP4Command(arguments.getArguments(), Collections.emptyList(), null, new PerforceContext(connection, true, false));
    }

    public ExecResult sync(P4File p4File, String revision) throws VcsException {
        p4File.invalidateFstat();
        P4Connection connection = this.getNotNullConnection(p4File);
        CommandArguments arguments = CommandArguments.createOn(P4Command.sync).append(p4File.getRecursivePath() + "@" + revision);
        return this.executeP4Command(arguments.getArguments(), Collections.emptyList(), null, new PerforceContext(connection, true, false));
    }

    public void assureDel(P4File p4File, @Nullable Long changeList) throws VcsException {
        ArrayList<File> filesToDelete = new ArrayList<File>();
        for (File f = p4File.getLocalFile(); f != null && !f.exists(); f = f.getParentFile()) {
            filesToDelete.add(f);
        }
        FStat fstat = p4File.getFstat(this.myProject, true);
        if (fstat.status != FStat.STATUS_NOT_ADDED && fstat.status != FStat.STATUS_NOT_IN_CLIENTSPEC && fstat.local != FStat.LOCAL_DELETING && fstat.local != FStat.LOCAL_MOVE_DELETING) {
            if (fstat.local == FStat.LOCAL_ADDING || fstat.local == FStat.LOCAL_MOVE_ADDING) {
                this.revert(p4File, false);
            } else if (fstat.local == FStat.LOCAL_CHECKED_IN) {
                if (changeList == null) {
                    this.delete(p4File);
                } else {
                    this.delete(p4File, changeList);
                }
            } else {
                this.revert(p4File, false);
                try {
                    if (changeList == null) {
                        this.delete(p4File);
                    } else {
                        this.delete(p4File, changeList);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        for (File file : filesToDelete) {
            boolean res;
            if (!file.exists() || (res = file.delete())) continue;
            throw new VcsException(PerforceBundle.message("exception.text.cannot.delete.local.file", file));
        }
    }

    private void delete(P4File p4File) throws VcsException {
        P4Connection connection = this.myConnectionManager.getConnectionForFile(p4File);
        this.delete(p4File, this.getActiveListNumber(connection));
    }

    private void delete(P4File p4File, long changeListNumber) throws VcsException {
        p4File.invalidateFstat();
        CommandArguments arguments = CommandArguments.createOn(P4Command.delete);
        P4Connection connection = this.getNotNullConnection(p4File);
        PerforceRunner.appendChangeListNumber(changeListNumber, arguments);
        arguments.append(p4File.getEscapedPath());
        ExecResult execResult = this.executeP4Command(arguments.getArguments(), connection);
        this.checkError(execResult, connection);
    }

    public void integrate(P4File oldP4File, P4File newP4File) throws VcsException {
        P4Connection connection = this.myConnectionManager.getConnectionForFile(oldP4File);
        this.integrate(oldP4File, newP4File, this.getActiveListNumber(connection));
    }

    public void integrate(P4File oldP4File, P4File newP4File, long changeListNumber) throws VcsException {
        P4Connection connection = this.getNotNullConnection(oldP4File);
        oldP4File.invalidateFstat();
        newP4File.invalidateFstat();
        CommandArguments arguments = CommandArguments.createOn(P4Command.integrate);
        PerforceRunner.appendChangeListNumber(changeListNumber, arguments);
        arguments.append("-d");
        arguments.append(oldP4File.getEscapedPath()).append(newP4File.getEscapedPath());
        ExecResult execResult = this.executeP4Command(arguments.getArguments(), connection);
        this.checkError(execResult, connection);
    }

    public void reopen(File[] selectedFiles, long changeListNumber) throws VcsException {
        CommandArguments arguments = CommandArguments.createOn(P4Command.reopen);
        arguments.append("-c");
        if (changeListNumber > 0L) {
            arguments.append(String.valueOf(changeListNumber));
        } else {
            arguments.append(DEFAULT_CHANGELIST_NUMBER);
        }
        MultiMap<P4Connection, File> connectionToFile = FileGrouper.distributeIoFilesByConnection(Arrays.asList(selectedFiles), this.mySettings.getProject());
        this.executeFileCommands(arguments, connectionToFile);
    }

    private void executeFileCommands(CommandArguments arguments, MultiMap<P4Connection, File> connectionToFile) throws VcsException {
        for (P4Connection connection : connectionToFile.keySet()) {
            CommandArguments connectionArguments = arguments.createCopy();
            for (File selectedFile : connectionToFile.get((Object)connection)) {
                connectionArguments.append(P4File.escapeWildcards(selectedFile.getPath()));
            }
            ExecResult execResult = this.executeP4Command(connectionArguments.getArguments(), connection);
            this.checkError(execResult, connection);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void reopen(@NotNull P4Connection connection, long targetChangeListNumber, List<String> list) throws VcsException {
        void paths;
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(7);
        }
        CommandArguments arguments = CommandArguments.createOn(P4Command.reopen);
        arguments.append("-c");
        if (targetChangeListNumber > 0L) {
            arguments.append(String.valueOf(targetChangeListNumber));
        } else {
            arguments.append(DEFAULT_CHANGELIST_NUMBER);
        }
        this.checkError(this.executeP4Command(arguments.getArguments(), (Collection<String>)paths, null, new PerforceContext(connection)), connection);
    }

    public List<String> getClients(P4Connection connection) throws VcsException {
        ExecResult execResult = this.executeP4Command(new String[]{P4Command.clients.getName()}, connection);
        this.checkError(execResult, connection);
        return OutputMessageParser.processClientsOutput(execResult.getStdout());
    }

    public List<String> getUsers(P4Connection connection) throws VcsException {
        ExecResult execResult = this.executeP4Command(new String[]{P4Command.users.getName()}, connection);
        this.checkError(execResult, connection);
        return OutputMessageParser.processUsersOutput(execResult.getStdout());
    }

    public List<PerforceChange> getChanges(P4Connection connection, long changeListNumber) throws VcsException {
        PerforceClient client = this.myPerforceManager.getClient(connection);
        if (LOG.isDebugEnabled()) {
            LOG.debug("connection = " + connection + ", changeListNumber = " + changeListNumber);
        }
        if (changeListNumber != -1L) {
            Pair<ChangeListData, List<FileChange>> pair = this.describeAll(connection, Collections.singletonList(changeListNumber), false).values().iterator().next();
            return PerforceRunner.createPerforceChanges(client, (ChangeListData)pair.first, (List)pair.second);
        }
        ArrayList<PerforceChange> result = new ArrayList<PerforceChange>();
        Map<String, List<String>> form = this.getChangeSpec(connection, changeListNumber);
        List<String> strings = form.get(FILES);
        if (strings != null) {
            for (String s : strings) {
                ContainerUtil.addIfNotNull(result, (Object)PerforceChange.createOn(s, client, changeListNumber, PerforceRunner.getDescription(form)));
            }
        }
        return result;
    }

    private Map<Long, Pair<ChangeListData, List<FileChange>>> describeAll(P4Connection connection, List<Long> lists, boolean shelved) throws VcsException {
        CommandArguments args = CommandArguments.createOn(P4Command.describe);
        args.append("-s");
        if (shelved) {
            args.append("-S");
        }
        for (Long list : lists) {
            args.append(list);
        }
        ExecResult execResult = this.executeP4Command(args.getArguments(), connection);
        this.checkError(execResult, connection);
        ProgressManager.checkCanceled();
        String stdout = execResult.getStdout();
        Map<ChangeListData, List<FileChange>> map = OutputMessageParser.processMultiDescriptionOutput(stdout, shelved);
        HashMap<Long, Pair<ChangeListData, List<FileChange>>> result = new HashMap<Long, Pair<ChangeListData, List<FileChange>>>();
        for (ChangeListData data : map.keySet()) {
            result.put(data.NUMBER, (Pair<ChangeListData, List<FileChange>>)Pair.create((Object)data, map.get(data)));
        }
        return result;
    }

    @NotNull
    private static List<PerforceChange> createPerforceChanges(PerforceClient client, ChangeListData data, List<FileChange> changes) throws VcsException {
        ArrayList<PerforceChange> converted = new ArrayList<PerforceChange>();
        for (FileChange fileChange : changes) {
            ProgressManager.checkCanceled();
            File localFile = PerforceManager.getFileByDepotName(fileChange.getDepotPath(), client);
            converted.add(new PerforceChange(fileChange.getType(), localFile, fileChange.getDepotPath(), fileChange.getRevisionAfter(), data.NUMBER, data.DESCRIPTION));
        }
        ArrayList<PerforceChange> arrayList = converted;
        if (arrayList == null) {
            PerforceRunner.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private Map<String, List<String>> getChangeSpec(P4Connection connection, long changeListNumber) throws VcsException {
        CommandArguments arguments = CommandArguments.createOn(P4Command.change);
        arguments.append("-o");
        if (changeListNumber > 0L) {
            arguments.append(String.valueOf(changeListNumber));
        }
        ExecResult execResult = this.executeP4Command(arguments.getArguments(), connection);
        this.checkError(execResult, connection);
        String stdout = execResult.getStdout();
        return FormParser.execute(stdout, CHANGE_FORM_FIELDS);
    }

    public List<PerforceChangeList> getPendingChangeLists(P4Connection connection) throws VcsException {
        PerforceClient client = this.myPerforceManager.getClient(connection);
        CommandArguments args = CommandArguments.createOn(P4Command.changes);
        args.append("-i");
        this.appendTArg(args, connection);
        args.append("-l").append("-s").append("pending");
        PerforceRunner.appendUserName(client, args);
        PerforceRunner.appendClientName(client, args);
        ExecResult execResult = this.executeP4Command(args.getArguments(), connection);
        this.checkError(execResult, connection);
        return this.parsePerforceChangeLists(execResult.getStdout(), connection, new PerforceChangeCache(this.myProject));
    }

    public void setChangeRevisionsFromHave(P4Connection connection, List<PerforceChange> result) throws VcsException {
        ArrayList<FilePath> files = new ArrayList<FilePath>();
        for (PerforceChange perforceChange : result) {
            File file = perforceChange.getFile();
            if (file == null) continue;
            files.add(VcsUtil.getFilePath((File)file, (boolean)false));
        }
        Object2LongOpenCustomHashMap haveRevisions = new Object2LongOpenCustomHashMap(SystemInfoRt.isFileSystemCaseSensitive ? FastUtilHashingStrategies.getCaseInsensitiveStringStrategy() : FastUtilHashingStrategies.getCanonicalStrategy());
        PathsHelper pathsHelper = new PathsHelper(this.myPerforceManager);
        pathsHelper.addAllPaths(files);
        this.haveMultiple(pathsHelper, connection, new P4HaveParser.RevisionCollector(this.myPerforceManager, (Object2LongMap<String>)haveRevisions));
        for (PerforceChange change : result) {
            String path;
            long revision;
            File file = change.getFile();
            if (file == null || (revision = haveRevisions.getLong((Object)FileUtil.toSystemDependentName((String)(path = file.getAbsolutePath())))) == 0L) continue;
            change.setRevision(revision);
        }
    }

    public List<PerforceChangeList> getPendingChangeLists(P4Connection connection, PerforceChangeCache changeCache) throws VcsException {
        PerforceClient client = this.myPerforceManager.getClient(connection);
        CommandArguments args = CommandArguments.createOn(P4Command.changes);
        args.append("-i");
        this.appendTArg(args, connection);
        args.append("-l").append("-s").append("pending");
        PerforceRunner.appendUserName(client, args);
        PerforceRunner.appendClientName(client, args);
        ExecResult execResult = this.executeP4Command(args.getArguments(), connection);
        this.checkError(execResult, connection);
        return this.parsePerforceChangeLists(execResult.getStdout(), connection, changeCache);
    }

    public void fillChangeCache(P4Connection connection, PerforceChangeCache changeCache, PerforceShelf shelf, List<PerforceChangeList> lists) throws VcsException {
        List numbers = ContainerUtil.map2List(lists, list -> list.getNumber());
        PerforceClient client = this.myPerforceManager.getClient(connection);
        Map<Long, Pair<ChangeListData, List<FileChange>>> changeMap = this.describeAll(connection, numbers, false);
        for (PerforceChangeList list2 : lists) {
            Pair<ChangeListData, List<FileChange>> changes = changeMap.get(list2.getNumber());
            if (changes == null) continue;
            changeCache.setChanges(connection, list2.getNumber(), PerforceRunner.createPerforceChanges(client, (ChangeListData)changes.first, (List)changes.second));
        }
        ServerVersion serverVersion = PerforceManager.getInstance(this.myProject).getServerVersion(connection);
        if (serverVersion != null && serverVersion.supportsShelve()) {
            Map<Long, Pair<ChangeListData, List<FileChange>>> shelveMap = this.describeAll(connection, numbers, true);
            for (Long cl : shelveMap.keySet()) {
                for (FileChange c : (List)shelveMap.get((Object)cl).second) {
                    File localFile = PerforceManager.getFileByDepotName(c.getDepotPath(), client);
                    shelf.addShelvedChange(connection, cl, new ShelvedChange(c.getType(), c.getDepotPath(), c.getRevisionAfter(), connection, localFile, cl));
                }
            }
        }
    }

    private void appendTArg(CommandArguments arguments, @Nullable P4Connection connection) throws VcsException {
        if (this.mySettings.getServerVersion(connection) >= 2003L) {
            arguments.append("-t");
        }
    }

    private static CommandArguments appendUserName(PerforceClient client, CommandArguments args) throws VcsException {
        String userName = client.getUserName();
        return userName != null ? args.append("-u").append(userName) : args;
    }

    private static CommandArguments appendClientName(PerforceClient client, CommandArguments args) throws VcsException {
        String userName = client.getName();
        return userName != null ? args.append("-c").append(userName) : args;
    }

    private List<PerforceChangeList> parsePerforceChangeLists(String stdout, P4Connection connection, @NotNull PerforceChangeCache changeCache) {
        if (changeCache == null) {
            PerforceRunner.$$$reportNull$$$0(9);
        }
        ArrayList<PerforceChangeList> result = new ArrayList<PerforceChangeList>();
        for (ChangeListData data : OutputMessageParser.processChangesOutput(stdout)) {
            result.add(new PerforceChangeList(data, this.myProject, connection, changeCache));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public boolean deleteChangeList(@NotNull P4Connection connection, long number, boolean acceptUnknown, boolean acceptNonEmpty, boolean bl) throws VcsException {
        void acceptShelved;
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(10);
        }
        CommandArguments arguments = CommandArguments.createOn(P4Command.change);
        arguments.append("-d");
        arguments.append(String.valueOf(number));
        ExecResult execResult = this.executeP4Command(arguments.getArguments(), connection);
        if (execResult.getExitCode() == 0) {
            return true;
        }
        String stderr = execResult.getStderr();
        if (acceptUnknown && stderr.contains("Change " + number + " unknown.") || acceptNonEmpty && stderr.contains("open file(s) associated with it and can't be deleted") || acceptShelved != false && stderr.contains("shelved files associated with it and can't be deleted")) {
            return false;
        }
        this.checkError(execResult, connection);
        return false;
    }

    private static void adjustJobs(P4Connection connection, Map<String, List<String>> changeForm, @Nullable List<PerforceJob> p4jobs) {
        changeForm.remove(JOBS);
        if (p4jobs != null && !p4jobs.isEmpty()) {
            ArrayList<String> values = new ArrayList<String>();
            for (PerforceJob p4job : p4jobs) {
                if (!connection.getId().equals(p4job.getConnection().getId())) continue;
                values.add(p4job.getName());
            }
            changeForm.put(JOBS, values);
        }
    }

    /*
     * WARNING - void declaration
     */
    public long submitForConnection(@NotNull P4Connection connection, List<PerforceChange> changesForConnection, long changeListNumber, String preparedComment, @Nullable List<PerforceJob> list) throws VcsException {
        long submittedRevision;
        void p4jobs;
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(11);
        }
        ArrayList<String> excludedChanges = new ArrayList<String>();
        Map<String, List<String>> changeForm = this.getChangeSpec(connection, changeListNumber);
        String originalDescription = PerforceRunner.getDescription(changeForm);
        PerforceRunner.adjustJobs(connection, changeForm, (List<PerforceJob>)p4jobs);
        StringBuffer changeData = PerforceRunner.createChangeData(preparedComment, changesForConnection, changeForm, excludedChanges);
        long newNumber = -1L;
        if (changeListNumber == -1L) {
            CommandArguments arguments = CommandArguments.createOn(P4Command.submit);
            PerforceRunner.appendChangeListNumber(changeListNumber, arguments);
            arguments.append("-i");
            ExecResult execResult = this.executeP4Command(arguments.getArguments(), changeData, connection);
            this.checkError(execResult, connection);
            submittedRevision = PerforceRunner.getSubmittedRevisionNumber(execResult, "Change (\\d+) created with ", 1);
        } else {
            CommandArguments arguments = CommandArguments.createOn(P4Command.change);
            arguments.append("-i");
            this.checkError(connection.runP4CommandLine(this.mySettings, arguments.getArguments(), changeData), connection);
            arguments = CommandArguments.createOn(P4Command.submit);
            PerforceRunner.appendChangeListNumber(changeListNumber, arguments);
            ExecResult execResult = this.executeP4Command(arguments.getArguments(), connection);
            this.checkError(execResult, connection);
            submittedRevision = PerforceRunner.getSubmittedRevisionNumber(execResult, "Change (\\d+) renamed change (\\d+) and ", 2);
            if (!excludedChanges.isEmpty()) {
                LOG.debug("Reopening excluded changes in new changelist");
                newNumber = this.createChangeList(originalDescription, connection, excludedChanges);
            }
        }
        PerforceNumberNameSynchronizer.getInstance(this.myProject).handleChangeListSubmitted(connection, changeListNumber, newNumber);
        return submittedRevision;
    }

    private static long getSubmittedRevisionNumber(ExecResult execResult, String regex, int groupNumber) {
        Matcher matcher = Pattern.compile(regex).matcher(execResult.getStdout());
        if (matcher.find()) {
            String group = matcher.group(groupNumber);
            try {
                return Long.parseLong(group);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    public long createChangeList(String description, @NotNull P4Connection connection, @Nullable List<String> files) throws VcsException {
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(12);
        }
        String changeListForm = this.createChangeListForm(description, -1L, connection, files, this.myPerforceManager.getClient(connection));
        if (this.mySettings.showCmds) {
            PerforceRunner.logMessage(changeListForm);
        }
        ExecResult execResult = this.executeP4Command(new String[]{P4Command.change.getName(), "-i"}, new StringBuffer(changeListForm), connection);
        this.checkError(execResult, connection);
        return PerforceChangeListHelper.parseCreatedListNumber(execResult.getStdout());
    }

    /*
     * WARNING - void declaration
     */
    public void renameChangeList(long number, String description, @NotNull P4Connection p4Connection) throws VcsException {
        void connection;
        if (p4Connection == null) {
            PerforceRunner.$$$reportNull$$$0(13);
        }
        Map<String, List<String>> oldSpec = this.getChangeSpec((P4Connection)connection, number);
        oldSpec.put(DESCRIPTION, PerforceRunner.processDescription(description));
        ExecResult execResult = this.executeP4Command(new String[]{P4Command.change.getName(), "-i"}, PerforceRunner.createStringFormRepresentation(oldSpec), (P4Connection)connection);
        this.checkError(execResult, (P4Connection)connection);
    }

    public static List<String> processDescription(String description) {
        ArrayList<String> result = new ArrayList<String>();
        String[] lines = StringUtil.convertLineSeparators((String)description).split("\n");
        if (lines.length == 0) {
            result.add(DEFAULT_DESCRIPTION);
        } else {
            Collections.addAll(result, lines);
        }
        return result;
    }

    private String createChangeListForm(String description, long changeListNumber, P4Connection connection, @Nullable List<String> files, PerforceClient client) throws VcsException {
        StringBuilder result;
        block9: {
            result = new StringBuilder();
            result.append("Change:\t");
            if (changeListNumber == -1L) {
                result.append("new");
            } else {
                result.append(changeListNumber);
            }
            result.append("\n\nClient:\t");
            result.append(client.getName());
            result.append("\n\nUser:\t");
            result.append(client.getUserName());
            result.append("\n\nStatus:\t");
            if (changeListNumber == -1L) {
                result.append("new");
            } else {
                result.append("pending");
            }
            result.append("\n\nDescription:");
            List<String> descriptionLines = PerforceRunner.processDescription(description);
            for (String line : descriptionLines) {
                result.append("\n\t").append(line);
            }
            if (changeListNumber == -1L && files == null) break block9;
            result.append("\n\nFiles:\n");
            if (files != null) {
                for (String file : files) {
                    result.append("\t").append(file).append("\n");
                }
            } else {
                List<PerforceChange> list = this.openedInList(connection, changeListNumber);
                for (PerforceChange openedFile : list) {
                    result.append("\t").append(openedFile.getDepotPath()).append("\n");
                }
            }
        }
        return result.toString();
    }

    public List<PerforceChangeList> getSubmittedChangeLists(@Nullable String client, @Nullable String user, @NotNull P4File rootP4File, @NotNull ChangeBrowserSettings settings, int maxCount, boolean showIntegrated) throws VcsException {
        if (rootP4File == null) {
            PerforceRunner.$$$reportNull$$$0(14);
        }
        if (settings == null) {
            PerforceRunner.$$$reportNull$$$0(15);
        }
        String interval = PerforceRunner.dateSpec(settings.getDateAfterFilter(), settings.getDateBeforeFilter(), settings.getChangeAfterFilter(), settings.getChangeBeforeFilter(), settings.STRICTLY_AFTER);
        ArrayList fileSpecs = ContainerUtil.newArrayList((Object[])new String[]{rootP4File.getRecursivePath() + interval});
        return this.getSubmittedChangeLists(this.getNotNullConnection(rootP4File), client, user, maxCount, showIntegrated, fileSpecs);
    }

    public List<PerforceChangeList> getSubmittedChangeLists(@NotNull P4Connection connection, @Nullable String client, @Nullable String user, int maxCount, boolean showIntegrated, List<String> fileSpecs) throws VcsException {
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(16);
        }
        CommandArguments arguments = CommandArguments.createOn(P4Command.changes);
        arguments.append("-s").append("submitted");
        if (showIntegrated) {
            arguments.append("-i");
        }
        this.appendTArg(arguments, connection);
        arguments.append("-l");
        if (client != null && client.length() > 0) {
            arguments.append("-c").append(client);
        }
        if (user != null && user.length() > 0) {
            arguments.append("-u").append(user);
        }
        if (maxCount > 0) {
            arguments.append("-m").append(maxCount);
        }
        for (String spec : fileSpecs) {
            arguments.append(spec);
        }
        ExecResult execResult = this.executeP4Command(arguments.getArguments(), connection);
        this.checkError(execResult, connection);
        return this.parsePerforceChangeLists(execResult.getStdout(), connection, new PerforceChangeCache(this.myProject));
    }

    private static String dateSpec(Date after, Date before, Long afterChange, Long beforeChange, boolean strictlyAfter) {
        if (after == null && before == null && afterChange == null && beforeChange == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append('@');
        if (after != null) {
            result.append(DATESPEC_DATE_FORMAT.format(after));
        } else if (afterChange != null) {
            result.append(afterChange + (long)(strictlyAfter ? 1 : 0));
        } else {
            result.append(DATESPEC_DATE_FORMAT.format(new Date(0L)));
        }
        result.append(',');
        result.append('@');
        if (before != null) {
            result.append(DATESPEC_DATE_FORMAT.format(before));
        } else if (beforeChange != null) {
            result.append(beforeChange);
        } else {
            result.append(NOW);
        }
        return result.toString();
    }

    public List<PerforceChange> openedInList(P4Connection connection, long number) throws VcsException {
        CommandArguments args = CommandArguments.createOn(P4Command.opened);
        args.append("-c").append(number);
        ExecResult execResult = this.executeP4Command(args.getArguments(), connection);
        if (StringUtil.toLowerCase((String)execResult.getStderr()).contains(STANDARD_REVERT_UNCHANGED_ERROR_MESSAGE)) {
            return new ArrayList<PerforceChange>();
        }
        this.checkError(execResult, connection);
        try {
            return PerforceOutputMessageParser.processOpenedOutput(execResult.getStdout());
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    public List<PerforceChange> opened(P4Connection connection, Collection<FilePath> paths, boolean throwIfNotUnderClient) throws VcsException {
        if (paths.size() > 50) {
            ArrayList<PerforceChange> result = new ArrayList<PerforceChange>();
            for (List filePaths : JBIterable.from(paths).split(50, false)) {
                result.addAll(this.openedImpl(connection, filePaths, throwIfNotUnderClient));
            }
            return result;
        }
        return this.openedImpl(connection, paths, throwIfNotUnderClient);
    }

    private List<PerforceChange> openedImpl(P4Connection connection, Collection<FilePath> paths, boolean throwIfNotUnderClient) throws VcsException {
        CommandArguments args = CommandArguments.createOn(P4Command.opened);
        for (FilePath path : paths) {
            args.append(P4File.create(path).getEscapedPath());
        }
        ExecResult execResult = this.executeP4Command(args.getArguments(), connection);
        String err = StringUtil.toLowerCase((String)execResult.getStderr());
        if (throwIfNotUnderClient || !err.contains(STANDARD_REVERT_UNCHANGED_ERROR_MESSAGE) && !err.contains(NOT_UNDER_CLIENT_ROOT_MESSAGE) && !err.contains(NOT_IN_CLIENT_VIEW_MESSAGE)) {
            this.checkError(execResult, connection);
        }
        try {
            return PerforceOutputMessageParser.processOpenedOutput(execResult.getStdout());
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private static String getDescription(Map<String, List<String>> changeForm) {
        List<String> strings = changeForm.get(DESCRIPTION);
        if (strings == null) {
            return "";
        }
        return StringUtil.join(strings, (String)"\n");
    }

    private static StringBuffer createChangeData(String preparedComment, List<PerforceChange> actualChanges, Map<String, List<String>> changeForm, List<String> excludedChanges) {
        PerforceRunner.setDescriptionToForm(changeForm, preparedComment);
        List<String> changes = changeForm.get(FILES);
        if (changes != null) {
            for (String changeString : changes) {
                int typeIndex;
                String fileString = changeString.trim();
                String depotPath = fileString.substring(0, (typeIndex = fileString.indexOf("#")) - 1);
                if (PerforceRunner.findChangeByDepotPath(actualChanges, depotPath) != null) continue;
                excludedChanges.add(changeString);
            }
            changes.removeAll(excludedChanges);
        }
        return PerforceRunner.createStringFormRepresentation(changeForm);
    }

    public static void setDescriptionToForm(Map<String, List<String>> changeForm, String preparedComment) {
        List<String> description = changeForm.get(DESCRIPTION);
        if (description != null) {
            description.clear();
            description.addAll(PerforceRunner.getAllLines(preparedComment));
        } else {
            changeForm.put(DESCRIPTION, PerforceRunner.getAllLines(preparedComment));
        }
    }

    private static List<String> getAllLines(String preparedComment) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line1 : LineTokenizer.tokenize((CharSequence)preparedComment.trim(), (boolean)false)) {
            result.add(line1.trim());
        }
        return result;
    }

    @Nullable
    private static PerforceChange findChangeByDepotPath(List<PerforceChange> actualChanges, String depotPath) {
        for (PerforceChange change : actualChanges) {
            if (!change.getDepotPath().equals(depotPath)) continue;
            return change;
        }
        return null;
    }

    public static StringBuffer createStringFormRepresentation(Map<String, List<String>> changeForm) {
        StringBuffer result = new StringBuffer();
        for (String field : changeForm.keySet()) {
            result.append("\n");
            result.append(field);
            List<String> values = changeForm.get(field);
            result.append("\n");
            for (String value : values) {
                result.append("\t");
                result.append(value);
                result.append("\n");
            }
        }
        return result;
    }

    public List<String> getBranches(P4Connection connection) throws VcsException {
        ExecResult result = this.executeP4Command(new String[]{"branches"}, connection);
        this.checkError(result, connection);
        return OutputMessageParser.processBranchesOutput(result.getStdout());
    }

    @NotNull
    public BranchSpec loadBranchSpec(@NotNull String branchName, @NotNull P4Connection connection) throws VcsException {
        if (branchName == null) {
            PerforceRunner.$$$reportNull$$$0(17);
        }
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(18);
        }
        @NonNls String[] p4args = new String[]{"branch", "-o", branchName};
        ExecResult execResult = this.executeP4Command(p4args, connection);
        this.checkError(execResult, connection);
        Map<String, List<String>> branchSpecForm = FormParser.execute(execResult.getStdout(), new String[]{OWNER, DESCRIPTION, VIEW});
        return new BranchSpec(branchSpecForm);
    }

    public Map<String, List<String>> loadClient(String clientName, P4Connection connection) throws VcsException {
        @NonNls String[] p4args = new String[]{"client", "-o", clientName};
        ExecResult execResult = this.executeP4Command(p4args, connection);
        this.checkError(execResult, connection);
        return FormParser.execute(execResult.getStdout(), new String[]{CLIENT, OWNER, "Update:", "Access:", "Host:", DESCRIPTION, CLIENTSPEC_ROOT, CLIENTSPEC_ALTROOTS, CLIENT_OPTIONS, "LineEnd:", VIEW});
    }

    public byte @NotNull [] getByteContent(P4File file, @Nullable String revisionNumber) throws VcsException {
        byte[] byArray = this.getByteContent(file.getEscapedPath(), revisionNumber, this.getNotNullConnection(file));
        if (byArray == null) {
            PerforceRunner.$$$reportNull$$$0(19);
        }
        return byArray;
    }

    public byte @NotNull [] getByteContent(BaseRevision baseRevision, @NotNull P4Connection connection) throws VcsException {
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(20);
        }
        byte[] byArray = this.getByteContent(baseRevision.getDepotPath(), baseRevision.getRevisionNum(), connection);
        if (byArray == null) {
            PerforceRunner.$$$reportNull$$$0(21);
        }
        return byArray;
    }

    public byte @NotNull [] getByteContent(String depotPath, @Nullable String revisionNumber, @NotNull P4Connection connection) throws VcsException {
        byte[] byArray;
        block7: {
            if (connection == null) {
                PerforceRunner.$$$reportNull$$$0(22);
            }
            File tempFile = null;
            try {
                tempFile = FileUtil.createTempFile((String)"ijP4Print", (String)"");
                String[] p4args = new String[]{"print", "-q", "-o", tempFile.getPath(), depotPath + (revisionNumber == null ? "" : revisionNumber)};
                ExecResult execResult = this.executeP4Command(p4args, connection);
                this.checkError(execResult, connection);
                ContentRevisionCache.checkContentsSize((String)depotPath, (long)tempFile.length());
                byArray = FileUtil.loadFileBytes((File)tempFile);
                if (byArray != null) break block7;
            }
            catch (IOException e) {
                throw new VcsException((Throwable)e);
            }
            finally {
                if (tempFile != null) {
                    FileUtil.delete((File)tempFile);
                }
            }
            PerforceRunner.$$$reportNull$$$0(23);
        }
        return byArray;
    }

    public byte @NotNull [] getContent(FilePath file, String revisionNumber) throws VcsException {
        P4File p4File = P4File.create(file);
        byte[] byArray = this.getByteContent(this.getDepotPath(p4File), revisionNumber, this.getNotNullConnection(p4File));
        if (byArray == null) {
            PerforceRunner.$$$reportNull$$$0(24);
        }
        return byArray;
    }

    private String getDepotPath(P4File p4File) throws VcsException {
        return p4File.getFstat((Project)this.myProject, (boolean)true).depotFile;
    }

    public LocalPathsSet getResolvedWithConflictsMap(@NotNull P4Connection connection, Collection<VirtualFile> roots) throws VcsException {
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(25);
        }
        ArrayList<String> args = new ArrayList<String>();
        for (VirtualFile root : roots) {
            args.add(P4File.create(root).getRecursivePath());
        }
        ExecResult execResult = this.executeP4Command(new String[]{P4Command.resolve.getName(), "-n", "-t"}, args, null, new PerforceContext(connection));
        return new LocalPathsSet(PerforceRunner.processResolveOutput(execResult.getStdout()).keySet());
    }

    public LinkedHashSet<VirtualFile> getResolvedWithConflicts(P4Connection connection, @Nullable VirtualFile root) throws VcsException {
        return this.getResolvedWithConflicts(connection, ContainerUtil.createMaybeSingletonList(root == null ? null : P4File.create(root).getRecursivePath()));
    }

    @NotNull
    public LinkedHashSet<VirtualFile> getResolvedWithConflicts(P4Connection connection, Collection<String> fileSpecs) throws VcsException {
        CommandArguments args = CommandArguments.createOn(P4Command.resolve);
        args.append("-n");
        args.append("-t");
        for (String spec : fileSpecs) {
            args.append(spec);
        }
        ExecResult execResult = this.executeP4Command(args.getArguments(), connection);
        LinkedHashSet<VirtualFile> result = new LinkedHashSet<VirtualFile>();
        if (StringUtil.toLowerCase((String)execResult.getStderr()).contains(NO_FILES_TO_RESOLVE_MESSAGE)) {
            LinkedHashSet<VirtualFile> linkedHashSet = result;
            if (linkedHashSet == null) {
                PerforceRunner.$$$reportNull$$$0(26);
            }
            return linkedHashSet;
        }
        LinkedHashMap<String, BaseRevision> map = PerforceRunner.processResolveOutput(execResult.getStdout());
        for (String path : map.keySet()) {
            ContainerUtil.addIfNotNull(result, (Object)LocalFileSystem.getInstance().findFileByPath(path));
        }
        LinkedHashSet<VirtualFile> linkedHashSet = result;
        if (linkedHashSet == null) {
            PerforceRunner.$$$reportNull$$$0(27);
        }
        return linkedHashSet;
    }

    @Nullable
    public BaseRevision getBaseRevision(P4File file) throws VcsException {
        P4Connection connection = this.getNotNullConnection(file);
        ExecResult execResult = this.executeP4Command(new String[]{"resolve", "-n", "-o", "-t", file.getEscapedPath()}, connection);
        String stdout = execResult.getStdout();
        if (StringUtil.toLowerCase((String)stdout).contains(NO_FILES_TO_RESOLVE_MESSAGE)) {
            return null;
        }
        this.checkError(execResult, connection);
        LinkedHashMap<String, BaseRevision> result = PerforceRunner.processResolveOutput(stdout);
        return result.isEmpty() ? null : (BaseRevision)result.values().iterator().next();
    }

    public static LinkedHashMap<String, BaseRevision> processResolveOutput(String output) {
        LinkedHashMap<String, BaseRevision> result = new LinkedHashMap<String, BaseRevision>();
        for (String line : StringUtil.splitByLines((String)output)) {
            String separator = MERGING_MESSAGE;
            int index = line.indexOf(separator);
            if (index < 0) {
                separator = UBINARY_MERGING_MESSAGE;
                index = line.indexOf(UBINARY_MERGING_MESSAGE);
            }
            if (index < 0) {
                separator = BINARY_MERGING_MESSAGE;
                index = line.indexOf(BINARY_MERGING_MESSAGE);
            }
            if (index < 0) continue;
            String file = line.substring(0, index).trim();
            BaseRevision revision = PerforceRunner.createBaseRevision(line.substring(index + separator.length()), result.get(file));
            result.put(file, revision);
        }
        return result;
    }

    @Nullable
    private static BaseRevision createBaseRevision(String line, @Nullable BaseRevision existing) {
        int usingBasePosition = line.indexOf(USING_BASE_MESSAGE);
        if (usingBasePosition < 0) {
            return null;
        }
        String sourcePath = line.substring(0, usingBasePosition);
        int sourceRevPosition = StringUtil.indexOfAny((String)sourcePath, (String)"#@");
        String sourceRevision = sourceRevPosition >= 0 ? sourcePath.substring(sourceRevPosition).trim() : null;
        int revPosition = StringUtil.indexOfAny((String)line, (String)"#@", (int)usingBasePosition, (int)line.length());
        String basePath = line.substring(usingBasePosition + USING_BASE_MESSAGE.length(), revPosition).trim();
        if (revPosition < 0) {
            return null;
        }
        String revision = line.substring(revPosition).trim();
        try {
            String revisionNum = existing == null ? revision : existing.getRevisionNum();
            return new BaseRevision(revisionNum, sourceRevision, basePath);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void resolveToYours(P4File file) throws VcsException {
        this.resolve(file, "-ay");
    }

    public void resolveAutomatically(P4File file) throws VcsException {
        this.resolve(file, "-am");
    }

    private void resolve(P4File file, @NonNls String resolveMode) throws VcsException {
        P4Connection connection;
        @NonNls String[] p4args = new String[]{"resolve", resolveMode, file.getRecursivePath()};
        ExecResult execResult = this.executeP4Command(p4args, connection = this.getNotNullConnection(file));
        String stdErr = StringUtil.toLowerCase((String)execResult.getStderr());
        if (!stdErr.contains(NO_FILES_TO_RESOLVE_MESSAGE)) {
            this.checkError(execResult, connection);
        }
    }

    public ExecResult integrate(String branchName, P4File path, long changeListNum, @Nullable String integrateChangeListNum, boolean reverse, P4Connection connection) {
        boolean insideBranch;
        String depotPath;
        CommandArguments arguments = CommandArguments.createOn(P4Command.integrate);
        PerforceRunner.appendChangeListNumber(changeListNum, arguments);
        if (reverse) {
            arguments.append("-r");
        }
        arguments.append("-b").append(branchName);
        try {
            depotPath = this.where(path, connection).getDepot() + "/";
            insideBranch = this.isInsideBranch(branchName, connection, depotPath);
        }
        catch (VcsException e) {
            ExecResult result = new ExecResult();
            result.setException(e);
            return result;
        }
        if (insideBranch == reverse) {
            arguments.append("-s");
        }
        if (integrateChangeListNum == null) {
            arguments.append(depotPath + "...");
        } else {
            arguments.append(depotPath + "...@" + integrateChangeListNum + ",@" + integrateChangeListNum);
        }
        return this.executeP4Command(arguments.getArguments(), connection);
    }

    public boolean have(P4File file) throws VcsException {
        P4Connection connection = this.myConnectionManager.getConnectionForFile(file);
        if (connection == null) {
            return false;
        }
        Object2LongOpenHashMap haveRevisions = new Object2LongOpenHashMap();
        P4HaveParser.RevisionCollector haveParser = new P4HaveParser.RevisionCollector(this.myPerforceManager, (Object2LongMap<String>)haveRevisions);
        this.doHave(Collections.singletonList(PerforceRunner.getP4FilePath(file, file.isDirectory(), file.isDirectory())), connection, haveParser, false);
        return !haveRevisions.isEmpty();
    }

    public long haveRevision(P4File file) throws VcsException {
        P4Connection connection = this.myConnectionManager.getConnectionForFile(file);
        if (connection == null) {
            return -1L;
        }
        Object2LongOpenHashMap haveRevisions = new Object2LongOpenHashMap();
        P4HaveParser.RevisionCollector haveParser = new P4HaveParser.RevisionCollector(this.myPerforceManager, (Object2LongMap<String>)haveRevisions);
        this.doHave(Collections.singletonList(PerforceRunner.getP4FilePath(file, file.isDirectory(), false)), connection, haveParser, false);
        return haveRevisions.isEmpty() ? -1L : haveRevisions.values().iterator().nextLong();
    }

    public VcsRevisionNumber getCurrentRevision(P4File p4File) {
        try {
            long curRev = this.haveRevision(p4File);
            FStat fstat = p4File.getFstat(this.myProject, false);
            long cachedRev = Long.parseLong(fstat.haveRev);
            if (cachedRev != curRev) {
                fstat = p4File.getFstat(this.myProject, true);
            }
            return PerforceVcsRevisionNumber.createFromFStat(fstat);
        }
        catch (VcsException e) {
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void haveMultiple(PathsHelper helper, @NotNull P4Connection connection, P4HaveParser consumer) throws VcsException {
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(28);
        }
        if (helper.isEmpty()) {
            return;
        }
        List<String> args = helper.getRequestString();
        this.doHave(args, connection, consumer, true);
    }

    static String getP4FilePath(P4File file, boolean isDirectory, boolean recursively) {
        String escapedPath = file.getEscapedPath();
        return isDirectory ? escapedPath + "/" + (recursively ? "..." : "*") : escapedPath;
    }

    private void doHave(List<String> filesSpec, @NotNull P4Connection connection, P4HaveParser consumer, boolean longTimeout) throws VcsException {
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(29);
        }
        PerforceContext context = new PerforceContext(connection, longTimeout, false);
        for (List chunk : Lists.partition(new ArrayList<String>(new LinkedHashSet<String>(filesSpec)), (int)CHUNK_SIZE)) {
            boolean notUnderRoot;
            ExecResult execResult = this.executeP4Command(new String[]{"have"}, chunk, null, context);
            String stderr = execResult.getStderr();
            boolean bl = notUnderRoot = stderr.contains(NOT_ON_CLIENT_MESSAGE) || stderr.contains(NOT_UNDER_CLIENT_ROOT_MESSAGE);
            if (!notUnderRoot) {
                if (!stderr.contains(INVALID_REVISION_NUMBER)) {
                    this.checkError(execResult, connection);
                }
            } else {
                LOG.debug("Problem while doing 'have': " + stderr);
            }
            Ref vcsExceptionRef = new Ref();
            try {
                execResult.allowSafeStdoutUsage((ThrowableConsumer<InputStream, IOException>)((ThrowableConsumer)inputStream -> {
                    try {
                        consumer.readHaveOutput((InputStream)inputStream);
                    }
                    catch (VcsException e) {
                        vcsExceptionRef.set((Object)e);
                    }
                }));
            }
            catch (IOException e) {
                throw new VcsException((Throwable)e);
            }
            if (vcsExceptionRef.isNull()) continue;
            throw (VcsException)((Object)vcsExceptionRef.get());
        }
    }

    public P4Revision[] filelog(P4File file, boolean showBranches) throws VcsException {
        return this.filelog(this.getNotNullConnection(file), file.getRecursivePath(), showBranches);
    }

    public P4Revision[] filelog(@NotNull P4Connection connection, @NotNull String path, boolean showBranches) throws VcsException {
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(30);
        }
        if (path == null) {
            PerforceRunner.$$$reportNull$$$0(31);
        }
        CommandArguments arguments = this.createFilelogArgs(showBranches, connection).append(path);
        ExecResult execResult = this.executeP4Command(arguments.getArguments(), connection);
        this.checkError(execResult, connection);
        return PerforceRunner.parseLogOutput(execResult, this.isFilelogNewDateVersion(connection));
    }

    public List<String> files(Collection<String> escapedPaths, P4Connection connection) throws VcsException {
        if (escapedPaths.isEmpty()) {
            return Collections.emptyList();
        }
        ExecResult execResult = this.executeP4Command(CommandArguments.createOn(P4Command.files).getArguments(), escapedPaths, null, new PerforceContext(connection));
        if (execResult.getExitCode() != 0) {
            this.checkError(execResult, connection);
        }
        return new OutputMessageParser((String)execResult.getStdout()).myLines;
    }

    private CommandArguments createFilelogArgs(boolean showBranches, @Nullable P4Connection connection) throws VcsException {
        int limit;
        CommandArguments arguments = CommandArguments.createOn(P4Command.filelog);
        if (showBranches) {
            arguments.append("-i");
        }
        arguments.append("-l");
        if (this.isFilelogNewDateVersion(connection)) {
            arguments.append("-t");
        }
        int n = limit = VcsConfiguration.getInstance((Project)this.myProject).LIMIT_HISTORY ? VcsConfiguration.getInstance((Project)this.myProject).MAXIMUM_HISTORY_ROWS : -1;
        if (limit > 0) {
            arguments.append("-m");
            arguments.append(limit);
        }
        return arguments;
    }

    private boolean isFilelogNewDateVersion(@Nullable P4Connection connection) throws VcsException {
        ServerVersion serverVersion = this.mySettings.getServerFullVersion(connection);
        if (serverVersion == null) {
            return false;
        }
        return serverVersion.getVersionYear() >= 2003L || serverVersion.getVersionYear() == 2002L && serverVersion.getVersionNum() > 1L;
    }

    private static P4Revision[] parseLogOutput(ExecResult execResult, boolean newDateFormat) throws VcsException {
        try {
            List<P4Revision> p4Revisions = OutputMessageParser.processLogOutput(execResult.getStdout(), newDateFormat);
            return p4Revisions.toArray(new P4Revision[0]);
        }
        catch (ParseException e) {
            throw new VcsException((Throwable)e);
        }
    }

    public AnnotationInfo annotate(P4Connection connection, String filePath, long revision) throws VcsException {
        if (revision != -1L) {
            filePath = (String)filePath + "#" + revision;
        }
        ArrayList<Object> commands = new ArrayList<Object>();
        commands.add("annotate");
        commands.add("-q");
        boolean useChangelistNumbers = false;
        if (this.mySettings.SHOW_BRANCHES_HISTORY && this.isAnnotateBranchSupported(connection)) {
            commands.add("-i");
            useChangelistNumbers = true;
        }
        if (this.isAnnotateIgnoringWhitespaceSupported(connection)) {
            commands.add("-dw");
        } else {
            commands.add("-dl");
        }
        commands.add(filePath);
        ExecResult execResult = this.executeP4Command(ArrayUtilRt.toStringArray(commands), connection);
        this.checkError(execResult, connection);
        try {
            return new AnnotationInfo(execResult.getStdout(), useChangelistNumbers);
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private boolean isAnnotateBranchSupported(@Nullable P4Connection connection) throws VcsException {
        ServerVersion version = this.myPerforceManager.getServerVersion(connection);
        if (version == null) {
            return false;
        }
        return version.getVersionYear() > 2005L || version.getVersionYear() == 2005L && version.getVersionNum() >= 2L;
    }

    private boolean isAnnotateIgnoringWhitespaceSupported(@Nullable P4Connection connection) throws VcsException {
        return this.isAnnotateBranchSupported(connection);
    }

    public List<ResolvedFile> getResolvedFiles(@NotNull P4Connection connection, Collection<VirtualFile> roots) throws VcsException {
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(32);
        }
        ArrayList<String> args = new ArrayList<String>();
        for (VirtualFile root : roots) {
            args.add(P4File.create(root).getRecursivePath());
        }
        ExecResult execResult = this.executeP4Command(new String[]{P4Command.resolved.getName()}, args, null, new PerforceContext(connection));
        this.checkError(execResult, connection);
        try {
            String clientRoot = this.myPerforceManager.getClientRoot(connection);
            return PerforceOutputMessageParser.processResolvedOutput(execResult.getStdout(), (Convertor<String, String>)((Convertor)o -> this.myPerforceManager.convertP4ParsedPath(clientRoot, (String)o)));
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    public List<String> getJobSpecification(P4Connection connection) throws VcsException {
        ExecResult execResult = this.executeP4Command(new String[]{"jobspec", "-o"}, connection);
        this.checkError(execResult, connection);
        String stdout = execResult.getStdout();
        SPECIFICATION_LOG.debug(stdout);
        return new OutputMessageParser((String)stdout).myLines;
    }

    public List<String> getJobs(P4Connection connection, JobsSearchSpecificator specificator) throws VcsException {
        String[] strings = specificator.addParams(new String[]{"jobs", "-l"});
        ExecResult execResult = this.executeP4Command(strings, connection);
        this.checkError(execResult, connection);
        return new OutputMessageParser((String)execResult.getStdout()).myLines;
    }

    public List<String> getJobDetails(PerforceJob job) throws VcsException {
        ExecResult execResult = this.executeP4Command(new String[]{"job", "-o", job.getName()}, job.getConnection());
        this.checkError(execResult, job.getConnection());
        return new OutputMessageParser((String)execResult.getStdout()).myLines;
    }

    public List<String> getJobsForChange(@NotNull P4Connection connection, long number) throws VcsException {
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(33);
        }
        ExecResult execResult = this.executeP4Command(new String[]{"fixes", "-c", String.valueOf(number)}, connection);
        this.checkError(execResult, connection);
        return new OutputMessageParser((String)execResult.getStdout()).myLines;
    }

    /*
     * WARNING - void declaration
     */
    public void addJobForList(@NotNull P4Connection connection, long number, String string) throws VcsException {
        void name;
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(34);
        }
        ExecResult execResult = this.executeP4Command(new String[]{"fix", "-c", String.valueOf(number), name}, connection);
        this.checkError(execResult, connection);
    }

    /*
     * WARNING - void declaration
     */
    public void removeJobFromList(@NotNull P4Connection connection, long number, String string) throws VcsException {
        void name;
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(35);
        }
        ExecResult execResult = this.executeP4Command(new String[]{"fix", "-d", "-c", String.valueOf(number), name}, connection);
        this.checkError(execResult, connection);
    }

    public ExecResult executeP4Command(@NonNls String[] p4args, @NotNull P4Connection connection) {
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(36);
        }
        return this.executeP4Command(p4args, null, connection);
    }

    private ExecResult executeP4Command(@NonNls String[] p4args, @Nullable StringBuffer inputStream, @NotNull P4Connection connection) {
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(37);
        }
        return this.executeP4Command(p4args, Collections.emptyList(), inputStream, new PerforceContext(connection));
    }

    /*
     * Exception decompiling
     */
    private ExecResult executeP4Command(@NonNls String[] p4cmd, Collection<String> args, @Nullable StringBuffer inputStream, @NotNull PerforceContext ctx) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static File createArgumentFile(Collection<String> args) throws VcsException {
        try {
            File tempFile = FileUtil.createTempFile((String)"p4batch", (String)".txt");
            FileUtil.writeToFile((File)tempFile, (String)StringUtil.join(args, (String)System.lineSeparator()));
            tempFile.deleteOnExit();
            return tempFile;
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private static boolean shouldPassArgumentsViaFile(Collection<String> args) {
        int totalLength = 0;
        for (String arg : args) {
            totalLength += arg.length() + 1;
        }
        return totalLength > 2000;
    }

    @Nls
    private static String createPasswordNotAllowedButSetMessage(@NotNull P4Connection connection) {
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(39);
        }
        return PerforceBundle.message("connection.password.not.allowed", connection.getWorkingDir());
    }

    public static File getDumpFile() {
        return new File(PathManager.getLogPath(), DUMP_FILE_NAME);
    }

    private static void logMessage(String message) {
        File file = PerforceRunner.getDumpFile();
        String s = "\n" + new Time(System.currentTimeMillis()) + " " + message;
        try {
            if (file.length() > 10000000L) {
                FileUtil.delete((File)file);
            }
            FileUtil.writeToFile((File)file, (byte[])s.getBytes(StandardCharsets.UTF_8), (boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static VcsException createCorrectException(@NlsSafe String stderr, PerforceSettings settings, @Nullable P4Connection connection) {
        if (connection != null) {
            if (stderr.contains(PASSWORD_NOT_ALLOWED_MESSAGE)) {
                return new PerforcePasswordNotAllowedException(settings.USE_LOGIN && settings.useP4CONFIG ? PerforceRunner.createPasswordNotAllowedButSetMessage(connection) : stderr, settings.getProject(), connection);
            }
            if (stderr.contains(PASSWORD_INVALID_MESSAGE) || stderr.contains(PASSWORD_INVALID_MESSAGE2) || stderr.contains(SESSION_EXPIRED_MESSAGE)) {
                return new PerforceAuthenticationException(stderr, connection, settings.getProject());
            }
        }
        if (stderr.contains("must create client") && stderr.contains("to access local files") || stderr.contains("Password must be set before access can be granted")) {
            return new VcsConnectionProblem(stderr);
        }
        if (stderr.contains("Connect to server failed")) {
            return new PerforceServerUnavailable(stderr);
        }
        return new VcsException(stderr);
    }

    public ExecResult checkError(ExecResult result, @Nullable P4Connection connection) throws VcsException {
        PerforceRunner.checkError(result, this.mySettings, connection);
        return result;
    }

    public static void checkError(ExecResult result, PerforceSettings settings, @Nullable P4Connection connection) throws VcsException {
        boolean error;
        Throwable exception = result.getException();
        boolean bl = error = exception != null || PerforceRunner.containsErrorOutput(result) || result.getExitCode() < 0;
        if (error) {
            String errorOutput = result.getStderr();
            if (exception != null) {
                result.cleanup();
                if (exception instanceof PerforceAuthenticationException) {
                    throw (PerforceAuthenticationException)((Object)exception);
                }
                throw new VcsException(exception);
            }
            String stdErr = errorOutput.trim();
            if (stdErr.length() > 0) {
                boolean hasErrors = false;
                for (String s : stdErr.split("\n")) {
                    if (!StringUtil.isNotEmpty((String)s) || StringUtil.toLowerCase((String)s).contains(NO_FILES_RESOLVED_MESSAGE)) continue;
                    hasErrors = true;
                    break;
                }
                if (hasErrors) {
                    String stdOut = result.getStdout().trim();
                    String message = StringUtil.isNotEmpty((String)stdOut) ? errorOutput + "\n" + stdOut : errorOutput;
                    throw PerforceRunner.createCorrectException(message, settings, connection);
                }
            } else {
                throw new VcsException(PerforceBundle.message("error.p4.returned.error.code", result.getExitCode()));
            }
        }
    }

    public static VcsException[] checkErrors(ExecResult result, PerforceSettings settings, P4Connection connection) {
        boolean error;
        Throwable exception = result.getException();
        boolean bl = error = result.getExitCode() != 0 || exception != null || PerforceRunner.containsErrorOutput(result);
        if (error) {
            String errorOutput = result.getStderr();
            result.cleanup();
            if (exception != null) {
                return new VcsException[]{new VcsException(exception)};
            }
            String[] lines = errorOutput.split("\n");
            VcsException[] errors = new VcsException[lines.length];
            for (int i = 0; i < lines.length; ++i) {
                errors[i] = PerforceRunner.createCorrectException(lines[i], settings, connection);
            }
            return errors;
        }
        return VcsException.EMPTY_ARRAY;
    }

    private static boolean containsErrorOutput(ExecResult result) {
        String errorOutput = result.getStderr().trim();
        return !errorOutput.contains(FILES_UP_TO_DATE) && errorOutput.length() > 2;
    }

    @NotNull
    public P4WhereResult where(P4File file, P4Connection connection) throws VcsException {
        P4WhereResult p4WhereResult = this.where(file.getEscapedPath(), connection);
        if (p4WhereResult == null) {
            PerforceRunner.$$$reportNull$$$0(40);
        }
        return p4WhereResult;
    }

    public P4WhereResult whereDir(P4File dir, P4Connection connection) throws VcsException {
        P4WhereResult result = this.where(dir.getRecursivePath(), connection);
        return new P4WhereResult(PerforceRunner.removeTail(result.getLocal()), PerforceRunner.removeTail(result.getLocalRootDependent()), PerforceRunner.removeTail(result.getDepot()));
    }

    private static String removeTail(String s) {
        return StringUtil.trimEnd((String)s, (String)"/...");
    }

    @NotNull
    public P4WhereResult where(String escapedPath, P4Connection connection) throws VcsException {
        ExecResult execResult = this.executeP4Command(new String[]{"where", escapedPath}, connection);
        this.checkError(execResult, connection);
        String out = PerforceRunner.getLastLine(execResult);
        PerforceClient client = this.myPerforceManager.getClient(connection);
        List roots = ContainerUtil.map(client.getRoots(), root -> this.myPerforceManager.getRawRoot((String)root).replace('\\', '/'));
        WhereParser parser = new WhereParser(out, roots, client.getName(), escapedPath);
        parser.execute();
        return new P4WhereResult(this.myPerforceManager.convertP4ParsedPath(null, parser.getLocal()), parser.getLocalRootRelative(), parser.getDepot());
    }

    private static String getLastLine(ExecResult execResult) throws VcsException {
        String result = execResult.getStdout();
        String[] lines = result.trim().split("\n");
        for (int i = lines.length - 1; i >= 0; --i) {
            String line = lines[i];
            if (line.startsWith("-")) continue;
            return line;
        }
        throw new VcsException(PerforceBundle.message("error.p4.where.wrong.result", result));
    }

    public ClientVersion getClientVersion() {
        PerforceLocalConnection connection = new PerforceLocalConnection(this.myProject.getBaseDir().getPath());
        try {
            ExecResult result = this.executeP4Command(new String[]{"-V"}, connection);
            this.checkError(result, connection);
            String out = result.getStdout();
            Map<String, List<String>> map = FormParser.execute(out, new String[]{CLIENT_VERSION_REV});
            List<String> versionString = map.get(CLIENT_VERSION_REV);
            if (versionString != null && !versionString.isEmpty()) {
                return OutputMessageParser.parseClientVersion(versionString.get(0));
            }
        }
        catch (VcsException vcsException) {
            // empty catch block
        }
        return ClientVersion.UNKNOWN;
    }

    public void move(P4File from, P4File to, P4Connection connection, boolean keepWorkspace, long changeList) throws VcsException {
        CommandArguments command = CommandArguments.createOn(P4Command.move);
        PerforceRunner.appendChangeListNumber(changeList, command);
        if (keepWorkspace) {
            command.append("-k");
        }
        command.append(from.getEscapedPath());
        command.append(to.getEscapedPath());
        ExecResult result = this.executeP4Command(command.getArguments(), connection);
        this.checkError(result, connection);
        if (result.getStdout().contains("can't move to an existing file")) {
            throw new VcsException(PerforceBundle.message("exception.text.cannot.assure.no.file.being.on.server", to.getLocalPath()));
        }
    }

    public boolean isValidPendingNumber(P4Connection connection, long number) {
        LOG.debug("connection = [" + connection + "], changeListNumber = [" + number + "]");
        CommandArguments args = CommandArguments.createOn(P4Command.describe);
        args.append("-s").append(number);
        ExecResult execResult = this.executeP4Command(args.getArguments(), connection);
        Throwable exception = execResult.getException();
        boolean error = exception != null || PerforceRunner.containsErrorOutput(execResult) || execResult.getExitCode() < 0;
        return !error;
    }

    public List<String> getBranchViews(@NotNull String branchName, boolean target, @NotNull P4Connection connection) throws VcsException {
        if (branchName == null) {
            PerforceRunner.$$$reportNull$$$0(41);
        }
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(42);
        }
        ArrayList<String> fileSpecs = new ArrayList<String>();
        for (String view : this.loadBranchSpec(branchName, connection).getViews()) {
            String[] split = view.split("\\s");
            if (split.length != 2) continue;
            fileSpecs.add(split[target ? 1 : 0]);
        }
        return fileSpecs;
    }

    private boolean isInsideBranch(@NotNull String branchName, @NotNull P4Connection connection, String depotPath) throws VcsException {
        if (branchName == null) {
            PerforceRunner.$$$reportNull$$$0(43);
        }
        if (connection == null) {
            PerforceRunner.$$$reportNull$$$0(44);
        }
        for (String view : this.getBranchViews(branchName, true, connection)) {
            if (!depotPath.startsWith(StringUtil.trimEnd((String)view, (String)"..."))) continue;
            return true;
        }
        return false;
    }

    public void unshelve(P4Connection connection, long changeList, Collection<String> paths) throws VcsException {
        ExecResult result = this.executeP4Command(new String[]{"unshelve", "-s", String.valueOf(changeList), "-c", String.valueOf(changeList)}, paths, null, new PerforceContext(connection));
        this.checkError(result, connection);
    }

    public void shelve(P4Connection connection, long changeList, Collection<String> paths) throws VcsException {
        ExecResult result = this.executeP4Command(new String[]{"shelve", "-f", "-c", String.valueOf(changeList)}, paths, null, new PerforceContext(connection));
        if (result.getExitCode() != 0) {
            throw new VcsException(result.getStdout() + result.getStderr());
        }
        this.checkError(result, connection);
    }

    public void deleteFromShelf(P4Connection connection, long changeList, Collection<String> paths) throws VcsException {
        ExecResult result = this.executeP4Command(new String[]{"shelve", "-d", "-c", String.valueOf(changeList)}, paths, null, new PerforceContext(connection));
        this.checkError(result, connection);
        this.deleteChangeList(connection, changeList, false, true, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: 
            case 8: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/perforce/PerforceRunner";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeCache";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootP4File";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 17: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/perforce/PerforceRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullConnection";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPerforceChanges";
                break;
            }
            case 19: 
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getByteContent";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedWithConflicts";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "where";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "editAll";
                break;
            }
            case 2: 
            case 8: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 40: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "revertAll";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "revertUnchanged";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "previewAdd";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "ignores";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reopen";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parsePerforceChangeLists";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deleteChangeList";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "submitForConnection";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createChangeList";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "renameChangeList";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSubmittedChangeLists";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadBranchSpec";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getByteContent";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedWithConflictsMap";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "haveMultiple";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doHave";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "filelog";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedFiles";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getJobsForChange";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addJobForList";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "removeJobFromList";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "executeP4Command";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createPasswordNotAllowedButSetMessage";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getBranchViews";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isInsideBranch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

