/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.externalSystem.issue.quickfix.ReimportQuickFix;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleVersionQuickFix;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleWrapperSettingsOpenQuickFix;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0007\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/gradle/issue/DeprecatedGradleVersionIssue;", "Lcom/intellij/build/issue/BuildIssue;", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "projectPath", "", "(Lorg/gradle/util/GradleVersion;Ljava/lang/String;)V", "description", "getDescription", "()Ljava/lang/String;", "quickFixes", "", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "getQuickFixes", "()Ljava/util/List;", "title", "getTitle", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.gradle.common"})
@ApiStatus.Internal
public final class DeprecatedGradleVersionIssue
implements BuildIssue {
    @NotNull
    private final String title;
    @NotNull
    private final String description;
    @NotNull
    private final List<BuildIssueQuickFix> quickFixes;
    private static final GradleVersion minimalRecommendedVersion;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String getTitle() {
        return this.title;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public List<BuildIssueQuickFix> getQuickFixes() {
        return this.quickFixes;
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return null;
    }

    public DeprecatedGradleVersionIssue(@NotNull GradleVersion gradleVersion2, @NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)gradleVersion2, (String)"gradleVersion");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        this.title = "Gradle " + gradleVersion2.getVersion() + " support can be dropped in the next release";
        boolean bl = false;
        this.quickFixes = new ArrayList();
        bl = gradleVersion2.compareTo(minimalRecommendedVersion) < 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        StringBuilder issueDescription = new StringBuilder();
        ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfoEx, (String)"ApplicationInfoImpl.getShadowInstance()");
        String ideVersionName = applicationInfoEx.getVersionName();
        issueDescription.append(StringsKt.trimIndent((String)("\n      The project uses Gradle " + gradleVersion2.getVersion() + ".\n      The support for Gradle older that " + minimalRecommendedVersion.getVersion() + " will likely be dropped by " + ideVersionName + " in the next release.\n      \n      Gradle " + minimalRecommendedVersion.getVersion() + " release notes can be found at https://docs.gradle.org/" + minimalRecommendedVersion.getVersion() + "/release-notes.html\n      ")));
        issueDescription.append("\n\nPossible solution:\n");
        Path wrapperPropertiesFile = GradleUtil.findDefaultWrapperPropertiesFile(projectPath);
        if (wrapperPropertiesFile == null) {
            GradleVersionQuickFix gradleVersionFix = new GradleVersionQuickFix(projectPath, minimalRecommendedVersion, true);
            issueDescription.append(" - <a href=\"" + gradleVersionFix.getId() + "\">Upgrade Gradle wrapper to " + minimalRecommendedVersion.getVersion() + " version " + "and re-import the project</a>\n");
            this.getQuickFixes().add(gradleVersionFix);
        } else {
            GradleWrapperSettingsOpenQuickFix wrapperSettingsOpenQuickFix = new GradleWrapperSettingsOpenQuickFix(projectPath, "distributionUrl");
            ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
            Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"GradleConstants.SYSTEM_ID");
            ReimportQuickFix reimportQuickFix = new ReimportQuickFix(projectPath, projectSystemId);
            issueDescription.append(" - <a href=\"" + wrapperSettingsOpenQuickFix.getId() + "\">Open Gradle wrapper settings</a>, " + "change `distributionUrl` property to use Gradle " + minimalRecommendedVersion.getVersion() + " or newer and <a href=\"" + reimportQuickFix.getId() + "\">reload the project</a>\n");
            this.getQuickFixes().add(wrapperSettingsOpenQuickFix);
            this.getQuickFixes().add((BuildIssueQuickFix)reimportQuickFix);
        }
        String string3 = issueDescription.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"issueDescription.toString()");
        this.description = string3;
    }

    static {
        Companion = new Companion(null);
        GradleVersion gradleVersion2 = GradleVersion.version((String)"3.0");
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion2, (String)"GradleVersion.version(\"3.0\")");
        minimalRecommendedVersion = gradleVersion2;
    }

    @JvmStatic
    public static final boolean isDeprecated(@NotNull GradleVersion gradleVersion2) {
        return Companion.isDeprecated(gradleVersion2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/gradle/issue/DeprecatedGradleVersionIssue$Companion;", "", "()V", "minimalRecommendedVersion", "Lorg/gradle/util/GradleVersion;", "isDeprecated", "", "gradleVersion", "intellij.gradle.common"})
    public static final class Companion {
        @JvmStatic
        public final boolean isDeprecated(@NotNull GradleVersion gradleVersion2) {
            Intrinsics.checkNotNullParameter((Object)gradleVersion2, (String)"gradleVersion");
            return gradleVersion2.compareTo(minimalRecommendedVersion) < 0;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

