/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import com.intellij.serialization.PropertyMapping;
import java.io.File;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public class EarResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String earDirectory;
    @NotNull
    private final String relativePath;
    @NotNull
    private final File file;

    @PropertyMapping(value={"earDirectory", "relativePath", "file"})
    public EarResource(@NotNull String earDirectory, @NotNull String relativePath, @NotNull File file) {
        if (earDirectory == null) {
            EarResource.$$$reportNull$$$0(0);
        }
        if (relativePath == null) {
            EarResource.$$$reportNull$$$0(1);
        }
        if (file == null) {
            EarResource.$$$reportNull$$$0(2);
        }
        this.earDirectory = earDirectory;
        this.relativePath = EarResource.getAdjustedPath(relativePath);
        this.file = file;
    }

    @NotNull
    public String getEarDirectory() {
        String string2 = this.earDirectory;
        if (string2 == null) {
            EarResource.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    public String getRelativePath() {
        String string2 = this.relativePath;
        if (string2 == null) {
            EarResource.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @NotNull
    public File getFile() {
        File file = this.file;
        if (file == null) {
            EarResource.$$$reportNull$$$0(5);
        }
        return file;
    }

    private static String getAdjustedPath(@NotNull String path) {
        if (path == null) {
            EarResource.$$$reportNull$$$0(6);
        }
        return path.isEmpty() || path.charAt(0) != '/' ? "/" + path : path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EarResource)) {
            return false;
        }
        EarResource resource = (EarResource)o;
        if (!this.file.getPath().equals(resource.file.getPath())) {
            return false;
        }
        if (this.earDirectory != resource.earDirectory) {
            return false;
        }
        return this.relativePath.equals(resource.relativePath);
    }

    public int hashCode() {
        int result = this.earDirectory.hashCode();
        result = 31 * result + this.relativePath.hashCode();
        result = 31 * result + this.file.getPath().hashCode();
        return result;
    }

    public String toString() {
        return "Resource{earDirectory=" + this.earDirectory + ", relativePath='" + this.relativePath + "', file=" + this.file + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "earDirectory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/model/data/EarResource";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/model/data/EarResource";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEarDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAdjustedPath";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

