/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.editor.lists.Replacement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J,\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0003J\u0006\u0010\u001d\u001a\u00020\u0003J\t\u0010\u001e\u001a\u00020\tH\u00d6\u0001J\u001a\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007\u00a8\u0006 "}, d2={"Lorg/intellij/plugins/markdown/editor/lists/ListItemIndentInfo;", "", "indent", "", "markerLength", "(II)V", "getIndent", "()I", "indentStr", "", "getIndentStr", "()Ljava/lang/String;", "getMarkerLength", "changeLineIndent", "Lorg/intellij/plugins/markdown/editor/lists/Replacement;", "line", "newIndent", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/psi/PsiFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "subItem", "subItemIndent", "toString", "with", "intellij.markdown"})
public final class ListItemIndentInfo {
    @NotNull
    private final String indentStr;
    private final int indent;
    private final int markerLength;

    @NotNull
    public final String getIndentStr() {
        return this.indentStr;
    }

    public final int subItemIndent() {
        return this.indent + this.markerLength;
    }

    @NotNull
    public final ListItemIndentInfo subItem(int markerLength) {
        return new ListItemIndentInfo(this.subItemIndent(), markerLength);
    }

    @NotNull
    public final ListItemIndentInfo with(int indent, int markerLength) {
        return new ListItemIndentInfo(indent, markerLength);
    }

    public static /* synthetic */ ListItemIndentInfo with$default(ListItemIndentInfo listItemIndentInfo, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = listItemIndentInfo.indent;
        }
        if ((n3 & 2) != 0) {
            n2 = listItemIndentInfo.markerLength;
        }
        return listItemIndentInfo.with(n, n2);
    }

    @Nullable
    public final Replacement changeLineIndent(int line, int newIndent, @NotNull Document document, @Nullable PsiFile file) {
        boolean lineIsBlank;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        ListItemIndentInfo newIndentInfo = ListItemIndentInfo.with$default(this, newIndent, 0, 2, null);
        TextRange oldIndentRange = ListUtils.INSTANCE.getLineIndentRange(document, line);
        String string = ListUtils.INSTANCE.getLineIndentSpaces(document, line, file);
        Integer realIndent = string != null ? Integer.valueOf(string.length()) : null;
        boolean bl = lineIsBlank = oldIndentRange.getEndOffset() == document.getLineEndOffset(line);
        if (realIndent == null || realIndent < this.indent || lineIsBlank) {
            return null;
        }
        String newFullIndent = newIndentInfo.indentStr + StringsKt.repeat((CharSequence)" ", (int)(realIndent - this.indent));
        return new Replacement(oldIndentRange, newFullIndent);
    }

    public static /* synthetic */ Replacement changeLineIndent$default(ListItemIndentInfo listItemIndentInfo, int n, int n2, Document document, PsiFile psiFile, int n3, Object object) {
        if ((n3 & 8) != 0) {
            psiFile = null;
        }
        return listItemIndentInfo.changeLineIndent(n, n2, document, psiFile);
    }

    public final int getIndent() {
        return this.indent;
    }

    public final int getMarkerLength() {
        return this.markerLength;
    }

    public ListItemIndentInfo(int indent, int markerLength) {
        this.indent = indent;
        this.markerLength = markerLength;
        this.indentStr = StringsKt.repeat((CharSequence)" ", (int)this.indent);
    }

    public final int component1() {
        return this.indent;
    }

    public final int component2() {
        return this.markerLength;
    }

    @NotNull
    public final ListItemIndentInfo copy(int indent, int markerLength) {
        return new ListItemIndentInfo(indent, markerLength);
    }

    public static /* synthetic */ ListItemIndentInfo copy$default(ListItemIndentInfo listItemIndentInfo, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = listItemIndentInfo.indent;
        }
        if ((n3 & 2) != 0) {
            n2 = listItemIndentInfo.markerLength;
        }
        return listItemIndentInfo.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "ListItemIndentInfo(indent=" + this.indent + ", markerLength=" + this.markerLength + ")";
    }

    public int hashCode() {
        return Integer.hashCode(this.indent) * 31 + Integer.hashCode(this.markerLength);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ListItemIndentInfo)) break block3;
                ListItemIndentInfo listItemIndentInfo = (ListItemIndentInfo)object;
                if (this.indent != listItemIndentInfo.indent || this.markerLength != listItemIndentInfo.markerLength) break block3;
            }
            return true;
        }
        return false;
    }
}

