/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.editor.tables.TableUtils$separatorRow$;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCellImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRowImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.intellij.plugins.markdown.util.PsiUtilsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0007J\u001f\u0010#\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010%\u001a\u0004\u0018\u00010\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0007J\u0012\u0010&\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010&\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0007J\u0012\u0010'\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010'\u001a\u0004\u0018\u00010\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0007J\u0012\u0010(\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010(\u001a\u0004\u0018\u00010\u00052\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0007J\u0018\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0004H\u0007J\u0012\u0010-\u001a\u00020.*\u00020\u00052\u0006\u0010/\u001a\u00020\u0004J\"\u00100\u001a\b\u0012\u0004\u0012\u00020\u001001*\u00020\u00052\u0006\u00102\u001a\u00020\u00042\b\b\u0002\u00103\u001a\u00020\u0014J\u0018\u00104\u001a\b\u0012\u0004\u0012\u00020501*\u00020\u00052\u0006\u00102\u001a\u00020\u0004R\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\tR\u0015\u0010\n\u001a\u00020\u000b*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0015\u0010\n\u001a\u00020\u000b*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0015\u0010\u000f\u001a\u00020\u0004*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0013\u001a\u00020\u0014*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0015\u0010\u0016\u001a\u00020\u0014*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u0015\u0010\u0017\u001a\u00020\u0004*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00066"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/TableUtils;", "", "()V", "columnsCount", "", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableImpl;", "getColumnsCount", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableImpl;)I", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableRowImpl;", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableRowImpl;)I", "columnsIndices", "Lkotlin/ranges/IntRange;", "getColumnsIndices", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableImpl;)Lkotlin/ranges/IntRange;", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableRowImpl;)Lkotlin/ranges/IntRange;", "firstNonWhitespaceOffset", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableCellImpl;", "getFirstNonWhitespaceOffset", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableCellImpl;)I", "isHeaderRow", "", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableRowImpl;)Z", "isLast", "lastNonWhitespaceOffset", "getLastNonWhitespaceOffset", "separatorRow", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow;", "getSeparatorRow", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableImpl;)Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow;", "findCell", "element", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "offset", "findCellIndex", "(Lcom/intellij/psi/PsiFile;I)Ljava/lang/Integer;", "findRow", "findRowOrSeparator", "findSeparatorRow", "findTable", "isProbablyInsideTableCell", "document", "Lcom/intellij/openapi/editor/Document;", "caretOffset", "getColumnAlignment", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow$CellAlignment;", "columnIndex", "getColumnCells", "", "index", "withHeader", "getColumnTextRanges", "Lcom/intellij/openapi/util/TextRange;", "intellij.markdown"})
@ApiStatus.Experimental
public final class TableUtils {
    @NotNull
    public static final TableUtils INSTANCE;

    @JvmStatic
    @Nullable
    public static final MarkdownTableCellImpl findCell(@NotNull PsiFile file, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiElement psiElement = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)offset);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"PsiUtilCore.getElementAtOffset(file, offset)");
        PsiElement element2 = psiElement;
        IElementType iElementType = MarkdownTokenTypes.TABLE_SEPARATOR;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MarkdownTokenTypes.TABLE_SEPARATOR");
        if (PsiUtilsKt.hasType(element2, iElementType) && !(element2 instanceof MarkdownTableSeparatorRow) && Intrinsics.areEqual((Object)element2.getText(), (Object)String.valueOf('|'))) {
            PsiElement psiElement2 = element2.getPrevSibling();
            if (!(psiElement2 instanceof MarkdownTableCellImpl)) {
                psiElement2 = null;
            }
            return (MarkdownTableCellImpl)psiElement2;
        }
        return TableUtils.findCell(element2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final MarkdownTableCellImpl findCell(@NotNull PsiElement element2) {
        void $this$parentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiElement psiElement = element2;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        return (MarkdownTableCellImpl)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownTableCellImpl.class, (boolean)false);
    }

    @JvmStatic
    @Nullable
    public static final MarkdownTableImpl findTable(@NotNull PsiFile file, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiElement psiElement = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)offset);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"PsiUtilCore.getElementAtOffset(file, offset)");
        PsiElement element2 = psiElement;
        return TableUtils.findTable(element2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final MarkdownTableImpl findTable(@NotNull PsiElement element2) {
        void $this$parentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiElement psiElement = element2;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        return (MarkdownTableImpl)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownTableImpl.class, (boolean)false);
    }

    @JvmStatic
    @Nullable
    public static final MarkdownTableSeparatorRow findSeparatorRow(@NotNull PsiFile file, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiElement psiElement = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)offset);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"PsiUtilCore.getElementAtOffset(file, offset)");
        PsiElement element2 = psiElement;
        return TableUtils.findSeparatorRow(element2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final MarkdownTableSeparatorRow findSeparatorRow(@NotNull PsiElement element2) {
        void $this$parentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiElement psiElement = element2;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        return (MarkdownTableSeparatorRow)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownTableSeparatorRow.class, (boolean)false);
    }

    @JvmStatic
    @Nullable
    public static final MarkdownTableRowImpl findRow(@NotNull PsiFile file, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiElement psiElement = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)offset);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"PsiUtilCore.getElementAtOffset(file, offset)");
        PsiElement element2 = psiElement;
        return TableUtils.findRow(element2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final MarkdownTableRowImpl findRow(@NotNull PsiElement element2) {
        void $this$parentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiElement psiElement = element2;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        return (MarkdownTableRowImpl)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownTableRowImpl.class, (boolean)false);
    }

    @JvmStatic
    @Nullable
    public static final PsiElement findRowOrSeparator(@NotNull PsiFile file, int offset) {
        MarkdownTableRowImpl row;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MarkdownTableRowImpl markdownTableRowImpl = row = TableUtils.findRow(file, offset);
        return markdownTableRowImpl != null ? (PsiElement)markdownTableRowImpl : (PsiElement)TableUtils.findSeparatorRow(file, offset);
    }

    @JvmStatic
    @Nullable
    public static final PsiElement findRowOrSeparator(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        MarkdownTableRowImpl markdownTableRowImpl = TableUtils.findRow(element2);
        return markdownTableRowImpl != null ? (PsiElement)markdownTableRowImpl : (PsiElement)TableUtils.findSeparatorRow(element2);
    }

    @JvmStatic
    @Nullable
    public static final Integer findCellIndex(@NotNull PsiFile file, int offset) {
        Object v5;
        Sequence sequence;
        block3: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            PsiElement psiElement = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)offset);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"PsiUtilCore.getElementAtOffset(file, offset)");
            PsiElement element2 = psiElement;
            IElementType iElementType = MarkdownTokenTypes.TABLE_SEPARATOR;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MarkdownTokenTypes.TABLE_SEPARATOR");
            if (PsiUtilsKt.hasType(element2, iElementType) && !(element2 instanceof MarkdownTableSeparatorRow) && Intrinsics.areEqual((Object)element2.getText(), (Object)String.valueOf('|'))) {
                PsiElement psiElement2 = element2.getPrevSibling();
                if (!(psiElement2 instanceof MarkdownTableCellImpl)) {
                    psiElement2 = null;
                }
                MarkdownTableCellImpl markdownTableCellImpl = (MarkdownTableCellImpl)psiElement2;
                return markdownTableCellImpl != null ? Integer.valueOf(markdownTableCellImpl.getColumnIndex()) : null;
            }
            sequence = PsiTreeUtilKt.parents((PsiElement)element2, (boolean)true);
            boolean bl = false;
            Sequence sequence2 = sequence;
            boolean bl2 = false;
            for (Object e : sequence2) {
                PsiElement it = (PsiElement)e;
                boolean bl3 = false;
                IElementType iElementType2 = MarkdownElementTypes.TABLE_CELL;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"MarkdownElementTypes.TABLE_CELL");
                if (!(PsiUtilsKt.hasType(it, iElementType2) || it instanceof MarkdownTableSeparatorRow)) continue;
                v5 = e;
                break block3;
            }
            v5 = null;
        }
        PsiElement parent = v5;
        sequence = parent;
        return sequence instanceof MarkdownTableSeparatorRow ? ((MarkdownTableSeparatorRow)parent).getColumnIndexFromOffset(offset) : (sequence instanceof MarkdownTableCellImpl ? Integer.valueOf(((MarkdownTableCellImpl)parent).getColumnIndex()) : null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MarkdownTableCellImpl> getColumnCells(@NotNull MarkdownTableImpl $this$getColumnCells, int index, boolean withHeader) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getColumnCells, (String)"$this$getColumnCells");
        List<MarkdownTableRowImpl> list = $this$getColumnCells.getRows(withHeader);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getRows(withHeader)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            MarkdownTableCellImpl markdownTableCellImpl;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MarkdownTableRowImpl it = (MarkdownTableRowImpl)element$iv$iv;
            boolean bl2 = false;
            if (it.getCell(index) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            MarkdownTableCellImpl it$iv$iv = markdownTableCellImpl;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getColumnCells$default(TableUtils tableUtils, MarkdownTableImpl markdownTableImpl, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        return tableUtils.getColumnCells(markdownTableImpl, n, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextRange> getColumnTextRanges(@NotNull MarkdownTableImpl $this$getColumnTextRanges, int index) {
        ArrayList<TextRange> result;
        block1: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$getColumnTextRanges, (String)"$this$getColumnTextRanges");
            Iterable $this$map$iv = this.getColumnCells($this$getColumnTextRanges, index, true);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MarkdownTableCellImpl markdownTableCellImpl = (MarkdownTableCellImpl)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                TextRange textRange = it.getTextRange();
                collection.add(textRange);
            }
            List cells = (List)destination$iv$iv;
            result = new ArrayList<TextRange>(cells.size() + 1);
            result.addAll(cells);
            MarkdownTableSeparatorRow markdownTableSeparatorRow = this.getSeparatorRow($this$getColumnTextRanges);
            if (markdownTableSeparatorRow == null) break block1;
            MarkdownTableSeparatorRow markdownTableSeparatorRow2 = markdownTableSeparatorRow;
            boolean bl = false;
            boolean bl2 = false;
            MarkdownTableSeparatorRow it = markdownTableSeparatorRow2;
            boolean bl3 = false;
            result.add(it.getTextRange());
        }
        return result;
    }

    @Nullable
    public final MarkdownTableSeparatorRow getSeparatorRow(@NotNull MarkdownTableImpl $this$separatorRow) {
        Intrinsics.checkNotNullParameter((Object)$this$separatorRow, (String)"$this$separatorRow");
        PsiElement psiElement = $this$separatorRow.getFirstChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"firstChild");
        Sequence $this$filterIsInstance$iv = PsiTreeUtilKt.siblings((PsiElement)psiElement, (boolean)true, (boolean)true);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)separatorRow$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        return (MarkdownTableSeparatorRow)SequencesKt.firstOrNull((Sequence)sequence);
    }

    public final boolean isHeaderRow(@NotNull MarkdownTableRowImpl $this$isHeaderRow) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$isHeaderRow, (String)"$this$isHeaderRow");
            Sequence sequence = PsiTreeUtilKt.siblings((PsiElement)((PsiElement)$this$isHeaderRow), (boolean)false, (boolean)false);
            boolean bl = false;
            Sequence sequence2 = sequence;
            boolean bl2 = false;
            for (Object e : sequence2) {
                PsiElement it = (PsiElement)e;
                boolean bl3 = false;
                if (!(it instanceof MarkdownTableRowImpl)) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        return v0 == null;
    }

    public final boolean isLast(@NotNull MarkdownTableRowImpl $this$isLast) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$isLast, (String)"$this$isLast");
            Sequence sequence = PsiTreeUtilKt.siblings((PsiElement)((PsiElement)$this$isLast), (boolean)true, (boolean)false);
            boolean bl = false;
            Sequence sequence2 = sequence;
            boolean bl2 = false;
            for (Object e : sequence2) {
                PsiElement it = (PsiElement)e;
                boolean bl3 = false;
                if (!(it instanceof MarkdownTableRowImpl)) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        return v0 == null;
    }

    public final int getColumnsCount(@NotNull MarkdownTableRowImpl $this$columnsCount) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$columnsCount, (String)"$this$columnsCount");
        PsiElement psiElement = $this$columnsCount.getFirstChild();
        if (psiElement != null && (psiElement = PsiTreeUtilKt.siblings((PsiElement)psiElement, (boolean)true, (boolean)true)) != null) {
            PsiElement $this$count$iv = psiElement;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof MarkdownTableCellImpl)) continue;
                int n2 = ++count$iv;
                boolean bl2 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        } else {
            n = 0;
        }
        return n;
    }

    public final int getColumnsCount(@NotNull MarkdownTableImpl $this$columnsCount) {
        Intrinsics.checkNotNullParameter((Object)$this$columnsCount, (String)"$this$columnsCount");
        MarkdownTableRowImpl markdownTableRowImpl = $this$columnsCount.getHeaderRow();
        return markdownTableRowImpl != null ? this.getColumnsCount(markdownTableRowImpl) : 0;
    }

    @NotNull
    public final IntRange getColumnsIndices(@NotNull MarkdownTableImpl $this$columnsIndices) {
        Intrinsics.checkNotNullParameter((Object)$this$columnsIndices, (String)"$this$columnsIndices");
        return RangesKt.until((int)0, (int)this.getColumnsCount($this$columnsIndices));
    }

    @NotNull
    public final IntRange getColumnsIndices(@NotNull MarkdownTableRowImpl $this$columnsIndices) {
        Intrinsics.checkNotNullParameter((Object)$this$columnsIndices, (String)"$this$columnsIndices");
        return RangesKt.until((int)0, (int)this.getColumnsCount($this$columnsIndices));
    }

    @NotNull
    public final MarkdownTableSeparatorRow.CellAlignment getColumnAlignment(@NotNull MarkdownTableImpl $this$getColumnAlignment, int columnIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$getColumnAlignment, (String)"$this$getColumnAlignment");
        MarkdownTableSeparatorRow markdownTableSeparatorRow = this.getSeparatorRow($this$getColumnAlignment);
        MarkdownTableSeparatorRow.CellAlignment cellAlignment = markdownTableSeparatorRow != null ? markdownTableSeparatorRow.getCellAlignment(columnIndex) : null;
        Intrinsics.checkNotNull((Object)((Object)cellAlignment));
        return cellAlignment;
    }

    /*
     * WARNING - void declaration
     */
    public final int getFirstNonWhitespaceOffset(@NotNull MarkdownTableCellImpl $this$firstNonWhitespaceOffset) {
        int n;
        int n2;
        block2: {
            void $this$indexOfFirst$iv;
            Intrinsics.checkNotNullParameter((Object)$this$firstNonWhitespaceOffset, (String)"$this$firstNonWhitespaceOffset");
            int n3 = UtilsKt.getStartOffset((PsiElement)((PsiElement)$this$firstNonWhitespaceOffset));
            String string = $this$firstNonWhitespaceOffset.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
            CharSequence charSequence = string;
            n2 = n3;
            boolean $i$f$indexOfFirst = false;
            int n4 = 0;
            int n5 = $this$indexOfFirst$iv.length();
            while (n4 < n5) {
                void index$iv;
                char it = $this$indexOfFirst$iv.charAt((int)index$iv);
                boolean bl = false;
                if (it != ' ') {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        int n6 = n;
        return n2 + RangesKt.coerceAtLeast((int)n6, (int)0);
    }

    /*
     * WARNING - void declaration
     */
    public final int getLastNonWhitespaceOffset(@NotNull MarkdownTableCellImpl $this$lastNonWhitespaceOffset) {
        int n;
        int n2;
        block2: {
            void $this$indexOfLast$iv;
            Intrinsics.checkNotNullParameter((Object)$this$lastNonWhitespaceOffset, (String)"$this$lastNonWhitespaceOffset");
            int n3 = UtilsKt.getStartOffset((PsiElement)((PsiElement)$this$lastNonWhitespaceOffset));
            String string = $this$lastNonWhitespaceOffset.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
            CharSequence charSequence = string;
            n2 = n3;
            boolean $i$f$indexOfLast = false;
            int n4 = $this$indexOfLast$iv.length();
            --n4;
            boolean bl = false;
            while (n4 >= 0) {
                void index$iv;
                char it = $this$indexOfLast$iv.charAt((int)index$iv);
                boolean bl2 = false;
                if (it != ' ') {
                    n = index$iv;
                    break block2;
                }
                --index$iv;
            }
            n = -1;
        }
        int n5 = n;
        return n2 + RangesKt.coerceAtLeast((int)n5, (int)0);
    }

    @JvmStatic
    public static final boolean isProbablyInsideTableCell(@NotNull Document document, int caretOffset) {
        int offset;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (caretOffset == 0) {
            return false;
        }
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"document.charsSequence");
        CharSequence text = charSequence;
        int lineNumber = document.getLineNumber(caretOffset);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        boolean leftBarFound = false;
        int n = caretOffset - 1;
        int n2 = lineStartOffset;
        if (n >= n2) {
            while (true) {
                if (text.charAt(offset) == '|') {
                    leftBarFound = true;
                    break;
                }
                if (offset == n2) break;
                --offset;
            }
        }
        n2 = lineEndOffset;
        for (offset = caretOffset; offset < n2; ++offset) {
            if (text.charAt(offset) != '|') continue;
            return leftBarFound;
        }
        return false;
    }

    private TableUtils() {
    }

    static {
        TableUtils tableUtils;
        INSTANCE = tableUtils = new TableUtils();
    }
}

