/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.actions.column;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.actions.column.ColumnBasedTableAction;
import org.intellij.plugins.markdown.editor.tables.actions.column.SetColumnAlignmentAction$setSelected$;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b \u0018\u00002\u00020\u0001:\u0003\r\u000e\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "alignment", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow$CellAlignment;", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow$CellAlignment;)V", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "Center", "Left", "Right", "intellij.markdown"})
public abstract class SetColumnAlignmentAction
extends ToggleAction {
    private final MarkdownTableSeparatorRow.CellAlignment alignment;

    /*
     * WARNING - void declaration
     */
    public boolean isSelected(@NotNull AnActionEvent event) {
        void table;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (editor2 == null || file == null) {
            return false;
        }
        Pair<MarkdownTableImpl, Integer> pair = ColumnBasedTableAction.Companion.findTableAndIndex(event, file, editor2);
        MarkdownTableImpl markdownTableImpl = (MarkdownTableImpl)pair.component1();
        Integer columnIndex = (Integer)pair.component2();
        return table == null || columnIndex == null ? false : TableUtils.INSTANCE.getColumnAlignment((MarkdownTableImpl)table, columnIndex) == this.alignment;
    }

    /*
     * WARNING - void declaration
     */
    public void setSelected(@NotNull AnActionEvent event, boolean state) {
        void table;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (editor2 == null || file == null) {
            return;
        }
        Pair<MarkdownTableImpl, Integer> pair = ColumnBasedTableAction.Companion.findTableAndIndex(event, file, editor2);
        MarkdownTableImpl markdownTableImpl = (MarkdownTableImpl)pair.component1();
        Integer columnIndex = (Integer)pair.component2();
        if (table != null && columnIndex != null) {
            boolean $i$f$runWriteAction = false;
            ApplicationManager.getApplication().runWriteAction(new Computable(this, (MarkdownTableImpl)table, state, editor2, columnIndex){
                final /* synthetic */ SetColumnAlignmentAction this$0;
                final /* synthetic */ MarkdownTableImpl $table$inlined;
                final /* synthetic */ boolean $state$inlined;
                final /* synthetic */ Editor $editor$inlined;
                final /* synthetic */ Integer $columnIndex$inlined;
                {
                    this.this$0 = setColumnAlignmentAction;
                    this.$table$inlined = markdownTableImpl;
                    this.$state$inlined = bl;
                    this.$editor$inlined = editor2;
                    this.$columnIndex$inlined = n;
                }

                public final T compute() {
                    boolean bl = false;
                    Project project$iv = this.$table$inlined.getProject();
                    String name$iv = null;
                    String groupId$iv = null;
                    boolean $i$f$executeCommand = false;
                    CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(this){
                        final /* synthetic */ setSelected$$inlined$runWriteAction$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void run() {
                            boolean bl = false;
                            MarkdownTableSeparatorRow.CellAlignment actualAlignment = this.this$0.$state$inlined ? SetColumnAlignmentAction.access$getAlignment$p(this.this$0.this$0) : MarkdownTableSeparatorRow.CellAlignment.NONE;
                            MarkdownTableImpl markdownTableImpl = this.this$0.$table$inlined;
                            Document document = this.this$0.$editor$inlined.getDocument();
                            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                            TableModificationUtils.INSTANCE.updateColumnAlignment(markdownTableImpl, document, this.this$0.$columnIndex$inlined, actualAlignment);
                        }
                    }, name$iv, (Object)groupId$iv);
                    return (T)Unit.INSTANCE;
                }
            });
        }
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.update(event);
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (editor2 == null || file == null) {
            Presentation presentation = event.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"event.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        Pair<MarkdownTableImpl, Integer> pair = ColumnBasedTableAction.Companion.findTableAndIndex(event, file, editor2);
        MarkdownTableImpl table = (MarkdownTableImpl)pair.component1();
        Presentation presentation = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"event.presentation");
        MarkdownTableImpl markdownTableImpl = table;
        presentation.setEnabledAndVisible(markdownTableImpl != null && TableModificationUtils.INSTANCE.hasCorrectBorders(markdownTableImpl));
    }

    public SetColumnAlignmentAction(@NotNull MarkdownTableSeparatorRow.CellAlignment alignment) {
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        this.alignment = alignment;
    }

    public static final /* synthetic */ MarkdownTableSeparatorRow.CellAlignment access$getAlignment$p(SetColumnAlignmentAction $this) {
        return $this.alignment;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction$Left;", "Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction;", "()V", "intellij.markdown"})
    public static final class Left
    extends SetColumnAlignmentAction {
        public Left() {
            super(MarkdownTableSeparatorRow.CellAlignment.LEFT);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction$Center;", "Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction;", "()V", "intellij.markdown"})
    public static final class Center
    extends SetColumnAlignmentAction {
        public Center() {
            super(MarkdownTableSeparatorRow.CellAlignment.CENTER);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction$Right;", "Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction;", "()V", "intellij.markdown"})
    public static final class Right
    extends SetColumnAlignmentAction {
        public Right() {
            super(MarkdownTableSeparatorRow.CellAlignment.RIGHT);
        }
    }
}

