/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.handlers;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCellImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableImpl;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableEnterHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegateAdapter;", "()V", "firstEnterPosition", "", "Ljava/lang/Integer;", "preprocessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caretOffset", "Lcom/intellij/openapi/util/Ref;", "caretAdvance", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "Companion", "intellij.markdown"})
public final class MarkdownTableEnterHandler
extends EnterHandlerDelegateAdapter {
    private Integer firstEnterPosition;
    private static final String insertTag = "<br/>";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        Integer cellIndex;
        MarkdownTableCellImpl cell;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter(caretOffset, (String)"caretOffset");
                Intrinsics.checkNotNullParameter(caretAdvance, (String)"caretAdvance");
                Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
                if (!Registry.is((String)"markdown.tables.editing.support.enable")) break block7;
                Project project = file.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
                if (MarkdownSettings.Companion.getInstance(project).isEnhancedEditingEnabled()) break block8;
            }
            EnterHandlerDelegate.Result result = super.preprocessEnter(file, editor2, caretOffset, caretAdvance, dataContext, originalHandler);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"super.preprocessEnter(fi\u2026Context, originalHandler)");
            return result;
        }
        Integer enterPosition = this.firstEnterPosition;
        this.firstEnterPosition = null;
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        Caret caret = caretModel.getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"editor.caretModel.currentCaret");
        int actualCaretOffset = caret.getOffset();
        if (!TableUtils.isProbablyInsideTableCell(document2, actualCaretOffset)) {
            EnterHandlerDelegate.Result result = super.preprocessEnter(file, editor2, caretOffset, caretAdvance, dataContext, originalHandler);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"super.preprocessEnter(fi\u2026Context, originalHandler)");
            return result;
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document2);
        MarkdownTableCellImpl markdownTableCellImpl = cell = TableUtils.findCell(file, actualCaretOffset);
        MarkdownTableImpl table = markdownTableCellImpl != null ? markdownTableCellImpl.getParentTable() : null;
        MarkdownTableCellImpl markdownTableCellImpl2 = cell;
        Integer n = cellIndex = markdownTableCellImpl2 != null ? Integer.valueOf(markdownTableCellImpl2.getColumnIndex()) : null;
        if (cell == null || table == null || cellIndex == null) {
            EnterHandlerDelegate.Result result = super.preprocessEnter(file, editor2, caretOffset, caretAdvance, dataContext, originalHandler);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"super.preprocessEnter(fi\u2026Context, originalHandler)");
            return result;
        }
        Integer n2 = enterPosition;
        if (n2 != null && actualCaretOffset == n2) {
            int start = actualCaretOffset - insertTag.length();
            int end = actualCaretOffset;
            if (actualCaretOffset > insertTag.length() && Intrinsics.areEqual((Object)document2.getText(new TextRange(start, end)), (Object)insertTag)) {
                Project project$iv = null;
                String name$iv = null;
                String groupId$iv = null;
                boolean $i$f$executeCommand = false;
                CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(document2, start, end){
                    final /* synthetic */ Document $document$inlined;
                    final /* synthetic */ int $start$inlined;
                    final /* synthetic */ int $end$inlined;
                    {
                        this.$document$inlined = document;
                        this.$start$inlined = n;
                        this.$end$inlined = n2;
                    }

                    public final void run() {
                        boolean bl = false;
                        this.$document$inlined.deleteString(this.$start$inlined, this.$end$inlined);
                    }
                }, name$iv, (Object)groupId$iv);
                caretOffset.set((Object)start);
            }
            EnterHandlerDelegate.Result result = super.preprocessEnter(file, editor2, caretOffset, caretAdvance, dataContext, originalHandler);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"super.preprocessEnter(fi\u2026Context, originalHandler)");
            return result;
        }
        caretAdvance.set((Object)insertTag.length());
        Project project$iv = null;
        String name$iv = null;
        String groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(editor2){
            final /* synthetic */ Editor $editor$inlined;
            {
                this.$editor$inlined = editor2;
            }

            public final void run() {
                boolean bl = false;
                EditorModificationUtil.insertStringAtCaret((Editor)this.$editor$inlined, (String)"<br/>");
            }
        }, name$iv, (Object)groupId$iv);
        this.firstEnterPosition = actualCaretOffset + insertTag.length();
        return EnterHandlerDelegate.Result.Stop;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableEnterHandler$Companion;", "", "()V", "insertTag", "", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

