/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.execution.process.ConsoleHighlighter;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.Icon;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCompositePsiElementBase;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownParagraphImpl;
import org.intellij.plugins.markdown.structureView.MarkdownBasePresentation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownListItemImpl
extends MarkdownCompositePsiElementBase {
    public MarkdownListItemImpl(@NotNull ASTNode node) {
        if (node == null) {
            MarkdownListItemImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Nullable
    public PsiElement getMarkerElement() {
        PsiElement child = this.getFirstChild();
        if (child != null && MarkdownTokenTypeSets.LIST_MARKERS.contains(child.getNode().getElementType())) {
            return child;
        }
        return null;
    }

    @Nullable
    public PsiElement getCheckBox() {
        PsiElement markerElement = this.getMarkerElement();
        if (markerElement == null) {
            return null;
        }
        PsiElement candidate = markerElement.getNextSibling();
        if (candidate != null && candidate.getNode().getElementType() == MarkdownTokenTypes.CHECK_BOX) {
            return candidate;
        }
        return null;
    }

    @Override
    public ItemPresentation getPresentation() {
        return new MyItemPresentation();
    }

    @Override
    public String getPresentableTagName() {
        return "li";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/intellij/plugins/markdown/lang/psi/impl/MarkdownListItemImpl", "<init>"));
    }

    private class MyItemPresentation
    extends MarkdownBasePresentation
    implements ColoredItemPresentation {
        private MyItemPresentation() {
        }

        @Nullable
        public String getPresentableText() {
            if (!MarkdownListItemImpl.this.isValid()) {
                return null;
            }
            PsiElement markerElement = MarkdownListItemImpl.this.getMarkerElement();
            if (markerElement == null) {
                return null;
            }
            return markerElement.getText().trim();
        }

        @Nullable
        public String getLocationString() {
            if (!MarkdownListItemImpl.this.isValid()) {
                return null;
            }
            if (ContainerUtil.getFirstItem(MarkdownListItemImpl.this.getCompositeChildren()) instanceof MarkdownParagraphImpl) {
                MarkdownCompositePsiElementBase element2 = (MarkdownCompositePsiElementBase)MarkdownListItemImpl.this.findChildByClass(MarkdownCompositePsiElementBase.class);
                assert (element2 != null);
                return StringUtil.shortenTextWithEllipsis((String)element2.getText(), (int)50, (int)0);
            }
            return null;
        }

        @Override
        @Nullable
        public Icon getIcon(boolean unused) {
            return null;
        }

        @Nullable
        public TextAttributesKey getTextAttributesKey() {
            PsiElement checkBox = MarkdownListItemImpl.this.getCheckBox();
            if (checkBox == null) {
                return null;
            }
            if (checkBox.textContains('x') || checkBox.textContains('X')) {
                return ConsoleHighlighter.GREEN;
            }
            return ConsoleHighlighter.RED;
        }
    }
}

