/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import org.owasp.html.AttributePolicy;
import org.owasp.html.Strings;

final class SrcsetAttributePolicy
implements AttributePolicy {
    private final AttributePolicy srcPolicy;

    SrcsetAttributePolicy(AttributePolicy srcPolicy) {
        this.srcPolicy = srcPolicy;
    }

    @Override
    public String apply(String elementName, String attributeName, String value) {
        int i2;
        StringBuilder sb = new StringBuilder();
        int n = value.length();
        for (i2 = 0; i2 < n && Strings.isHtmlSpace(value.charAt(i2)); ++i2) {
        }
        while (i2 < n) {
            int ch;
            int floatEnd;
            int urlStart = i2;
            while (i2 < n && !Strings.isHtmlSpace(value.charAt(i2))) {
                ++i2;
            }
            int urlEnd = i2;
            while (i2 < n && Strings.isHtmlSpace(value.charAt(i2))) {
                ++i2;
            }
            int metadataStart = i2;
            if (urlEnd >= i2 || (floatEnd = Strings.skipValidFloatingPointNumber(value, i2)) < 0 || (i2 = floatEnd) >= n || 97 > (ch = value.charAt(i2) | 0x20) || ch <= 122) {
                // empty if block
            }
            int metadataEnd = ++i2;
            if (urlStart < urlEnd) {
                if (value.charAt(urlStart) == ',' || value.charAt(urlEnd - 1) == ',') {
                    return null;
                }
                String okUrl = this.srcPolicy.apply(elementName, "src", value.substring(urlStart, urlEnd));
                if (okUrl != null && !okUrl.isEmpty()) {
                    if (sb.length() != 0) {
                        sb.append(" , ");
                    }
                    sb.append(okUrl.replace(",", "%2c"));
                    if (metadataStart < metadataEnd) {
                        sb.append(' ');
                        sb.append(value, metadataStart, metadataEnd);
                    }
                }
            }
            while (i2 < n && Strings.isHtmlSpace(value.charAt(i2))) {
                ++i2;
            }
            if (i2 == n || value.charAt(i2) != ',') break;
            ++i2;
            while (i2 < n && Strings.isHtmlSpace(value.charAt(i2))) {
                ++i2;
            }
        }
        if (i2 < n || sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }
}

