/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;

public class GroovyOverlyComplexBooleanExpressionInspectionBase
extends BaseInspection {
    private static final int TERM_LIMIT = 3;
    public int m_limit = 3;

    private int getLimit() {
        return this.m_limit;
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.overly.complex.boolean.expression", new Object[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            if (expression == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression);
            this.checkExpression(expression);
        }

        @Override
        public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
            if (expression == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitUnaryExpression(expression);
            this.checkExpression(expression);
        }

        @Override
        public void visitParenthesizedExpression(@NotNull GrParenthesizedExpression expression) {
            if (expression == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            super.visitParenthesizedExpression(expression);
            this.checkExpression(expression);
        }

        private void checkExpression(GrExpression expression) {
            if (!this.isBoolean(expression)) {
                return;
            }
            if (this.isParentBoolean(expression)) {
                return;
            }
            int numTerms = this.countTerms(expression);
            if (numTerms <= GroovyOverlyComplexBooleanExpressionInspectionBase.this.getLimit()) {
                return;
            }
            this.registerError(expression);
        }

        private int countTerms(GrExpression expression) {
            if (expression == null) {
                return 0;
            }
            if (!this.isBoolean(expression)) {
                return 1;
            }
            if (expression instanceof GrBinaryExpression) {
                GrBinaryExpression binaryExpression = (GrBinaryExpression)expression;
                GrExpression lhs = binaryExpression.getLeftOperand();
                GrExpression rhs = binaryExpression.getRightOperand();
                return this.countTerms(lhs) + this.countTerms(rhs);
            }
            if (expression instanceof GrUnaryExpression) {
                GrUnaryExpression prefixExpression = (GrUnaryExpression)expression;
                GrExpression operand = prefixExpression.getOperand();
                return this.countTerms(operand);
            }
            if (expression instanceof GrParenthesizedExpression) {
                GrParenthesizedExpression parenthesizedExpression = (GrParenthesizedExpression)expression;
                GrExpression contents = parenthesizedExpression.getOperand();
                return this.countTerms(contents);
            }
            return 1;
        }

        private boolean isParentBoolean(GrExpression expression) {
            PsiElement parent2 = expression.getParent();
            if (!(parent2 instanceof GrExpression)) {
                return false;
            }
            return this.isBoolean((GrExpression)parent2);
        }

        private boolean isBoolean(GrExpression expression) {
            if (expression instanceof GrBinaryExpression) {
                GrBinaryExpression binaryExpression = (GrBinaryExpression)expression;
                IElementType sign = binaryExpression.getOperationTokenType();
                return GroovyTokenTypes.mLAND.equals(sign) || GroovyTokenTypes.mLOR.equals(sign);
            }
            if (expression instanceof GrUnaryExpression) {
                GrUnaryExpression prefixExpression = (GrUnaryExpression)expression;
                IElementType sign = prefixExpression.getOperationTokenType();
                return GroovyTokenTypes.mLNOT.equals(sign);
            }
            if (expression instanceof GrParenthesizedExpression) {
                GrParenthesizedExpression parenthesizedExpression = (GrParenthesizedExpression)expression;
                GrExpression contents = parenthesizedExpression.getOperand();
                return this.isBoolean(contents);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyOverlyComplexBooleanExpressionInspectionBase$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBinaryExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUnaryExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParenthesizedExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

